/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface  The Monotype Corporation plc. Data  The Monotype Corporation plc /
 * Type Solutions Inc. 1990-91 All Rights Reserved
 * 
 * Trademark:
 * Century Gothic is a trademark of The Monotype Corporation plc.
 * 
 * Description:
 * A design based on Monotype 20th Century, which was drawn by Sol Hess between
 * 1936 and 1947. Century Gothic maintains the basic design of 20th Century but has
 * an enlarged 'x' height and has been modified to ensure satisfactory output from
 * modern digital systems. The design is influenced by the geometric style sans
 * serif faces which were popular during the 1920's and 30's. Useful for headlines
 * and general display work and for small quantities of text, particularly in
 * advertising.
 * 
 * Manufacturer:
 * Monotype Typography, Inc.
 * 
 * Designer:
 * Monotype Type Drawing Office
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_welcome.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":256,"face":{"font-family":"Century Gothic","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 5 2 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-61 -382 415 110","underline-thickness":"20.918","underline-position":"-24.2578","unicode-range":"U+0020-U+F108"},"glyphs":{" ":{"w":99},"!":{"d":"66,-265r0,200r-26,0r0,-200r26,0xm31,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22","w":106},"\"":{"d":"99,-184r-18,0r-4,-81r26,0xm31,-184r-19,0r-4,-81r26,0","w":111},"#":{"d":"217,-106r0,19r-44,0r-13,87r-19,0r12,-87r-58,0r-13,87r-20,0r14,-87r-44,0r0,-19r47,0r9,-59r-45,0r0,-19r47,0r13,-82r18,0r-11,82r58,0r12,-82r20,0r-13,82r40,0r0,19r-42,0r-9,59r41,0xm165,-165r-58,0r-9,59r58,0","w":259},"$":{"d":"29,-197v0,-37,27,-58,64,-62r0,-18r23,0r0,19v26,6,39,15,53,36r-19,15v-9,-14,-20,-22,-34,-25r0,87v48,28,72,32,72,82v0,41,-28,65,-72,69r0,55r-23,0r0,-55v-41,-3,-63,-19,-80,-46r18,-14v16,22,37,34,62,36r0,-109v-40,-20,-64,-24,-64,-70xm93,-234v-31,0,-49,33,-31,58v6,9,17,16,31,22r0,-80xm116,-19v36,-2,62,-41,37,-71v-7,-9,-19,-17,-37,-27r0,98","w":199},"%":{"d":"68,-265v49,9,106,12,154,-5r21,0r-189,288r-23,0r171,-262v-22,6,-52,7,-83,7v29,39,-4,94,-51,94v-33,0,-62,-28,-60,-61v1,-35,25,-60,60,-61xm108,-204v0,-20,-19,-39,-39,-39v-20,0,-39,19,-39,39v0,20,18,38,39,38v21,0,39,-18,39,-38xm149,-53v0,-33,28,-61,61,-61v33,0,61,28,61,61v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61xm249,-53v1,-20,-18,-39,-39,-39v-21,0,-38,18,-38,39v0,20,18,38,38,38v21,0,39,-18,39,-38","w":278},"&":{"d":"175,-202v-2,32,-19,42,-45,65r66,68v19,-16,19,-16,31,-27r18,19v-11,10,-22,19,-31,26r49,51r-36,0r-33,-35v-37,27,-49,42,-96,42v-37,0,-67,-25,-67,-60v0,-45,26,-56,63,-88v-20,-27,-34,-32,-34,-61v0,-64,118,-61,115,0xm117,-224v-21,0,-38,16,-28,35v6,10,15,21,25,33v18,-14,30,-26,35,-46v0,-14,-15,-22,-32,-22xm57,-55v1,29,39,47,70,32v14,-6,30,-17,49,-30r-65,-69v-31,26,-47,34,-54,67","w":272},"'":{"d":"45,-184r-18,0r-4,-81r26,0","w":71},"(":{"d":"111,-270v-46,84,-50,251,-9,345r-27,0v-39,-94,-36,-257,8,-345r28,0","w":132},")":{"d":"57,-270v41,93,37,257,-7,345r-28,0v45,-87,51,-252,8,-345r27,0","w":132},"*":{"d":"65,-265r23,0r-5,52r43,-31r11,20r-48,22r48,21r-11,20r-43,-30r5,52r-23,0r5,-52r-43,30r-12,-20r50,-21r-50,-22r12,-20r43,31","w":152},"+":{"d":"97,-141r0,-77r24,0r0,77r77,0r0,24r-77,0r0,76r-24,0r0,-76r-77,0r0,-24r77,0","w":218},",":{"d":"52,-47r24,11r-36,66r-18,-7","w":99},"-":{"d":"11,-108r97,0r0,22r-97,0r0,-22","w":119},"\u00ad":{"d":"11,-108r97,0r0,22r-97,0r0,-22","w":119},".":{"d":"33,-17v0,-12,10,-22,21,-22v12,0,22,10,22,22v0,12,-9,23,-22,22v-12,0,-21,-10,-21,-22","w":99},"\/":{"d":"147,-265r-107,300r-27,0r107,-300r27,0","w":157},"0":{"d":"98,7v-66,0,-87,-58,-87,-136v0,-79,19,-136,87,-136v68,0,90,59,90,136v0,77,-23,136,-90,136xm99,-240v-51,6,-63,48,-63,111v0,64,11,112,63,112v52,0,65,-55,65,-112v0,-59,-14,-107,-65,-111","w":199},"1":{"d":"67,-259r50,0r0,259r-25,0r0,-233r-41,0","w":199},"2":{"d":"102,-240v-37,0,-58,25,-60,62r-25,0v0,-50,38,-86,86,-87v60,-2,101,64,69,118v-21,36,-74,87,-105,122r119,0r0,25r-175,0r99,-107v29,-34,45,-39,48,-80v2,-29,-26,-54,-56,-53","w":199},"3":{"d":"97,-240v-29,1,-39,16,-49,41r-27,0v8,-38,34,-64,76,-66v69,-4,103,88,41,120v26,9,48,37,48,68v0,71,-91,109,-144,64v-15,-13,-24,-31,-29,-56r25,0v8,32,25,49,60,50v35,1,62,-24,62,-56v0,-41,-29,-55,-76,-56r0,-24v32,-1,60,-12,60,-43v1,-24,-21,-43,-47,-42","w":199},"4":{"d":"153,-265r6,0r0,180r31,0r0,25r-31,0r0,60r-26,0r0,-60r-124,0xm133,-85r0,-108r-76,108r76,0","w":199},"5":{"d":"157,-85v0,-59,-64,-73,-116,-45r24,-129r112,0r0,25r-92,0r-13,71v61,-20,112,20,112,79v0,102,-158,126,-169,21r26,0v5,28,23,44,54,45v35,1,62,-31,62,-67","w":199},"6":{"d":"103,7v-57,0,-96,-57,-72,-113v24,-55,70,-108,101,-159r21,14r-70,106v53,-20,102,21,101,72v-1,47,-34,80,-81,80xm158,-73v0,-29,-25,-54,-54,-54v-30,0,-55,25,-55,54v0,29,26,54,55,54v28,0,54,-26,54,-54","w":199},"7":{"d":"26,-259r164,0r-138,266r-22,-11r120,-230r-124,0r0,-25","w":199},"8":{"d":"175,-197v0,29,-16,43,-37,55v28,15,48,31,49,68v0,48,-37,81,-88,81v-51,0,-87,-35,-87,-79v0,-36,21,-55,50,-70v-22,-11,-38,-29,-38,-56v0,-39,34,-67,77,-67v42,0,74,28,74,68xm149,-198v0,-23,-20,-42,-49,-42v-26,0,-49,18,-49,43v-1,23,26,46,50,45v26,-2,48,-19,48,-46xm161,-74v0,-29,-29,-55,-60,-55v-34,0,-64,27,-63,58v1,33,27,53,62,53v35,1,61,-24,61,-56","w":199},"9":{"d":"98,-265v82,-2,89,94,49,155r-78,117r-21,-14r70,-106v-53,20,-101,-21,-100,-72v0,-49,34,-79,80,-80xm43,-185v0,28,26,54,54,54v29,0,55,-25,55,-54v0,-29,-26,-55,-55,-55v-29,0,-54,26,-54,55","w":199},":":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm33,-17v0,-12,10,-22,21,-22v12,0,22,10,22,22v0,12,-9,23,-22,22v-12,0,-21,-10,-21,-22","w":99},";":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm52,-47r24,11r-36,66r-18,-7","w":99},"\u037e":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm52,-47r24,11r-36,66r-18,-7","w":99},"<":{"d":"200,-61r0,26r-182,-83r0,-23r182,-82r0,25r-148,69","w":218},"=":{"d":"198,-180r0,24r-178,0r0,-24r178,0xm198,-103r0,24r-178,0r0,-24r178,0","w":218},">":{"d":"18,-61r148,-68r-148,-69r0,-25r182,82r0,23r-182,83r0,-26","w":218},"?":{"d":"107,-240v-31,0,-52,19,-52,52r-25,0v-1,-47,31,-77,77,-77v62,0,97,63,52,102v-19,16,-88,25,-87,56v0,16,18,26,36,26v26,0,35,-13,38,-37r26,0v-2,38,-25,62,-64,62v-34,0,-62,-20,-62,-51v0,-65,106,-45,109,-97v1,-22,-23,-36,-48,-36xm85,-17v0,-12,10,-22,22,-22v11,0,21,10,21,22v0,12,-9,22,-21,22v-12,0,-23,-9,-22,-22","w":212},"@":{"d":"38,-133v-6,114,153,162,216,80r18,0v-29,37,-54,58,-108,58v-82,0,-140,-55,-140,-137v0,-81,56,-137,138,-139v65,-2,126,52,126,113v0,59,-39,99,-90,104v-13,1,-22,-4,-21,-19v-31,38,-101,8,-97,-46v3,-42,30,-85,75,-83v24,1,35,9,46,26r5,-24r19,0r-22,122v0,5,3,10,9,9v34,-6,62,-42,62,-85v0,-58,-53,-102,-113,-101v-74,1,-119,50,-123,122xm157,-183v-56,-3,-75,107,-10,108v50,1,68,-107,10,-108","w":312},"A":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"B":{"d":"187,-74v0,44,-37,75,-84,74r-71,0r0,-259v69,-3,134,0,134,64v0,26,-14,44,-33,54v32,11,54,28,54,67xm139,-195v1,-39,-40,-40,-82,-38r0,83v47,2,80,-5,82,-45xm160,-74v0,-47,-45,-52,-103,-50r0,99v55,2,103,-1,103,-49","w":206},"C":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138","w":292},"D":{"d":"249,-126v0,81,-45,128,-135,126r-83,0r0,-259r54,0v111,-3,164,38,164,133xm223,-126v0,-89,-61,-113,-167,-107r0,209v104,5,167,-13,167,-102","w":267},"E":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259","w":193},"F":{"d":"31,-259r130,0r0,26r-104,0r0,81r104,0r0,25r-104,0r0,127r-26,0r0,-259","w":174},"G":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136","w":313},"H":{"d":"31,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259","w":245},"I":{"d":"28,-259r26,0r0,259r-26,0r0,-259","w":81},"J":{"d":"29,-41v36,34,87,33,87,-44r0,-174r26,0r0,175v15,96,-75,110,-127,63","w":173},"K":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259","w":212},"L":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259","w":166},"M":{"d":"20,0r36,-259r5,0r105,213r104,-213r4,0r37,259r-25,0r-26,-185r-91,185r-7,0r-92,-186r-25,186r-25,0","w":330},"N":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0","w":266},"O":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"P":{"d":"193,-190v-4,67,-55,73,-136,70r0,120r-26,0r0,-259r52,0v74,-3,102,12,110,69xm166,-190v0,-49,-56,-44,-109,-43r0,87v52,2,109,7,109,-44","w":213},"Q":{"d":"293,-129v-1,46,-18,76,-45,101r39,48r-32,0r-26,-33v-90,57,-212,-14,-208,-115v3,-80,55,-135,135,-137v75,-2,138,62,137,136xm47,-128v-3,81,92,138,165,94r-57,-73r31,0r46,59v70,-63,23,-196,-75,-192v-64,3,-108,47,-110,112","w":313},"R":{"d":"195,-190v0,50,-35,70,-90,70r93,120r-32,0r-93,-120r-14,0r0,120r-26,0r0,-259v84,-2,162,-5,162,69xm168,-190v0,-49,-56,-44,-109,-43r0,88v53,1,109,5,109,-45","w":218},"S":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70","w":179},"T":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0","w":153},"U":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266","w":235},"V":{"d":"12,-259r28,0r86,200r87,-200r28,0r-113,259r-5,0","w":252},"W":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0","w":345},"X":{"d":"18,-259r30,0r62,101r62,-101r30,0r-77,126r82,133r-30,0r-67,-108r-68,108r-30,0r83,-133","w":219},"Y":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124","w":213},"Z":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0","w":172},"[":{"d":"51,-265r59,0r0,25r-34,0r0,286r34,0r0,24r-59,0r0,-335","w":126},"\\":{"d":"39,-265r167,300r-27,0r-167,-300r27,0","w":217},"]":{"d":"75,70r-59,0r0,-25r35,0r0,-286r-35,0r0,-24r59,0r0,335","w":126},"^":{"d":"111,-259r20,0r90,195r-23,0r-78,-168r-76,168r-23,0","w":241},"_":{"d":"-2,27r184,0r0,18r-184,0r0,-18","w":180},"`":{"d":"57,-281r39,54r-25,0r-51,-54r37,0","w":136},"a":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"b":{"d":"129,5v-36,-1,-59,-18,-76,-40r0,35r-24,0r0,-265r24,0r0,107v17,-23,41,-37,77,-38v54,-2,98,48,98,101v0,53,-45,101,-99,100xm52,-97v0,42,34,79,75,78v45,-1,76,-32,76,-77v0,-44,-31,-78,-75,-78v-44,0,-76,30,-76,77","w":245},"c":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99","w":232},"d":{"d":"118,-196v36,1,59,17,76,40r0,-109r24,0r0,265r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm196,-95v0,-42,-35,-78,-76,-77v-45,1,-76,32,-76,77v0,44,32,77,76,77v44,0,76,-31,76,-77","w":246},"e":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0","w":233},"f":{"d":"39,-191v-1,-42,-2,-81,39,-79v8,0,17,2,28,5r0,24v-23,-10,-47,-11,-42,24r0,26r40,0r0,21r-40,0r0,170r-25,0r0,-170r-25,0r0,-21r25,0","w":113},"g":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74","w":242},"h":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-265r25,0r0,108v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173","w":219},"i":{"d":"16,-250v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-11,0,-20,-10,-20,-21xm24,-191r25,0r0,191r-25,0r0,-191","w":72},"j":{"d":"16,-250v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21xm-11,47v21,10,35,5,35,-25r0,-213r25,0r0,220v4,42,-26,55,-60,40r0,-22","w":73},"k":{"d":"27,-265r25,0r0,151r88,-77r37,0r-105,91r111,100r-35,0r-96,-86r0,86r-25,0r0,-265","w":180},"l":{"d":"24,-265r24,0r0,265r-24,0r0,-265","w":72},"m":{"d":"113,-172v-73,0,-61,94,-61,172r-25,0r0,-191r25,0r0,33v15,-22,34,-38,65,-38v35,1,51,18,61,46v13,-26,36,-45,70,-46v85,-1,62,111,65,196r-25,0v-7,-66,25,-173,-45,-172v-74,1,-60,94,-61,172r-24,0v-6,-66,23,-172,-45,-172","w":337},"n":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173","w":219},"o":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"p":{"d":"129,5v-35,-2,-59,-16,-77,-38r0,103r-24,0r0,-261r24,0r0,35v17,-23,40,-39,76,-40v54,-1,99,47,99,100v0,53,-45,102,-98,101xm202,-95v0,-45,-31,-76,-76,-77v-41,-1,-76,35,-76,77v0,46,33,77,77,77v43,0,75,-34,75,-77","w":245},"q":{"d":"117,-196v37,1,60,17,77,40r0,-35r24,0r0,261r-24,0r0,-103v-18,23,-42,36,-77,38v-53,1,-98,-47,-98,-101v0,-53,45,-101,98,-100xm195,-95v1,-42,-35,-78,-76,-77v-45,1,-76,33,-76,77v0,42,32,77,76,77v44,0,75,-31,76,-77","w":245},"r":{"d":"43,0r-25,0r0,-191r25,0r0,28v15,-23,40,-43,72,-27r-13,21v-75,-15,-56,95,-59,169","w":108},"s":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96","w":139},"t":{"d":"49,-262r25,0r0,71r39,0r0,21r-39,0r0,170r-25,0r0,-170r-34,0r0,-21r34,0r0,-71","w":121},"u":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196","w":218},"v":{"d":"9,-191r27,0r63,139r64,-139r26,0r-87,191r-5,0","w":199},"w":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0","w":299},"x":{"d":"6,-191r29,0r51,71r50,-71r30,0r-65,91r73,100r-30,0r-58,-80r-58,80r-29,0r72,-100","w":172},"y":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84","w":193},"z":{"d":"12,-191r140,0r-108,169r105,0r0,22r-147,0r108,-170r-98,0r0,-21","w":152},"{":{"d":"50,-7v0,-44,-2,-64,-37,-68r0,-29v40,-4,37,-33,37,-81v0,-56,12,-76,65,-74r0,28v-29,0,-37,5,-36,36v0,63,1,86,-36,105v29,14,36,33,36,80v0,48,-7,62,36,62r0,27v-59,2,-65,-24,-65,-86","w":126},"|":{"d":"108,-265r25,0r0,335r-25,0r0,-335","w":241},"}":{"d":"77,-172v-1,45,1,64,36,68r0,29v-39,0,-37,40,-36,80v1,55,-12,77,-66,74r0,-27v29,0,37,-5,36,-36v0,-63,1,-87,37,-106v-31,-16,-36,-31,-37,-79v0,-52,6,-60,-36,-62r0,-28v59,-2,67,25,66,87","w":126},"~":{"d":"154,-128v21,-1,21,-7,44,-19r0,28v-20,10,-25,15,-44,17v-22,3,-66,-28,-88,-28v-21,0,-26,7,-46,19r0,-29v20,-10,25,-14,44,-16v22,-2,65,29,90,28","w":218},"\u00c4":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm77,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm149,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":266},"\u00c5":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm95,-312v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm152,-312v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19","w":266},"\u00c7":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm161,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":292},"\u00c9":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm119,-333r38,0r-52,54r-24,0","w":193},"\u00d1":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0xm69,-302v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":266},"\u00d6":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm100,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm172,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":312},"\u00dc":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm62,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm134,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":235},"\u00e1":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm134,-281r38,0r-52,54r-24,0","w":245},"\u00e0":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm112,-281r39,54r-25,0r-51,-54r37,0","w":245},"\u00e2":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm112,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":245},"\u00e4":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm67,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm139,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":245},"\u00e3":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm59,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":245},"\u00e5":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm85,-260v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm142,-260v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19","w":245},"\u00e7":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm131,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":232},"\u00e9":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm129,-281r38,0r-52,54r-24,0","w":233},"\u00e8":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm106,-281r39,54r-25,0r-51,-54r37,0","w":233},"\u00ea":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm106,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":233},"\u00eb":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm61,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm133,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":233},"\u00ed":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm48,-281r38,0r-52,54r-24,0","w":72},"\u00ec":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm25,-281r39,54r-25,0r-51,-54r37,0","w":72},"\u00ee":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm25,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":72},"\u00ef":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-20,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm52,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":72},"\u00f1":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm46,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":219},"\u00f3":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm129,-281r38,0r-52,54r-24,0","w":235},"\u00f2":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm107,-281r39,54r-25,0r-51,-54r37,0","w":235},"\u00f4":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm107,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":235},"\u00f6":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm62,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm134,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":235},"\u00f5":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm54,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":235},"\u00fa":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm121,-281r38,0r-52,54r-24,0","w":218},"\u00f9":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm98,-281r39,54r-25,0r-51,-54r37,0","w":218},"\u00fb":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm98,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":218},"\u00fc":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm53,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm125,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":218},"\u2020":{"d":"86,-265r26,0r-4,80r63,-3r0,26r-63,-5r5,222r-27,0r5,-222r-63,5r0,-26r63,3","w":199},"\u00b0":{"d":"72,-265v33,0,61,28,61,60v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61v0,-33,28,-60,61,-60xm72,-163v21,0,40,-20,40,-41v0,-22,-18,-42,-39,-42v-22,0,-41,18,-41,41v0,22,18,42,40,42","w":143},"\u00a2":{"d":"55,-14v-79,-56,-19,-220,91,-176r23,-46r21,11r-23,45v8,5,15,11,20,17r-15,18v-5,-5,-10,-9,-16,-13r-70,134v32,13,52,4,80,-16r16,18v-24,22,-67,36,-107,20r-26,52r-21,-11xm134,-169v-74,-28,-121,80,-68,132","w":199},"\u00a3":{"d":"10,-27v0,-30,35,-52,64,-33v4,-25,1,-45,-6,-66r-51,0r0,-22r45,0v-35,-70,10,-137,81,-110v18,12,29,30,31,60r-24,0v0,-25,-12,-44,-36,-44v-52,-1,-41,59,-26,94r57,0r0,22r-51,0v7,24,10,56,3,80v10,7,30,25,49,26v11,0,17,-13,18,-40r25,0v-1,33,-10,67,-40,67v-24,0,-46,-16,-61,-29v-13,39,-77,39,-78,-5xm34,-30v4,21,28,14,34,-6v-14,-11,-32,-12,-34,6","w":199},"\u00a7":{"d":"69,-161v-53,-25,-34,-114,34,-109v39,3,62,23,66,60r-25,0v1,-44,-81,-47,-81,-4v0,63,113,55,113,123v0,27,-25,47,-51,52v20,13,38,31,39,59v2,75,-129,68,-136,4r26,0v7,38,84,38,84,-4v0,-61,-115,-61,-115,-128v0,-30,21,-46,46,-53xm105,-54v31,-1,59,-31,37,-58v-5,-5,-25,-21,-53,-35v-32,1,-53,36,-31,61v8,9,24,20,47,32","w":221},"\u2022":{"d":"55,-131v0,-28,26,-54,54,-54v28,0,54,26,54,54v0,28,-26,54,-54,54v-28,0,-54,-26,-54,-54","w":218},"\u00b6":{"d":"17,-194v0,-43,24,-72,72,-72r91,0r0,13r-15,0r0,294r-21,0r0,-294r-38,0r0,294r-21,0r0,-165v-46,0,-68,-26,-68,-70","w":203},"\u00df":{"d":"103,-246v-38,4,-50,21,-50,73r0,173r-25,0r0,-175v-2,-65,20,-91,74,-95v40,-3,71,26,70,64v-1,36,-24,54,-58,59v43,5,64,33,67,75v3,57,-59,96,-110,68r0,-23v39,23,85,0,85,-45v0,-40,-28,-61,-69,-61r0,-28v33,3,60,-16,60,-44v0,-23,-20,-43,-44,-41","w":199},"\u00ae":{"d":"135,-271v80,0,138,59,138,137v0,81,-58,139,-138,139v-79,0,-139,-58,-139,-138v0,-80,58,-138,139,-138xm135,-14v68,0,118,-50,118,-119v0,-68,-49,-120,-118,-120v-69,0,-119,52,-119,120v0,68,50,119,119,119xm178,-55v-8,-30,7,-73,-36,-66r-40,0r0,66r-25,0r0,-159v56,1,125,-11,123,45v-1,18,-6,25,-20,35v29,8,9,56,26,79r-28,0xm175,-168v0,-32,-43,-21,-73,-23r0,47v31,-1,73,8,73,-24","w":268},"\u00a9":{"d":"135,-271v80,0,138,58,138,138v0,80,-58,138,-138,138v-80,0,-139,-58,-139,-138v0,-80,58,-138,139,-138xm135,-14v68,0,118,-49,118,-119v0,-70,-50,-119,-119,-119v-68,0,-118,51,-118,119v0,69,50,119,119,119xm62,-132v0,-68,69,-108,120,-70v13,9,19,24,20,40r-24,0v-4,-20,-18,-32,-41,-32v-33,1,-49,25,-49,62v0,68,88,82,90,17r24,0v-4,36,-29,63,-67,63v-46,0,-73,-32,-73,-80","w":268},"\u2122":{"d":"346,-266r0,152r-27,0r0,-125r-56,125r-18,0r-54,-125r0,125r-26,0r0,-152r42,0r47,105r50,-105r42,0xm135,-266r0,24r-53,0r0,128r-27,0r0,-128r-53,0r0,-24r133,0","w":360},"\u00b4":{"d":"79,-281r38,0r-52,54r-24,0","w":135},"\u00a8":{"d":"10,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm82,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":132},"\u2260":{"d":"130,-180r58,0r0,24r-67,0r-20,53r87,0r0,24r-97,0r-33,86r-24,0r33,-86r-57,0r0,-24r66,0r21,-53r-87,0r0,-24r96,0r32,-85r25,0","w":197},"\u00c6":{"d":"0,0r167,-259r160,0r0,27r-122,0r0,79r122,0r0,26r-122,0r0,102r122,0r0,25r-148,0r0,-85r-94,0r-55,85r-30,0xm102,-109r77,0r0,-120","w":357},"\u00d8":{"d":"61,-31v-85,-79,-26,-234,95,-234v30,0,57,9,82,26r26,-31r18,16r-26,31v22,22,34,53,36,94v4,104,-123,175,-212,113r-29,34r-19,-15xm221,-219v-72,-52,-174,0,-174,91v0,30,10,56,31,77xm97,-36v74,45,172,-7,169,-93v0,-29,-10,-54,-28,-74","w":312},"\u221e":{"d":"27,-126v0,-54,67,-62,94,-17v23,-25,27,-41,58,-41v30,0,51,23,51,57v0,36,-20,59,-51,59v-31,0,-36,-17,-58,-41v-27,45,-94,37,-94,-17xm210,-125v0,-30,-27,-50,-50,-32v-6,4,-15,14,-27,31v16,21,20,38,46,38v19,0,31,-16,31,-37xm46,-126v5,38,44,32,63,0v-14,-28,-60,-41,-63,0"},"\u00b1":{"d":"87,-160r0,-77r24,0r0,77r77,0r0,24r-77,0r0,76r-24,0r0,-76r-77,0r0,-24r77,0xm188,-28r0,24r-178,0r0,-24r178,0","w":197},"\u2264":{"d":"190,-85r0,26r-182,-82r0,-23r182,-83r0,26r-148,68xm190,-41r0,24r-182,0r0,-24r182,0","w":197},"\u2265":{"d":"8,-85r148,-68r-148,-68r0,-26r182,83r0,23r-182,82r0,-26xm190,-41r0,24r-182,0r0,-24r182,0","w":197},"\u00a5":{"d":"159,-259r29,0r-73,130r63,0r0,20r-66,0r0,27r66,0r0,21r-66,0r0,61r-25,0r0,-61r-65,0r0,-21r65,0r0,-27r-65,0r0,-20r62,0r-73,-130r29,0r59,106","w":199},"\u00b5":{"d":"157,-21v-19,33,-86,32,-106,1r0,90r-25,0r0,-261r25,0v3,71,-20,170,53,169v72,-1,50,-99,53,-169r25,0r0,191r-25,0r0,-21","w":207},"\u2202":{"d":"151,-162v-1,-44,-2,-78,-36,-78v-17,0,-30,14,-40,40r-24,-11v13,-28,31,-51,63,-51v45,0,56,47,57,99v0,87,-32,162,-107,167v-34,2,-55,-26,-54,-61v3,-72,58,-105,141,-105xm41,-53v0,35,37,41,63,20v27,-22,41,-58,46,-107v-70,1,-109,28,-109,87","w":177},"\u2211":{"d":"24,-270r218,0r0,29r-174,0r107,140r-114,148r183,0r0,28r-223,0r0,-33r109,-142r-106,-139r0,-31"},"\u220f":{"d":"28,-270r240,0r0,345r-34,0r0,-314r-172,0r0,314r-34,0r0,-345","w":296},"\uf006":{"d":"0,-187r198,0r0,28r-29,0r0,159r-33,0r0,-159r-75,0r0,159r-33,0r0,-159r-28,0r0,-28","w":197},"\u222b":{"d":"0,17v1,-25,28,-14,37,-6v5,0,6,-5,6,-10r-8,-168v5,-51,-12,-153,41,-160v12,-1,22,8,22,18v1,11,-6,19,-16,19v-7,0,-27,-22,-27,1v4,99,12,120,5,242v-3,52,-3,81,-39,86v-12,2,-21,-10,-21,-22","w":98},"\u00aa":{"d":"10,-202v-6,-51,60,-85,87,-43r0,-17r20,0r0,120r-20,0r0,-17v-27,41,-94,8,-87,-43xm98,-202v0,-23,-14,-44,-34,-44v-44,0,-44,88,0,88v20,0,34,-21,34,-44","w":132},"\u00ba":{"d":"10,-202v0,-34,25,-63,56,-63v32,0,57,30,57,63v0,33,-24,62,-57,62v-33,0,-56,-28,-56,-62xm102,-202v0,-24,-15,-43,-36,-44v-45,0,-47,88,0,88v21,-1,36,-20,36,-44","w":132},"\u2126":{"d":"64,-137v0,52,23,89,60,105r0,32r-102,0r0,-30r65,2v-37,-24,-61,-55,-61,-113v0,-74,43,-121,116,-123v69,-2,115,54,114,123v-1,56,-25,89,-61,113r64,-1r0,29r-101,0r0,-31v79,-24,88,-206,-17,-205v-51,1,-77,43,-77,99","w":276},"\u00e6":{"d":"21,-96v0,-96,129,-134,175,-60r0,-35r23,0r0,34v28,-47,109,-51,148,-10v18,20,28,44,28,74r-172,0v3,43,30,75,75,75v37,0,56,-17,70,-45r21,11v-20,62,-136,78,-170,18r0,34r-23,0r0,-35v-19,25,-40,39,-76,40v-53,1,-99,-47,-99,-101xm368,-114v-5,-60,-95,-77,-129,-31v-7,8,-12,19,-15,31r144,0xm197,-95v-1,-46,-30,-77,-76,-77v-43,0,-74,32,-75,76v-1,42,35,78,76,78v42,0,75,-35,75,-77","w":416},"\u00f8":{"d":"49,-22v-65,-57,-19,-174,68,-174v24,0,44,7,62,21r21,-24r16,13r-22,26v55,62,5,165,-76,165v-19,0,-37,-4,-53,-14r-20,24r-16,-13xm163,-156v-57,-46,-145,16,-114,91v4,10,9,18,16,25xm81,-28v70,41,144,-47,96,-113","w":235},"\u00bf":{"d":"85,-173v0,-12,9,-22,21,-22v12,0,22,10,22,22v0,11,-10,21,-22,21v-12,0,-21,-9,-21,-21xm106,50v31,0,52,-19,52,-52r25,0v1,47,-31,77,-77,77v-41,0,-72,-24,-74,-61v-3,-63,99,-51,109,-97v0,-16,-17,-28,-36,-27v-26,0,-36,13,-38,38r-26,0v2,-38,25,-62,64,-62v35,0,62,20,62,51v3,64,-106,45,-109,97v-1,22,23,36,48,36","w":212},"\u00a1":{"d":"31,-173v0,-12,10,-22,22,-22v12,0,22,10,22,22v0,11,-10,21,-22,21v-12,0,-22,-10,-22,-21xm41,75r0,-201r25,0r0,201r-25,0","w":106},"\u00ac":{"d":"198,-180r0,101r-24,0r0,-77r-154,0r0,-24r178,0","w":218},"\u221a":{"d":"184,-329r13,0r-55,343r-87,-180r-35,16r-6,-11r53,-27r71,145","w":197},"\u0192":{"d":"109,-155r41,0r-3,21r-41,0v-15,67,-8,165,-51,201v-15,13,-32,11,-49,-1r3,-22v37,23,50,-15,56,-56r17,-122r-25,0r3,-21r25,0v10,-43,4,-114,49,-115v10,0,21,3,32,11r-4,24v-25,-25,-39,-9,-45,28","w":199},"\u2248":{"d":"143,-160v21,0,22,-7,45,-20r0,29v-20,10,-25,15,-44,17v-22,2,-66,-29,-88,-29v-20,0,-27,7,-47,19r0,-28v20,-10,25,-16,45,-17v22,-2,66,29,89,29xm143,-95v21,0,22,-7,45,-19r0,28v-20,10,-25,15,-44,17v-21,2,-66,-28,-88,-28v-21,0,-27,6,-47,18r0,-28v20,-10,25,-16,45,-17v23,-2,65,29,89,29","w":197},"\u2206":{"d":"216,0r-211,0r110,-244xm174,-14r-70,-170r-77,170r147,0","w":220},"\u00ab":{"d":"69,-191r-39,96r39,95r-26,0r-39,-95r39,-96r26,0xm149,-191r-39,96r39,95r-26,0r-39,-95r39,-96r26,0","w":152},"\u00bb":{"d":"84,0r39,-96r-39,-95r26,0r39,95r-39,96r-26,0xm4,0r39,-96r-39,-95r26,0r39,95r-39,96r-26,0","w":152},"\u2026":{"d":"158,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22xm38,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22xm278,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22","w":360},"\u00a0":{"w":100},"\u00c0":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm122,-333r39,54r-25,0r-51,-54r37,0","w":266},"\u00c3":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm69,-302v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":266},"\u00d5":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm92,-302v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":312},"\u0152":{"d":"158,-265v47,0,88,27,110,57r0,-51r147,0r0,26r-121,0r0,80r121,0r0,26r-121,0r0,102r121,0r0,25r-147,0r0,-50v-29,34,-54,55,-111,57v-74,2,-138,-61,-137,-135v1,-80,59,-137,138,-137xm267,-130v-1,-65,-48,-107,-110,-110v-56,-2,-109,53,-109,110v0,60,50,111,111,111v59,0,109,-52,108,-111","w":429},"\u0153":{"d":"291,-196v55,-1,103,45,98,103r-171,0v-5,86,121,97,144,30r21,10v-20,35,-43,58,-92,58v-44,0,-66,-18,-86,-48v-20,28,-44,47,-86,48v-55,1,-99,-48,-99,-102v0,-54,45,-99,99,-99v41,0,67,19,86,50v19,-31,44,-49,86,-50xm193,-94v1,-42,-34,-79,-75,-78v-44,1,-74,33,-74,77v0,44,32,77,76,77v43,0,72,-32,73,-76xm362,-114v-7,-52,-77,-77,-119,-41v-11,9,-18,23,-23,41r142,0","w":409},"\u2013":{"d":"-2,-112r184,0r0,23r-184,0r0,-23","w":180},"\u2014":{"d":"-2,-112r364,0r0,23r-364,0r0,-23","w":360},"\u201c":{"d":"51,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96xm129,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96","w":180},"\u201d":{"d":"127,-169r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96xm49,-169r-14,-7v7,-17,11,-21,12,-41r-15,0r0,-48r32,0v0,41,1,70,-15,96","w":174},"\u2018":{"d":"65,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96","w":126},"\u2019":{"d":"61,-169r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96","w":126},"\u00f7":{"d":"81,-212r35,0r0,35r-35,0r0,-35xm10,-141r178,0r0,24r-178,0r0,-24xm81,-82r35,0r0,36r-35,0r0,-36","w":197},"\u25ca":{"d":"97,-250r73,125r-73,125r-20,0r-69,-125r69,-125r20,0xm87,-233r-60,108r60,108r63,-108","w":177},"\u00ff":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm42,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm114,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":193},"\u0178":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm50,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm122,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":213},"\u2044":{"d":"-61,7r162,-272r20,0r-163,272r-19,0","w":59},"\u2215":{"d":"-61,7r162,-272r20,0r-163,272r-19,0","w":59},"\u20ac":{"d":"195,4v-83,12,-144,-32,-161,-95r-26,0r6,-24r16,0v-1,-14,-1,-17,0,-30r-22,0r7,-25r20,0v18,-61,81,-107,162,-92r-7,24v-61,-10,-109,23,-127,68r113,0r-7,25r-112,0v-1,10,-2,19,0,30r104,0r-6,24r-93,0v16,48,69,83,133,70r0,25","w":199},"\u2039":{"d":"78,-191r-39,96r39,95r-26,0r-39,-95r39,-96r26,0","w":90},"\u203a":{"d":"12,0r40,-96r-40,-95r26,0r39,95r-39,96r-26,0","w":90},"\uf001":{"d":"40,-191v-12,-68,49,-99,95,-66v11,8,15,21,16,35r-25,0v-3,-16,-13,-24,-29,-24v-30,0,-33,21,-32,55r39,0r0,21r-39,0r0,170r-25,0r0,-170r-25,0r0,-21r25,0xm126,-191r25,0r0,191r-25,0r0,-191","w":175},"\ufb01":{"d":"40,-191v-12,-68,49,-99,95,-66v11,8,15,21,16,35r-25,0v-3,-16,-13,-24,-29,-24v-30,0,-33,21,-32,55r39,0r0,21r-39,0r0,170r-25,0r0,-170r-25,0r0,-21r25,0xm126,-191r25,0r0,191r-25,0r0,-191","w":175},"\uf002":{"d":"127,-196v12,-51,-42,-67,-58,-31v-1,5,-2,17,-2,36r39,0r0,22r-39,0r0,169r-26,0r0,-169r-25,0r0,-22r25,0v-2,-51,12,-79,56,-79v41,0,55,23,55,75r0,195r-25,0r0,-196","w":174},"\ufb02":{"d":"127,-196v12,-51,-42,-67,-58,-31v-1,5,-2,17,-2,36r39,0r0,22r-39,0r0,169r-26,0r0,-169r-25,0r0,-22r25,0v-2,-51,12,-79,56,-79v41,0,55,23,55,75r0,195r-25,0r0,-196","w":174},"\u2021":{"d":"86,-265r26,0r-4,62r63,-4r0,26r-63,-5v4,54,4,107,0,161r63,-4r0,26r-63,-5r4,63r-26,0r5,-63r-63,5r0,-26r63,4v-5,-54,-5,-107,0,-161r-63,5r0,-26r63,4","w":199},"\u2219":{"d":"28,-129v0,-12,10,-22,22,-22v12,0,22,10,22,22v0,27,-44,28,-44,0","w":99},"\u201a":{"d":"62,48r-14,-7v7,-17,11,-21,12,-41r-15,0r0,-48r32,0v0,41,1,70,-15,96","w":127},"\u201e":{"d":"130,48r-14,-8v7,-16,11,-20,12,-40r-15,0r0,-48r32,0v0,41,1,70,-15,96xm52,48r-14,-8v7,-16,11,-20,12,-40r-15,0r0,-48r32,0v0,41,1,70,-15,96","w":180},"\u2030":{"d":"69,-265v49,9,106,12,154,-5r20,0r-188,288r-23,0r171,-262v-22,6,-52,7,-84,7v28,38,-3,94,-50,94v-33,0,-62,-28,-60,-61v1,-35,25,-60,60,-61xm108,-204v0,-21,-19,-39,-39,-39v-20,0,-38,18,-38,39v0,20,18,38,38,38v21,0,39,-17,39,-38xm150,-53v0,-33,28,-61,61,-61v33,0,60,28,60,61v0,33,-28,61,-60,61v-33,0,-61,-28,-61,-61xm249,-53v0,-21,-17,-39,-38,-39v-21,0,-39,18,-39,39v0,21,18,38,39,38v20,0,38,-18,38,-38xm290,-53v0,-33,28,-61,61,-61v33,0,61,28,61,61v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61xm389,-53v0,-21,-17,-39,-38,-39v-21,0,-39,19,-39,39v0,20,18,38,39,38v20,0,38,-18,38,-38","w":422},"\u00c2":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm122,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":266},"\u00ca":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm96,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":193},"\u00c1":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm145,-333r38,0r-52,54r-24,0","w":266},"\u00cb":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm51,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm123,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":193},"\u00c8":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm96,-333r39,54r-25,0r-51,-54r37,0","w":193},"\u00cd":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm52,-333r38,0r-52,54r-24,0","w":81},"\u00ce":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm29,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":81},"\u00cf":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-16,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm56,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":81},"\u00cc":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm30,-333r39,54r-25,0r-51,-54r37,0","w":81},"\u00d3":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm168,-333r38,0r-52,54r-24,0","w":312},"\u00d4":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm145,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":312},"\uf000":{"w":284},"\u00d2":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm145,-333r39,54r-25,0r-51,-54r37,0","w":312},"\u00da":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm129,-333r38,0r-52,54r-24,0","w":235},"\u00db":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm107,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":235},"\u00d9":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm107,-333r39,54r-25,0r-51,-54r37,0","w":235},"\u0131":{"d":"24,-191r25,0r0,191r-25,0r0,-191","w":72},"\u02c6":{"d":"79,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":180},"\u02dc":{"d":"15,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":158},"\u02c9":{"d":"27,-260r121,0r0,21r-121,0r0,-21","w":174},"\u02d8":{"d":"43,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":163},"\u02d9":{"d":"20,-246v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":79},"\u02da":{"d":"22,-260v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm79,-260v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19","w":119},"\u00b8":{"d":"73,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":116},"\u02dd":{"d":"83,-281r38,0r-52,54r-24,0xm139,-281r38,0r-52,54r-24,0","w":198},"\u02db":{"d":"88,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":108},"\u02c7":{"d":"102,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":180},"\u0141":{"d":"77,-151r47,-38r0,30r-47,39r0,95r99,0r0,25r-125,0r0,-98r-35,29r0,-30r35,-30r0,-130r26,0r0,108","w":186},"\u0142":{"d":"66,-171r35,-22r0,24r-35,23r0,146r-24,0r0,-130r-33,21r0,-25r33,-21r0,-110r24,0r0,94","w":107},"\u0160":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70xm101,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":179},"\u0161":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96xm81,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":139},"\u017d":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0xm98,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":172},"\u017e":{"d":"12,-191r140,0r-108,169r105,0r0,22r-147,0r108,-170r-98,0r0,-21xm88,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":152},"\u00a6":{"d":"108,-121r0,-144r25,0r0,135xm108,70r0,-168r25,-10r0,178r-25,0","w":241},"\u00d0":{"d":"266,-126v0,81,-46,126,-136,126r-93,0r0,-117r-31,0r0,-24r31,0r0,-118r65,0v110,-3,164,38,164,133xm240,-126v0,-93,-69,-114,-178,-107r0,92r68,0r0,24r-68,0r0,93v106,5,178,-8,178,-102","w":284},"\u00f0":{"d":"18,-96v0,-69,73,-125,141,-89v-11,-15,-24,-28,-38,-41r-38,16r-9,-19r31,-13v-11,-9,-21,-17,-29,-23r34,0v6,4,12,9,18,14r29,-12r9,18r-20,9v40,38,72,77,72,136v0,62,-41,103,-101,105v-54,2,-99,-47,-99,-101xm192,-96v0,-46,-28,-77,-72,-77v-41,0,-77,32,-77,76v0,42,34,79,75,78v43,-2,75,-31,74,-77","w":235},"\u00dd":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm118,-333r38,0r-52,54r-24,0","w":213},"\u00fd":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm108,-281r38,0r-52,54r-24,0","w":193},"\u00de":{"d":"193,-129v0,66,-55,72,-136,69r0,60r-26,0r0,-259r26,0r0,61v78,-3,136,2,136,69xm166,-129v0,-50,-56,-45,-109,-44r0,88v53,1,109,6,109,-44","w":213},"\u00fe":{"d":"129,5v-35,-2,-59,-16,-77,-38r0,103r-24,0r0,-335r24,0r0,109v17,-23,40,-39,76,-40v54,-1,99,47,99,100v0,53,-45,102,-98,101xm202,-95v0,-45,-31,-76,-76,-77v-41,-1,-76,35,-76,77v0,46,33,77,77,77v43,0,75,-34,75,-77","w":245},"\u2212":{"d":"20,-141r178,0r0,24r-178,0r0,-24","w":218},"\u00d7":{"d":"125,-129r59,58r-17,16r-58,-58r-58,58r-16,-16r58,-58r-58,-59r16,-16r58,59r58,-59r17,16","w":218},"\u00b9":{"d":"39,-262r33,0r0,133r-19,0r0,-116r-26,0","w":119},"\u00b2":{"d":"92,-224v-5,-35,-66,-30,-65,7r-18,0v0,-28,24,-48,53,-48v34,0,61,31,43,61v-10,17,-41,42,-58,58r66,0r0,17r-112,0r63,-57v17,-17,24,-19,28,-38","w":119},"\u00b3":{"d":"60,-248v-15,1,-22,8,-28,21r-19,0v3,-48,90,-50,93,-2v0,10,-5,18,-16,25v44,17,21,78,-29,78v-32,0,-48,-15,-53,-42r19,0v3,34,68,32,68,-1v0,-21,-19,-23,-44,-25r0,-17v38,7,46,-37,9,-37","w":123},"\u00bd":{"d":"31,-262r33,0r0,133r-19,0r0,-116r-26,0xm49,7r162,-272r20,0r-163,272r-19,0xm256,-94v-5,-35,-66,-30,-65,7r-18,0v0,-28,24,-48,53,-48v34,0,61,31,43,61v-10,17,-41,42,-58,58r66,0r0,17r-112,0r63,-57v17,-17,24,-19,28,-38","w":299},"\u00bc":{"d":"33,-262r33,0r0,133r-19,0r0,-116r-26,0xm68,7r162,-272r20,0r-163,272r-19,0xm273,-139r0,93r18,0r0,17r-18,0r0,30r-20,0r0,-30r-76,0xm253,-46r0,-43r-37,43r37,0","w":299},"\u00be":{"d":"64,-248v-15,1,-22,8,-28,21r-19,0v3,-48,90,-50,93,-2v0,10,-5,18,-16,25v44,17,21,78,-29,78v-32,0,-48,-15,-53,-42r19,0v3,34,68,32,68,-1v0,-21,-19,-23,-44,-25r0,-17v38,7,46,-37,9,-37xm76,7r162,-272r20,0r-163,272r-19,0xm272,-139r0,93r18,0r0,17r-18,0r0,30r-20,0r0,-30r-76,0xm252,-46r0,-43r-37,43r37,0","w":299},"\u20a3":{"d":"57,-73r50,0r0,24r-50,0r0,49r-26,0r0,-49r-31,0r0,-24r31,0r0,-186r130,0r0,26r-104,0r0,81r104,0r0,25r-104,0r0,54","w":174},"\u011e":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136xm118,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":313},"\u011f":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74xm83,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":242},"\u0130":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm21,-298v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":81},"\u015e":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70xm94,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":179},"\u015f":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96xm78,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":139},"\u0106":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm173,-333r38,0r-52,54r-24,0","w":292},"\u0107":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm134,-281r38,0r-52,54r-24,0","w":232},"\u010c":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm171,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":292},"\u010d":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm137,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":232},"\u0111":{"d":"118,-196v36,1,59,17,76,40r0,-58r-54,0r0,-20r54,0r0,-31r24,0r0,31r28,0r0,20r-28,0r0,214r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm196,-95v0,-42,-35,-78,-76,-77v-45,1,-76,32,-76,77v0,44,32,77,76,77v44,0,76,-31,76,-77","w":246},"\u00af":{"d":"-2,-304r184,0r0,19r-184,0r0,-19","w":180},"\u00b7":{"d":"85,-133v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":119},"\uf003":{"d":"99,-269r0,93r18,0r0,17r-18,0r0,30r-20,0r0,-30r-76,0xm79,-176r0,-43r-37,43r37,0","w":123},"\u0102":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm96,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":266},"\u0103":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm78,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":245},"\u0104":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm265,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":266},"\u0105":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm230,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":245},"\u010e":{"d":"249,-126v0,81,-45,128,-135,126r-83,0r0,-259r54,0v111,-3,164,38,164,133xm223,-126v0,-89,-61,-113,-167,-107r0,209v104,5,167,-13,167,-102xm129,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":267},"\u010f":{"d":"19,-96v-3,-88,125,-140,175,-60r0,-109r24,0r0,265r-24,0r0,-33v-21,25,-47,38,-77,38v-55,1,-96,-48,-98,-101xm196,-95v0,-44,-35,-77,-76,-77v-43,0,-75,36,-76,77v-1,41,36,77,76,77v41,0,76,-33,76,-77xm246,-183r-12,-7v6,-12,10,-23,11,-34r-13,0r0,-41r27,0v1,35,0,58,-13,82","w":246},"\u0110":{"d":"266,-126v0,81,-46,126,-136,126r-93,0r0,-117r-31,0r0,-24r31,0r0,-118r65,0v110,-3,164,38,164,133xm240,-126v0,-93,-69,-114,-178,-107r0,92r68,0r0,24r-68,0r0,93v106,5,178,-8,178,-102","w":284},"\u0118":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm177,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":193},"\u0119":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm155,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":233},"\u011a":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm119,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":193},"\u011b":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm129,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":233},"\u0132":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm110,-41v47,40,88,27,88,-44r0,-174r25,0r0,175v14,93,-72,114,-126,63","w":254},"\u0133":{"d":"16,-250v-1,-11,10,-20,20,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-11,0,-20,-10,-20,-21xm88,-250v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21xm24,-191r25,0r0,191r-25,0r0,-191xm61,47v20,11,36,3,36,-25r0,-213r24,0r0,220v2,45,-27,54,-60,40r0,-22","w":145},"\u0139":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259xm96,-333r38,0r-52,54r-24,0","w":166},"\u013a":{"d":"24,-265r24,0r0,265r-24,0r0,-265xm52,-333r38,0r-52,54r-24,0","w":72},"\u013d":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259xm98,-162r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96","w":166},"\u013e":{"d":"24,-265r24,0r0,265r-24,0r0,-265xm76,-183r-12,-7v6,-12,10,-23,11,-34r-14,0r0,-41r27,0v0,34,1,59,-12,82","w":74},"\u013f":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259xm87,-133v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":166},"\u0140":{"d":"24,-265r24,0r0,265r-24,0r0,-265xm62,-133v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":94},"\u0143":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0xm151,-333r38,0r-52,54r-24,0","w":266},"\u0144":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm117,-281r38,0r-52,54r-24,0","w":219},"\u0147":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0xm146,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":266},"\u0148":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm133,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":219},"\u0149":{"d":"120,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm5,-169r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96","w":220},"\u0150":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm149,-333r38,0r-52,54r-24,0xm205,-333r38,0r-52,54r-24,0","w":312},"\u0151":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm113,-281r38,0r-52,54r-24,0xm169,-281r38,0r-52,54r-24,0","w":235},"\u0154":{"d":"195,-190v0,50,-35,70,-90,70r93,120r-32,0r-93,-120r-14,0r0,120r-26,0r0,-259v84,-2,162,-5,162,69xm168,-190v0,-49,-56,-44,-109,-43r0,88v53,1,109,5,109,-45xm127,-333r38,0r-52,54r-24,0","w":218},"\u0155":{"d":"43,0r-25,0r0,-191r25,0r0,28v15,-23,40,-43,72,-27r-13,21v-75,-15,-56,95,-59,169xm74,-281r38,0r-52,54r-24,0","w":108},"\u0158":{"d":"195,-190v0,50,-35,70,-90,70r93,120r-32,0r-93,-120r-14,0r0,120r-26,0r0,-259v84,-2,162,-5,162,69xm168,-190v0,-49,-56,-44,-109,-43r0,88v53,1,109,5,109,-45xm115,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":218},"\u0159":{"d":"43,0r-25,0r0,-191r25,0r0,28v15,-23,40,-43,72,-27r-13,21v-75,-15,-56,95,-59,169xm70,-226r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":108},"\u015a":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70xm97,-333r38,0r-52,54r-24,0","w":179},"\u015b":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96xm70,-281r38,0r-52,54r-24,0","w":139},"\u0162":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0xm83,75r-12,-5v4,-8,7,-16,7,-22r-15,0r0,-27r28,0v1,22,-2,43,-8,54","w":153},"\u0163":{"d":"49,-262r25,0r0,71r39,0r0,21r-39,0r0,170r-25,0r0,-170r-34,0r0,-21r34,0r0,-71xm67,75r-11,-5v4,-8,6,-16,6,-22r-15,0r0,-27r28,0v1,22,-2,43,-8,54","w":121},"\u0164":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0xm91,-278r-24,0r-51,-45r31,0r31,27r32,-27r33,0","w":153},"\u0165":{"d":"104,-204r-10,-5v6,-10,10,-19,10,-27r-12,0r0,-29r24,0v0,28,1,45,-12,61xm49,-262r25,0r0,71r39,0r0,21r-39,0r0,170r-25,0r0,-170r-34,0r0,-21r34,0r0,-71","w":121},"\u016e":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm74,-312v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm131,-312v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19","w":235},"\u016f":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm65,-260v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm122,-260v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19","w":218},"\u0170":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm113,-333r38,0r-52,54r-24,0xm169,-333r38,0r-52,54r-24,0","w":235},"\u0171":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm105,-281r38,0r-52,54r-24,0xm161,-281r38,0r-52,54r-24,0","w":218},"\u0179":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0xm92,-333r38,0r-52,54r-24,0","w":172},"\u017a":{"d":"12,-191r140,0r-108,169r105,0r0,22r-147,0r108,-170r-98,0r0,-21xm93,-281r38,0r-52,54r-24,0","w":152},"\u017b":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0xm60,-298v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":172},"\u017c":{"d":"12,-191r140,0r-108,169r105,0r0,22r-147,0r108,-170r-98,0r0,-21xm51,-246v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":152},"\uf100":{"d":"31,-258r156,0r0,31r-122,0r0,227r-34,0r0,-258","w":195},"\uf101":{"d":"20,-129v-1,-78,39,-136,116,-135v74,0,114,56,113,136v0,78,-36,135,-113,135v-81,-1,-115,-54,-116,-136xm213,-131v0,-58,-24,-105,-77,-105v-57,1,-81,42,-80,106v1,64,19,109,78,109v58,0,79,-44,79,-110xm86,-146r97,0r0,30r-97,0r0,-30","w":268},"\uf102":{"d":"20,-127v0,-69,40,-101,114,-103r0,-34r34,0r0,34v75,3,113,37,113,103v0,66,-38,100,-113,103r0,55r-34,0r0,-55v-76,-3,-114,-37,-114,-103xm134,-203v-51,0,-77,26,-77,76v0,48,26,73,77,76r0,-152xm168,-203r0,152v51,-1,76,-26,76,-76v0,-50,-25,-75,-76,-76","w":301},"\uf103":{"d":"18,-89v0,-58,30,-101,85,-101v29,0,49,12,63,35r8,-32r34,0v-17,62,-16,129,3,187r-36,0v-4,-13,-6,-25,-8,-34v-40,75,-149,32,-149,-55xm163,-93v0,-41,-14,-73,-54,-73v-38,0,-54,31,-54,74v0,40,17,73,54,73v39,0,54,-29,54,-74","w":226},"\uf104":{"d":"18,-85v1,-55,39,-87,97,-81v-28,-23,-46,-30,-46,-64v0,-44,65,-51,106,-38r0,23v-36,-9,-85,0,-64,34v38,40,94,64,94,127v0,52,-38,89,-94,89v-54,0,-94,-38,-93,-90xm168,-83v-1,-36,-18,-65,-55,-65v-38,0,-58,25,-58,64v0,38,19,66,57,65v34,0,57,-26,56,-64","w":223},"\uf105":{"d":"55,-82v-1,51,57,69,111,58r0,26v-80,14,-148,-18,-148,-94v0,-74,64,-111,145,-95r0,25v-56,-5,-104,4,-107,55r106,0r0,25r-107,0","w":184},"\uf106":{"d":"18,-93v0,-66,44,-96,116,-95r105,1r0,27r-60,0v52,52,20,165,-67,165v-58,0,-94,-38,-94,-98xm168,-94v0,-40,-16,-75,-56,-74v-39,0,-58,26,-58,78v0,39,18,71,57,71v41,-1,57,-31,57,-75","w":245},"\uf107":{"d":"7,-187r158,0r0,28r-62,0r0,159r-34,0r0,-159r-62,0r0,-28","w":172},"\uf108":{"d":"18,-94v0,-66,42,-93,105,-95r0,-45r33,0r0,45v61,0,103,32,103,93v0,69,-40,95,-104,99r0,65r-33,0r0,-66v-61,0,-104,-31,-104,-96xm122,-165v-46,0,-66,26,-67,71v0,48,22,73,67,73r0,-144xm156,-165r0,144v45,0,67,-25,67,-73v0,-47,-22,-70,-67,-71","w":277},"\u2017":{"d":"-2,26r184,0r0,18r-184,0r0,-18xm-2,57r184,0r0,18r-184,0r0,-18","w":180},"\u2032":{"d":"41,-184r-18,0r7,-81r26,0","w":71},"\u2033":{"d":"95,-184r-18,0r7,-81r26,0xm27,-184r-19,0r8,-81r26,0","w":111},"\u203c":{"d":"66,-265r0,200r-26,0r0,-200r26,0xm150,-265r0,200r-25,0r0,-200r25,0xm31,-17v0,-12,10,-22,22,-22v12,0,22,10,22,22v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22xm116,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22","w":191},"\u207f":{"d":"68,-205v-43,0,-33,57,-34,104r-21,0r0,-120r21,0r0,17v30,-39,81,-16,81,41r0,62r-20,0v-4,-39,15,-104,-27,-104","w":128},"\u20a7":{"d":"31,-259v81,-1,161,-7,162,68r13,0r0,-71r25,0r0,71v62,5,108,-22,143,21r-16,16v-13,-13,-25,-19,-38,-19v-14,0,-30,11,-29,26v6,46,83,40,83,96v0,59,-85,73,-114,29r15,-18v21,32,72,28,76,-10v-6,-47,-87,-39,-83,-96v0,-9,2,-16,6,-24r-43,0r0,170r-25,0r0,-170r-16,0v-14,51,-63,50,-133,50r0,120r-26,0r0,-259xm166,-190v0,-49,-56,-44,-109,-43r0,87v68,2,109,6,109,-44","w":390},"\u2105":{"d":"8,-201v-5,-62,87,-89,113,-34r-16,9v-20,-37,-77,-18,-77,24v0,42,57,62,77,23r16,10v-12,19,-30,29,-53,29v-36,0,-58,-30,-60,-61xm66,7r162,-272r20,0r-163,272r-19,0xm192,-60v0,-32,25,-63,57,-63v31,0,56,31,56,63v0,33,-24,63,-56,63v-33,0,-57,-30,-57,-63xm249,-16v46,0,46,-87,0,-87v-21,-1,-36,22,-36,44v0,23,16,43,36,43","w":313},"\u2113":{"d":"113,-11v-27,25,-80,20,-75,-27r0,-40r-14,18r-17,-14r31,-41v4,-58,-17,-147,41,-147v24,0,41,18,39,41v-3,43,-23,64,-50,104r0,73v0,39,20,22,45,4r0,29xm80,-241v-22,3,-9,54,-12,83v16,-28,23,-34,26,-62v1,-11,-5,-22,-14,-21","w":129},"\u2190":{"d":"86,-154r14,0v-9,20,-21,38,-34,54r280,0r0,18r-280,0v12,12,23,30,34,54r-13,0v-26,-30,-51,-50,-73,-60r0,-7v21,-8,44,-28,72,-59","w":360},"\u2191":{"d":"27,-185v31,-28,50,-51,58,-72r9,0v10,22,29,47,59,73r0,13v-24,-11,-42,-22,-54,-34r0,280r-18,0r0,-280v-16,13,-34,25,-54,34r0,-14","w":180},"\u2192":{"d":"273,-154v28,31,52,51,73,59r0,7v-22,10,-47,30,-73,60r-13,0v11,-24,22,-42,34,-54r-280,0r0,-18r280,0v-13,-16,-25,-34,-34,-54r13,0","w":360},"\u2193":{"d":"27,3r0,-14v20,9,38,22,54,35r0,-281r18,0r0,281v12,-12,30,-24,54,-35r0,14v-30,26,-49,50,-59,72r-9,0v-8,-21,-27,-44,-58,-72","w":180},"\u2194":{"d":"346,-95r0,8v-21,9,-45,29,-71,59r-14,0v8,-20,19,-38,34,-54r-230,0v15,16,26,34,34,54r-14,0v-26,-30,-50,-50,-71,-59r0,-8v21,-9,45,-29,71,-59r14,0v-8,20,-19,38,-34,54r230,0v-15,-16,-26,-34,-34,-54r14,0v26,30,50,50,71,59","w":360},"\u2195":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71","w":180},"\u21a8":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71xm27,92r126,0r0,17r-126,0r0,-17","w":180},"\u221f":{"d":"64,-225r17,0r0,207r208,0r0,18r-225,0r0,-225","w":352},"\u2229":{"d":"106,-239v-93,0,-57,143,-64,239r-19,0v4,-111,-26,-262,83,-262v108,0,80,145,83,262r-19,0v-7,-96,29,-239,-64,-239","w":211},"\u2261":{"d":"198,-212r0,24r-178,0r0,-24r178,0xm20,-141r178,0r0,24r-178,0r0,-24xm198,-71r0,24r-178,0r0,-24r178,0","w":218},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"104,-160r0,82r-81,0r0,-82r81,0","w":127},"\u25ab":{"d":"104,-160r0,82r-81,0r0,-82r81,0xm91,-146r-55,0r0,54r55,0r0,-54","w":127},"\u25cf":{"d":"31,-102v0,-42,36,-77,78,-77v41,0,77,36,77,77v0,41,-36,78,-77,78v-41,0,-78,-37,-78,-78","w":217},"\u25e6":{"d":"20,-119v0,-23,21,-45,44,-44v23,0,44,19,44,44v0,23,-21,44,-44,44v-23,0,-44,-21,-44,-44xm95,-119v0,-16,-15,-31,-31,-31v-16,0,-31,14,-31,31v0,17,15,31,31,31v16,0,32,-14,31,-31","w":127},"\uf004":{"d":"57,21r22,10r-32,60r-16,-7","w":119},"\u0100":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm73,-312r121,0r0,21r-121,0r0,-21","w":266},"\u0101":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm63,-260r121,0r0,21r-121,0r0,-21","w":245},"\u0108":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm142,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":292},"\u0109":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm105,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":232},"\u010a":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm134,-298v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":292},"\u010b":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm100,-246v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":232},"\u0112":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm45,-312r121,0r0,21r-121,0r0,-21","w":193},"\u0113":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm57,-260r121,0r0,21r-121,0r0,-21","w":233},"\u0114":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm58,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":193},"\u0115":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm78,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":233},"\u0116":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm86,-298v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":193},"\u0117":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm97,-246v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":233},"\u011c":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136xm147,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":313},"\u011d":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74xm106,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":242},"\u0120":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136xm140,-298v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":313},"\u0121":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74xm102,-246v0,-11,9,-21,20,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":242},"\u0122":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136xm172,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":313},"\u0123":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74xm119,-319r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96","w":242},"\u0124":{"d":"31,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259xm112,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":245},"\u0125":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-265r25,0r0,108v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm98,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":219},"\u0126":{"d":"57,-218r132,0r0,-41r26,0r0,41r23,0r0,24r-23,0r0,194r-26,0r0,-125r-132,0r0,125r-26,0r0,-194r-23,0r0,-24r23,0r0,-41r26,0r0,41xm57,-194r0,44r132,0r0,-44r-132,0","w":245},"\u0127":{"d":"119,-173v-78,1,-67,90,-67,173r-25,0r0,-218r-26,0r0,-20r26,0r0,-27r25,0r0,27r66,0r0,20r-66,0r0,61v47,-69,159,-42,142,59r0,98r-24,0v-6,-70,23,-174,-51,-173","w":219},"\u0128":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-23,-302v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":81},"\u0129":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-28,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":72},"\u012a":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-20,-312r121,0r0,21r-121,0r0,-21","w":81},"\u012b":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-24,-260r121,0r0,21r-121,0r0,-21","w":72},"\u012c":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm2,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":81},"\u012d":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-3,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":72},"\u012e":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm68,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":81},"\u012f":{"d":"16,-250v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-11,0,-20,-10,-20,-21xm24,-191r25,0r0,191r-25,0r0,-191xm63,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":72},"\u0134":{"d":"29,-41v36,34,87,33,87,-44r0,-174r26,0r0,175v15,96,-75,110,-127,63xm99,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":173},"\u0135":{"d":"25,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0xm-11,47v19,10,35,4,35,-25r0,-213r25,0r0,220v2,45,-27,54,-60,40r0,-22","w":73},"\u0136":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259xm131,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":212},"\u0137":{"d":"27,-265r25,0r0,151r88,-77r37,0r-105,91r111,100r-35,0r-96,-86r0,86r-25,0r0,-265xm118,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":180},"\u0138":{"d":"27,-191r25,0r0,77r88,-77r37,0r-105,91r111,100r-35,0r-96,-86r0,86r-25,0r0,-191","w":180},"\u013b":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259xm116,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":166},"\u013c":{"d":"24,-265r24,0r0,265r-24,0r0,-265xm63,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":72},"\u0145":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0xm160,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":266},"\u0146":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173xm137,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":219},"\u014a":{"d":"259,-128v0,101,-102,183,-166,101r18,-16v12,16,28,25,47,25v49,0,74,-58,74,-112v0,-59,-39,-112,-94,-111v-35,0,-64,22,-81,44r0,197r-26,0r0,-259r26,0r0,32v23,-25,52,-38,85,-38v71,-1,117,64,117,137","w":279},"\u014b":{"d":"52,-157v46,-69,142,-44,142,59r0,127v1,45,-27,54,-60,40r0,-22v20,11,40,3,36,-25v-8,-74,28,-195,-51,-195v-78,0,-67,90,-67,173r-25,0r0,-191r25,0r0,34","w":219},"\u014c":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm96,-312r121,0r0,21r-121,0r0,-21","w":312},"\u014d":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm58,-260r121,0r0,21r-121,0r0,-21","w":235},"\u014e":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm118,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":312},"\u014f":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm79,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":235},"\u0156":{"d":"195,-190v0,50,-35,70,-90,70r93,120r-32,0r-93,-120r-14,0r0,120r-26,0r0,-259v84,-2,162,-5,162,69xm168,-190v0,-49,-56,-44,-109,-43r0,88v53,1,109,5,109,-45xm133,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":218},"\u0157":{"d":"43,0r-25,0r0,-191r25,0r0,28v15,-23,40,-43,72,-27r-13,21v-75,-15,-56,95,-59,169xm78,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":108},"\u015c":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70xm78,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":179},"\u015d":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96xm59,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":139},"\u0166":{"d":"90,-137r49,0r0,25r-49,0r0,112r-26,0r0,-112r-50,0r0,-25r50,0r0,-96r-58,0r0,-26r142,0r0,26r-58,0r0,96","w":153},"\u0167":{"d":"74,-107r43,0r0,21r-43,0r0,86r-25,0r0,-86r-38,0r0,-21r38,0r0,-63r-34,0r0,-21r34,0r0,-71r25,0r0,71r39,0r0,21r-39,0r0,63","w":121},"\u0168":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm55,-302v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":235},"\u0169":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm45,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13","w":218},"\u016a":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm57,-312r121,0r0,21r-121,0r0,-21","w":235},"\u016b":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm49,-260r121,0r0,21r-121,0r0,-21","w":218},"\u016c":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm79,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":235},"\u016d":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm71,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":218},"\u0172":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm153,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":235},"\u0173":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm139,67v-49,16,-75,-43,-34,-67r19,0v-14,12,-21,23,-21,34v1,16,18,22,38,18","w":218},"\u0174":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0xm161,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":345},"\u0175":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0xm138,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":299},"\u0176":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm95,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":213},"\u0177":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm85,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0","w":193},"\u017f":{"d":"24,-211v-7,-55,23,-66,67,-54r0,24v-22,-12,-43,-7,-43,24r0,217r-24,0r0,-211","w":72},"\u01fa":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm96,-283v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm153,-283v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19xm140,-382r38,0r-52,54r-24,0","w":266},"\u01fb":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm85,-253v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm142,-253v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19xm131,-351r38,0r-52,54r-24,0","w":245},"\u01fc":{"d":"0,0r167,-259r160,0r0,27r-122,0r0,79r122,0r0,26r-122,0r0,102r122,0r0,25r-148,0r0,-85r-94,0r-55,85r-30,0xm102,-109r77,0r0,-120xm228,-333r38,0r-52,54r-24,0","w":357},"\u01fd":{"d":"21,-96v0,-96,129,-134,175,-60r0,-35r23,0r0,34v28,-47,109,-51,148,-10v18,20,28,44,28,74r-172,0v3,43,30,75,75,75v37,0,56,-17,70,-45r21,11v-20,62,-136,78,-170,18r0,34r-23,0r0,-35v-19,25,-40,39,-76,40v-53,1,-99,-47,-99,-101xm368,-114v-5,-60,-95,-77,-129,-31v-7,8,-12,19,-15,31r144,0xm197,-95v-1,-46,-30,-77,-76,-77v-43,0,-74,32,-75,76v-1,42,35,78,76,78v42,0,75,-35,75,-77xm220,-281r38,0r-52,54r-24,0","w":416},"\u01fe":{"d":"61,-31v-85,-79,-26,-234,95,-234v30,0,57,9,82,26r26,-31r18,16r-26,31v22,22,34,53,36,94v4,104,-123,175,-212,113r-29,34r-19,-15xm221,-219v-72,-52,-174,0,-174,91v0,30,10,56,31,77xm97,-36v74,45,172,-7,169,-93v0,-29,-10,-54,-28,-74xm168,-333r38,0r-52,54r-24,0","w":312},"\u01ff":{"d":"49,-22v-65,-57,-19,-174,68,-174v24,0,44,7,62,21r21,-24r16,13r-22,26v55,62,5,165,-76,165v-19,0,-37,-4,-53,-14r-20,24r-16,-13xm163,-156v-57,-46,-145,16,-114,91v4,10,9,18,16,25xm81,-28v70,41,144,-47,96,-113xm128,-281r38,0r-52,54r-24,0","w":235},"\u0384":{"d":"83,-281r-5,60r-20,0r-5,-60r30,0","w":136},"\u0385":{"d":"83,-281r-5,60r-20,0r-5,-60r30,0xm127,-243v0,8,-8,16,-16,16v-8,0,-15,-8,-15,-16v0,-8,7,-15,15,-15v8,0,16,7,16,15xm40,-243v0,8,-7,16,-15,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15v8,0,15,7,15,15","w":136},"\u0386":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm74,-265r-5,60r-20,0r-5,-60r30,0","w":266},"\u0387":{"d":"54,-196v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21v0,-12,9,-22,21,-22","w":99},"\u0388":{"d":"48,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm13,-265r-5,60r-20,0r-5,-60r30,0","w":208},"\u0389":{"d":"47,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259xm13,-265r-5,60r-20,0r-5,-60r30,0","w":261},"\u038a":{"d":"44,-259r26,0r0,259r-26,0r0,-259xm13,-265r-5,60r-20,0r-5,-60r30,0","w":97},"\u038c":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm13,-265r-5,60r-20,0r-5,-60r30,0","w":312},"\u038e":{"d":"30,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm13,-265r-5,60r-20,0r-5,-60r30,0","w":232},"\u038f":{"d":"278,-145v-2,66,-31,86,-84,121r76,0r0,24r-99,0r0,-34v53,-38,77,-49,81,-110v3,-58,-43,-96,-101,-96v-58,0,-104,38,-101,96v3,61,27,72,80,110r0,34r-99,0r0,-24r76,0v-53,-36,-81,-54,-84,-121v-3,-72,56,-120,128,-120v72,0,130,49,127,120xm13,-265r-5,60r-20,0r-5,-60r30,0","w":301},"\u0390":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm51,-281r-5,60r-20,0r-5,-60r30,0xm95,-243v0,8,-8,16,-16,16v-8,0,-15,-8,-15,-16v0,-8,7,-15,15,-15v8,0,16,7,16,15xm8,-243v0,8,-7,16,-15,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15v8,0,15,7,15,15","w":72},"\u0391":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"\u0392":{"d":"187,-74v0,44,-37,75,-84,74r-71,0r0,-259v69,-3,134,0,134,64v0,26,-14,44,-33,54v32,11,54,28,54,67xm139,-195v1,-39,-40,-40,-82,-38r0,83v47,2,80,-5,82,-45xm160,-74v0,-47,-45,-52,-103,-50r0,99v55,2,103,-1,103,-49","w":206},"\u0393":{"d":"161,-233r-104,0r0,233r-26,0r0,-259r130,0r0,26","w":166},"\u0394":{"d":"258,0r-249,0r122,-259r6,0xm218,-25r-84,-179r-85,179r169,0","w":266},"\u0395":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259","w":193},"\u0396":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0","w":172},"\u0397":{"d":"31,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259","w":245},"\u0398":{"d":"292,-129v0,74,-61,136,-135,136v-75,0,-137,-61,-137,-135v0,-74,62,-137,135,-137v76,0,137,60,137,136xm266,-129v0,-63,-53,-111,-110,-111v-58,-1,-109,51,-109,112v0,60,48,109,109,109v61,0,110,-49,110,-110xm221,-118r-129,0r0,-25r129,0r0,25","w":312},"\u0399":{"d":"28,-259r26,0r0,259r-26,0r0,-259","w":81},"\u039a":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259","w":212},"\u039b":{"d":"241,0r-28,0r-86,-200r-87,200r-28,0r113,-259r5,0","w":252},"\u039c":{"d":"20,0r36,-259r5,0r105,213r104,-213r4,0r37,259r-25,0r-26,-185r-91,185r-7,0r-92,-186r-25,186r-25,0","w":330},"\u039d":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0","w":266},"\u039e":{"d":"171,-233r-151,0r0,-26r151,0r0,26xm171,-127r-151,0r0,-25r151,0r0,25xm171,0r-151,0r0,-25r151,0r0,25","w":191},"\u039f":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"\u03a0":{"d":"215,0r-26,0r0,-234r-132,0r0,234r-26,0r0,-259r184,0r0,259","w":245},"\u03a1":{"d":"193,-190v-4,67,-55,73,-136,70r0,120r-26,0r0,-259r52,0v74,-3,102,12,110,69xm166,-190v0,-49,-56,-44,-109,-43r0,87v52,2,109,7,109,-44","w":213},"\u03a3":{"d":"163,0r-151,0r72,-129r-71,-130r147,0r0,25r-105,0r58,105r-59,104r109,0r0,25","w":180},"\u03a4":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0","w":153},"\u03a5":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124","w":213},"\u03a6":{"d":"292,-131v0,65,-57,103,-124,106r0,25r-26,0r0,-25v-69,-3,-123,-39,-124,-106v0,-65,56,-103,124,-105r0,-23r26,0r0,23v69,3,124,39,124,105xm168,-50v53,-3,98,-25,97,-81v-1,-53,-42,-78,-97,-82r0,163xm142,-213v-53,4,-99,26,-98,82v1,53,43,78,98,81r0,-163","w":309},"\u03a7":{"d":"18,-259r30,0r62,101r62,-101r30,0r-77,126r82,133r-30,0r-67,-108r-68,108r-30,0r83,-133","w":219},"\u03a8":{"d":"155,-88v56,-7,79,-26,79,-92r0,-79r26,0r0,90v3,74,-39,101,-105,106r0,63r-26,0r0,-63v-67,-6,-104,-31,-104,-108r0,-88r26,0v4,60,-15,134,29,157v13,7,29,12,49,14r0,-171r26,0r0,171","w":284},"\u03a9":{"d":"278,-145v-2,66,-31,86,-84,121r76,0r0,24r-99,0r0,-34v53,-38,77,-49,81,-110v3,-58,-43,-96,-101,-96v-58,0,-104,38,-101,96v3,61,27,72,80,110r0,34r-99,0r0,-24r76,0v-53,-36,-81,-54,-84,-121v-3,-72,56,-120,128,-120v72,0,130,49,127,120","w":301},"\u03aa":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-16,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm56,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":81},"\u03ab":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm50,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm122,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":213},"\u03ac":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm138,-281r-5,60r-20,0r-5,-60r30,0","w":245},"\u03ad":{"d":"44,-54v-1,44,65,45,86,16r15,18v-35,42,-127,31,-127,-34v0,-24,12,-41,35,-51v-50,-18,-24,-92,29,-92v19,0,38,8,55,22r-14,17v-24,-22,-73,-22,-73,16v0,23,20,34,46,31r0,21v-30,-4,-51,11,-52,36xm91,-281r-5,60r-20,0r-5,-60r30,0","w":152},"\u03ae":{"d":"52,-157v46,-67,142,-45,142,59r0,168r-24,0r0,-161v1,-49,-6,-82,-51,-82v-77,0,-68,89,-67,173r-25,0r0,-191r25,0r0,34xm125,-281r-5,60r-20,0r-5,-60r30,0","w":219},"\u03af":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm51,-281r-5,60r-20,0r-5,-60r30,0","w":72},"\u03b0":{"d":"108,5v-60,-2,-85,-34,-84,-104r0,-92r25,0v3,76,-19,172,59,172v43,0,63,-33,63,-77v0,-32,-15,-58,-45,-78r14,-22v82,37,74,205,-32,201xm122,-281r-5,60r-20,0r-5,-60r30,0xm166,-243v0,8,-8,16,-16,16v-8,0,-15,-8,-15,-16v0,-8,7,-15,15,-15v8,0,16,7,16,15xm79,-243v0,8,-7,16,-15,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15v8,0,15,7,15,15","w":214},"\u03b1":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"\u03b2":{"d":"197,-81v4,76,-105,120,-145,52r0,99r-25,0r0,-265v-2,-49,28,-72,71,-75v68,-5,86,95,25,112v42,3,72,34,74,77xm171,-80v-1,-47,-37,-65,-95,-62r0,-20v40,-1,60,-17,60,-48v1,-21,-15,-37,-36,-37v-72,0,-44,101,-48,166v-2,35,26,62,59,63v33,1,62,-29,60,-62","w":214},"\u03b3":{"d":"189,-191r-77,170r0,91r-25,0r0,-92r-78,-169r27,0r63,139r64,-139r26,0","w":199},"\u03b4":{"d":"103,5v-47,0,-85,-38,-85,-85v0,-39,20,-65,60,-79v-55,-32,-23,-111,42,-111v15,0,29,2,42,5r-6,22v-33,-10,-85,-4,-82,32v3,32,17,37,54,49v90,30,70,167,-25,167xm163,-80v1,-32,-28,-62,-60,-62v-32,0,-61,30,-60,62v0,33,26,62,60,62v34,0,60,-29,60,-62","w":205},"\u03b5":{"d":"44,-54v-1,44,65,45,86,16r15,18v-35,42,-127,31,-127,-34v0,-24,12,-41,35,-51v-50,-18,-24,-92,29,-92v19,0,38,8,55,22r-14,17v-24,-22,-73,-22,-73,16v0,23,20,34,46,31r0,21v-30,-4,-51,11,-52,36","w":152},"\u03b6":{"d":"154,-5v35,47,-26,97,-86,76r7,-22v35,13,87,-13,54,-41v-6,-4,-18,-9,-36,-12v-48,-9,-72,-37,-72,-85v0,-76,51,-106,108,-154r-88,0r0,-22r119,0r0,22v-60,56,-114,77,-114,152v0,43,17,57,58,66v27,6,44,11,50,20","w":167},"\u03b7":{"d":"52,-157v46,-67,142,-45,142,59r0,168r-24,0r0,-161v1,-49,-6,-82,-51,-82v-77,0,-68,89,-67,173r-25,0r0,-191r25,0r0,34","w":219},"\u03b8":{"d":"217,-132v0,75,-29,136,-99,137v-70,0,-100,-62,-100,-137v0,-75,32,-137,100,-138v69,0,100,63,99,138xm192,-143v-2,-56,-23,-105,-74,-105v-51,0,-72,50,-74,105r148,0xm44,-122v2,57,22,104,74,104v52,0,72,-47,74,-104r-148,0","w":235},"\u03b9":{"d":"24,-191r25,0r0,191r-25,0r0,-191","w":72},"\u03ba":{"d":"183,0r-35,0r-96,-86r0,86r-25,0r0,-191r25,0r0,77r88,-77r37,0r-105,91","w":180},"\u03bb":{"d":"189,0r-27,0r-63,-147r-66,147r-26,0r78,-177r-38,-88r26,0","w":193},"\u03bc":{"d":"101,-18v76,-1,69,-89,67,-173r24,0r0,191r-24,0r0,-34v-27,40,-86,55,-118,18r0,86r-25,0r0,-261r25,0v5,70,-23,174,51,173","w":219},"\u03bd":{"d":"9,-191r27,0r63,139r64,-139r26,0r-87,191r-5,0","w":199},"\u03be":{"d":"150,-8v42,44,-19,102,-82,79r7,-22v34,12,85,-11,56,-40v-5,-4,-20,-11,-42,-13v-87,-7,-87,-136,-14,-152v-71,-27,-38,-114,37,-114v18,0,34,3,49,7r-6,23v-34,-13,-98,-11,-95,33v2,35,45,48,88,44r0,21v-54,-4,-98,7,-102,57v-5,61,73,58,104,77","w":167},"\u03bf":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"\u03c0":{"d":"233,-170r-39,0r0,170r-25,0r0,-170r-97,0r0,170r-24,0r0,-170r-39,0r0,-21r224,0r0,21","w":241},"\u03c1":{"d":"223,-95v0,91,-127,139,-175,59r0,106r-24,0r0,-160v-2,-59,42,-106,99,-106v55,0,100,46,100,101xm198,-95v0,-41,-34,-77,-75,-77v-41,0,-74,36,-74,77v0,41,33,77,74,77v42,0,75,-34,75,-77","w":241},"\u03c2":{"d":"18,-94v0,-99,137,-140,181,-58r-20,13v-38,-61,-136,-33,-136,43v0,71,88,65,128,87v44,46,-17,102,-81,80r6,-22v35,13,88,-13,55,-41v-6,-4,-20,-9,-41,-12v-61,-10,-92,-39,-92,-90","w":208},"\u03c3":{"d":"18,-95v0,-64,62,-119,132,-96r101,0r0,21r-65,0v65,59,21,175,-68,175v-55,0,-100,-45,-100,-100xm192,-95v0,-41,-33,-77,-74,-77v-41,0,-75,35,-75,77v0,41,34,77,75,77v43,0,74,-36,74,-77","w":258},"\u03c4":{"d":"136,-170r-51,0r0,170r-25,0r0,-170r-51,0r0,-21r127,0r0,21","w":144},"\u03c5":{"d":"108,5v-60,-2,-85,-34,-84,-104r0,-92r25,0v3,76,-19,172,59,172v43,0,63,-33,63,-77v0,-32,-15,-58,-45,-78r14,-22v82,37,74,205,-32,201","w":214},"\u03c6":{"d":"257,-95v0,61,-46,97,-107,100r0,65r-25,0r0,-66v-86,5,-137,-92,-87,-159v13,-17,32,-28,55,-36r8,23v-38,14,-58,38,-58,73v0,45,27,70,82,75r0,-176v78,-4,132,31,132,101xm150,-172r0,152v81,1,105,-84,60,-130v-14,-15,-35,-21,-60,-22","w":275},"\u03c7":{"d":"166,-191r-66,123r74,138r-28,0r-60,-112r-61,112r-26,0r73,-137r-66,-124r27,0r53,98r53,-98r27,0","w":172},"\u03c8":{"d":"145,-19v52,-6,72,-27,72,-88r0,-84r24,0r0,94v2,70,-39,98,-96,102r0,65r-25,0r0,-65v-63,-6,-96,-31,-96,-104r0,-92r24,0v2,79,-19,172,72,171r0,-171r25,0r0,172","w":264},"\u03c9":{"d":"209,5v-27,0,-50,-17,-55,-40v-5,23,-27,39,-54,40v-85,4,-106,-118,-52,-168v21,-19,44,-31,75,-33r2,24v-48,2,-82,37,-82,86v0,40,19,68,55,68v40,0,46,-45,44,-91r25,0v-2,46,4,90,44,91v36,0,54,-29,54,-68v0,-49,-34,-84,-81,-86r2,-24v58,2,104,48,104,109v0,56,-30,91,-81,92","w":308},"\u03ca":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-20,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm52,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":72},"\u03cb":{"d":"108,5v-60,-2,-85,-34,-84,-104r0,-92r25,0v3,76,-19,172,59,172v43,0,63,-33,63,-77v0,-32,-15,-58,-45,-78r14,-22v82,37,74,205,-32,201xm51,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm123,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":214},"\u03cc":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm133,-281r-5,60r-20,0r-5,-60r30,0","w":235},"\u03cd":{"d":"108,5v-60,-2,-85,-34,-84,-104r0,-92r25,0v3,76,-19,172,59,172v43,0,63,-33,63,-77v0,-32,-15,-58,-45,-78r14,-22v82,37,74,205,-32,201xm122,-281r-5,60r-20,0r-5,-60r30,0","w":214},"\u03ce":{"d":"209,5v-27,0,-50,-17,-55,-40v-5,23,-27,39,-54,40v-85,4,-106,-118,-52,-168v21,-19,44,-31,75,-33r2,24v-48,2,-82,37,-82,86v0,40,19,68,55,68v40,0,46,-45,44,-91r25,0v-2,46,4,90,44,91v36,0,54,-29,54,-68v0,-49,-34,-84,-81,-86r2,-24v58,2,104,48,104,109v0,56,-30,91,-81,92xm169,-281r-5,60r-20,0r-5,-60r30,0","w":308},"\u0401":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm51,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm123,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":193},"\u0402":{"d":"195,-69v0,-60,-46,-57,-105,-56r0,125r-27,0r0,-233r-57,0r0,-26r141,0r0,26r-57,0r0,83v80,-4,131,7,131,81v0,66,-61,96,-103,58r16,-18v28,27,61,0,61,-40","w":241},"\u0403":{"d":"57,0r-26,0r0,-259r130,0r0,26r-104,0r0,233xm124,-333r38,0r-52,54r-24,0","w":166},"\u0404":{"d":"21,-131v1,77,57,138,139,138v48,0,86,-18,113,-52r-20,-15v-39,48,-114,56,-165,18v-22,-16,-34,-42,-39,-76r122,0r0,-25r-121,0v3,-97,151,-132,203,-52r20,-16v-22,-31,-63,-54,-113,-54v-76,-2,-140,59,-139,134","w":292},"\u0405":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70","w":179},"\u0406":{"d":"28,-259r26,0r0,259r-26,0r0,-259","w":81},"\u0407":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-16,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm56,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":81},"\u0408":{"d":"29,-41v36,34,87,33,87,-44r0,-174r26,0r0,175v15,96,-75,110,-127,63","w":173},"\u0409":{"d":"363,-73v-1,68,-58,76,-133,73r-96,-204r-97,204r-28,0r122,-259r6,0r54,111v84,0,174,-8,172,75xm336,-73v2,-63,-73,-47,-136,-49r46,97v53,1,89,-1,90,-48","w":383},"\u040a":{"d":"355,-77v2,86,-78,78,-166,77r0,-125r-132,0r0,125r-26,0r0,-259r26,0r0,109r132,0r0,-109r26,0r0,109v80,-3,138,1,140,73xm328,-76v-1,-56,-51,-49,-113,-49r0,100v61,0,114,8,113,-51","w":375},"\u040b":{"d":"195,0v-3,-58,17,-133,-50,-125r-55,0r0,125r-26,0r0,-233r-58,0r0,-26r142,0r0,26r-58,0r0,83v79,-3,141,-2,131,85r0,65r-26,0","w":244},"\u040c":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259xm135,-333r38,0r-52,54r-24,0","w":212},"\u040e":{"d":"33,-42v26,33,59,34,73,-8r-94,-208r29,0r78,176r72,-177r28,0r-98,233v-20,47,-81,39,-107,0xm78,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":232},"\u040f":{"d":"105,0r-74,0r0,-259r26,0r0,235r119,0r0,-235r26,0r0,259r-73,0r0,39r-24,0r0,-39","w":233},"\u0410":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"\u0411":{"d":"186,-74v2,43,-37,74,-84,74r-71,0r0,-259r130,0r0,26r-104,0r0,83v77,-3,126,12,129,76xm159,-74v0,-48,-46,-52,-102,-50r0,99v54,3,102,-2,102,-49","w":206},"\u0412":{"d":"187,-74v0,44,-37,75,-84,74r-71,0r0,-259v69,-3,134,0,134,64v0,26,-14,44,-33,54v32,11,54,28,54,67xm139,-195v1,-39,-40,-40,-82,-38r0,83v47,2,80,-5,82,-45xm160,-74v0,-47,-45,-52,-103,-50r0,99v55,2,103,-1,103,-49","w":206},"\u0413":{"d":"57,0r-26,0r0,-259r130,0r0,26r-104,0r0,233","w":166},"\u0414":{"d":"31,39r-26,0r0,-63r21,0r102,-235r9,0r107,235r20,0r0,63r-25,0r0,-39r-208,0r0,39xm56,-24r157,0r-81,-181","w":269},"\u0415":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259","w":193},"\u0416":{"d":"181,-120r0,120r-26,0r0,-120r-8,-7r-106,127r-34,0r123,-143r-113,-116r35,0r103,110r0,-110r26,0r0,110r104,-110r35,0r-114,116r123,143r-34,0r-106,-127","w":336},"\u0417":{"d":"150,-194v0,-51,-67,-62,-96,-24r-17,-15v37,-53,140,-38,140,34v0,28,-12,47,-38,59v34,11,51,34,51,69v0,66,-78,97,-134,66v-14,-8,-27,-21,-39,-40r20,-12v20,28,31,41,67,41v34,0,61,-21,59,-56v-2,-43,-31,-55,-80,-53r0,-22v41,2,68,-13,67,-47","w":209},"\u0418":{"d":"235,0r-27,0r0,-198r-171,198r-5,0r0,-259r25,0r0,202r172,-202r6,0r0,259","w":266},"\u0419":{"d":"235,0r-27,0r0,-198r-171,198r-5,0r0,-259r25,0r0,202r172,-202r6,0r0,259xm95,-320v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":266},"\u041a":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259","w":212},"\u041b":{"d":"241,0r-28,0r-86,-200r-87,200r-28,0r113,-259r5,0","w":252},"\u041c":{"d":"20,0r36,-259r5,0r105,213r104,-213r4,0r37,259r-25,0r-26,-185r-91,185r-7,0r-92,-186r-25,186r-25,0","w":330},"\u041d":{"d":"31,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259","w":245},"\u041e":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"\u041f":{"d":"31,-259r184,0r0,259r-26,0r0,-234r-132,0r0,234r-26,0r0,-259","w":245},"\u0420":{"d":"193,-190v-4,67,-55,73,-136,70r0,120r-26,0r0,-259r52,0v74,-3,102,12,110,69xm166,-190v0,-49,-56,-44,-109,-43r0,87v52,2,109,7,109,-44","w":213},"\u0421":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138","w":292},"\u0422":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0","w":153},"\u0423":{"d":"33,-42v26,33,59,34,73,-8r-94,-208r29,0r78,176r72,-177r28,0r-98,233v-20,47,-81,39,-107,0","w":232},"\u0424":{"d":"20,-148v0,-59,49,-83,124,-78r0,-33r26,0r0,33v74,-4,123,17,123,78v0,58,-50,80,-123,74r0,74r-26,0r0,-74v-71,5,-124,-11,-124,-74xm266,-149v0,-46,-44,-55,-96,-52r0,102v51,4,96,-3,96,-50xm47,-149v-1,47,44,54,97,50r0,-102v-51,-3,-97,6,-97,52","w":313},"\u0425":{"d":"18,-259r30,0r62,101r62,-101r30,0r-77,126r82,133r-30,0r-67,-108r-68,108r-30,0r83,-133","w":219},"\u0426":{"d":"223,0r-192,0r0,-259r26,0r0,235r120,0r0,-235r26,0r0,235r44,0r0,63r-24,0r0,-39","w":254},"\u0427":{"d":"31,-259v-4,71,-1,126,83,112r23,0r0,-112r26,0r0,259r-26,0r0,-122v-82,3,-135,-5,-131,-85r0,-52r25,0","w":194},"\u0428":{"d":"57,-24r111,0r0,-235r26,0r0,235r112,0r0,-235r26,0r0,259r-301,0r0,-259r26,0r0,235","w":362},"\u0429":{"d":"332,-24r44,0r0,63r-24,0r0,-39r-321,0r0,-259r26,0r0,235r111,0r0,-235r26,0r0,235r112,0r0,-235r26,0r0,235","w":383},"\u042a":{"d":"226,-75v1,82,-80,76,-167,75r0,-234r-53,0r0,-25r79,0r0,111v82,-1,140,0,141,73xm199,-73v-1,-56,-51,-50,-114,-49r0,97v62,-1,115,8,114,-48","w":246},"\u042b":{"d":"198,-75v2,82,-80,76,-167,75r0,-259r26,0r0,111v82,-2,139,1,141,73xm171,-73v-1,-56,-51,-50,-114,-49r0,97v62,-1,115,8,114,-48xm228,-259r26,0r0,259r-26,0r0,-259","w":285},"\u042c":{"d":"198,-75v2,82,-80,76,-167,75r0,-259r26,0r0,111v82,-2,139,1,141,73xm171,-73v-1,-56,-51,-50,-114,-49r0,97v62,-1,115,8,114,-48","w":218},"\u042d":{"d":"272,-131v-1,77,-57,138,-139,138v-48,0,-86,-18,-113,-52r20,-15v39,48,114,56,165,18v22,-16,34,-42,39,-76r-122,0r0,-25r121,0v-3,-97,-151,-132,-203,-52r-20,-16v22,-31,63,-54,113,-54v76,-2,140,59,139,134","w":292},"\u042e":{"d":"238,7v-73,-1,-131,-54,-136,-126r-45,0r0,119r-26,0r0,-259r26,0r0,116r45,0v9,-71,63,-120,134,-122v76,-2,138,61,138,136v0,75,-62,137,-136,136xm237,-19v60,0,110,-48,110,-110v0,-61,-51,-111,-110,-111v-58,0,-108,51,-108,112v0,59,51,109,108,109","w":394},"\u042f":{"d":"16,-190v0,50,35,70,90,70r-93,120r32,0r93,-120r14,0r0,120r26,0r0,-259v-84,-2,-162,-5,-162,69xm43,-190v0,-49,56,-44,109,-43r0,88v-53,1,-109,5,-109,-45","w":210},"\u0430":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"\u0431":{"d":"18,-131v0,-126,66,-137,192,-138r0,23v-33,8,-114,1,-137,21v-21,18,-34,52,-34,92v11,-39,40,-62,84,-63v55,-1,100,47,100,101v0,53,-46,102,-100,100v-68,-3,-105,-55,-105,-136xm123,-18v41,0,75,-36,75,-77v0,-40,-36,-77,-75,-77v-39,0,-75,36,-75,77v0,41,34,77,75,77","w":240},"\u0432":{"d":"27,-191v56,-2,116,-3,114,48v0,19,-9,32,-26,39v25,9,38,26,38,51v0,55,-66,56,-126,53r0,-191xm115,-139v0,-32,-25,-33,-63,-31r0,60v36,1,63,2,63,-29xm125,-53v0,-35,-36,-37,-73,-35r0,67v38,1,73,4,73,-32","w":168},"\u0433":{"d":"52,-170r0,170r-25,0r0,-191r97,0r0,21r-72,0","w":129},"\u0434":{"d":"29,-21r74,-170r13,0r73,170r23,0r0,45r-24,0r0,-24r-158,0r0,25r-24,0r0,-46r23,0xm109,-153r-56,132r109,0","w":217},"\u0435":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0","w":233},"\u0436":{"d":"126,-191r24,0r0,84r92,-84r30,0r-90,85r97,106r-32,0r-82,-92r-15,11r0,81r-24,0r0,-81r-14,-11r-83,92r-31,0r96,-106r-89,-85r30,0r91,84r0,-84","w":276},"\u0437":{"d":"111,-54v-1,-27,-22,-39,-52,-36r0,-21v26,2,46,-7,46,-31v0,-38,-49,-38,-73,-16r-14,-17v35,-36,110,-26,111,29v0,20,-9,34,-27,41v59,21,37,110,-29,110v-26,0,-47,-8,-63,-25r15,-18v21,29,86,28,86,-16","w":152},"\u0438":{"d":"52,-191r0,141r142,-141r0,191r-24,0r0,-140r-140,140r-3,0r0,-191r25,0","w":221},"\u0439":{"d":"52,-191r0,141r142,-141r0,191r-24,0r0,-140r-140,140r-3,0r0,-191r25,0xm72,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":221},"\u043a":{"d":"27,-191r25,0r0,80r89,-80r34,0r-97,87r105,104r-35,0r-88,-88r-8,6r0,82r-25,0r0,-191","w":180},"\u043b":{"d":"189,0r-26,0r-64,-139r-63,139r-27,0r88,-191r4,0","w":199},"\u043c":{"d":"235,-191r7,0r65,191r-26,0r-47,-141r-74,141r-4,0r-74,-141r-47,141r-26,0r66,-191r6,0r77,149","w":316},"\u043d":{"d":"163,-92r-111,0r0,92r-25,0r0,-191r25,0r0,76r111,0r0,-76r25,0r0,191r-25,0r0,-92","w":215},"\u043e":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"\u043f":{"d":"27,-191r161,0r0,191r-25,0r0,-168r-111,0r0,168r-25,0r0,-191","w":215},"\u0440":{"d":"129,5v-35,-2,-59,-16,-77,-38r0,103r-24,0r0,-261r24,0r0,35v17,-23,40,-39,76,-40v54,-1,99,47,99,100v0,53,-45,102,-98,101xm202,-95v0,-45,-31,-76,-76,-77v-41,-1,-76,35,-76,77v0,46,33,77,77,77v43,0,75,-34,75,-77","w":245},"\u0441":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99","w":232},"\u0442":{"d":"6,-191r126,0r0,21r-51,0r0,170r-25,0r0,-170r-50,0r0,-21","w":137},"\u0443":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84","w":193},"\u0444":{"d":"18,-94v-9,-88,116,-138,165,-68r0,-103r24,0r0,103v48,-70,174,-19,164,68v9,87,-118,138,-164,65r0,99r-24,0r0,-99v-46,72,-174,21,-165,-65xm272,-173v-41,2,-66,33,-66,82v0,41,28,73,65,73v44,1,76,-36,76,-78v0,-42,-35,-78,-75,-77xm117,-173v-41,-1,-74,36,-74,78v0,42,33,80,76,77v42,-3,65,-28,65,-78v0,-45,-27,-76,-67,-77","w":389},"\u0445":{"d":"6,-191r29,0r51,71r50,-71r30,0r-65,91r73,100r-30,0r-58,-80r-58,80r-29,0r72,-100","w":172},"\u0446":{"d":"206,0r-179,0r0,-191r25,0r0,168r111,0r0,-168r25,0r0,168r41,0r0,53r-23,0r0,-30","w":235},"\u0447":{"d":"36,-191v1,45,-7,90,41,84r36,0r0,-84r24,0r0,191r-24,0r0,-86v-56,4,-104,-2,-101,-57r0,-48r24,0","w":164},"\u0448":{"d":"313,0r-286,0r0,-191r25,0r0,168r106,0r0,-168r25,0r0,168r105,0r0,-168r25,0r0,191","w":340},"\u0449":{"d":"331,0r-304,0r0,-191r25,0r0,168r106,0r0,-168r25,0r0,168r105,0r0,-168r25,0r0,168r42,0r0,53r-24,0r0,-30","w":360},"\u044a":{"d":"175,-57v1,59,-66,61,-130,57r0,-169r-35,0r0,-22r59,0r0,76v60,-4,105,5,106,58xm148,-57v-2,-37,-36,-40,-79,-38r0,74v40,2,81,-2,79,-36","w":186},"\u044b":{"d":"158,-57v1,59,-67,60,-131,57r0,-191r25,0r0,76v60,-4,105,6,106,58xm131,-56v0,-38,-36,-38,-78,-37r0,72v39,2,78,-2,78,-35xm192,-191r24,0r0,191r-24,0r0,-191","w":241},"\u044c":{"d":"158,-57v1,59,-67,60,-131,57r0,-191r25,0r0,76v60,-4,105,6,106,58xm131,-56v0,-38,-36,-38,-78,-37r0,72v39,2,78,-2,78,-35","w":169},"\u044d":{"d":"213,-94v0,-97,-146,-139,-195,-58r20,13v37,-58,143,-33,150,29r-85,0r0,22r85,0v-3,70,-110,95,-150,37r-20,13v16,27,51,42,90,43v58,3,105,-45,105,-99","w":231},"\u044e":{"d":"183,5v-53,0,-95,-41,-99,-92r-32,0r0,87r-24,0r0,-191r24,0r0,80r32,0v7,-47,47,-85,99,-85v55,0,100,47,100,101v0,53,-46,100,-100,100xm183,-18v41,0,75,-36,75,-77v0,-41,-36,-77,-75,-77v-39,0,-76,37,-75,77v0,41,33,77,75,77","w":300},"\u044f":{"d":"19,-138v0,-57,57,-55,114,-53r0,191r-25,0r0,-86r-17,0r-55,86r-27,0r58,-88v-26,-3,-48,-22,-48,-50xm43,-137v1,32,27,31,65,30r0,-63v-37,0,-67,-3,-65,33","w":160},"\u0451":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm61,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm133,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":233},"\u0452":{"d":"125,-173v-79,0,-67,90,-67,173r-25,0r0,-220r-27,0r0,-21r27,0r0,-24r25,0r0,24r84,0r0,21r-84,0r0,63v47,-69,141,-43,142,59r1,127v2,45,-28,54,-61,40r0,-22v30,14,40,-7,36,-47v-6,-70,23,-174,-51,-173","w":225},"\u0453":{"d":"52,-170r0,170r-25,0r0,-191r97,0r0,21r-72,0xm91,-281r38,0r-52,54r-24,0","w":129},"\u0454":{"d":"18,-94v0,-97,146,-139,195,-58r-20,13v-37,-58,-143,-33,-150,29r85,0r0,22r-85,0v3,70,110,95,150,37r20,13v-16,27,-51,42,-90,43v-58,3,-105,-45,-105,-99","w":231},"\u0455":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96","w":139},"\u0456":{"d":"16,-250v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-11,0,-20,-10,-20,-21xm24,-191r25,0r0,191r-25,0r0,-191","w":72},"\u0457":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-20,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm52,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":72},"\u0458":{"d":"16,-250v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21xm-11,47v21,10,35,5,35,-25r0,-213r25,0r0,220v4,42,-26,55,-60,40r0,-22","w":73},"\u0459":{"d":"274,-57v0,50,-51,63,-111,57r-65,-146r-64,146r-25,0r88,-191r4,0r36,76v69,-2,137,-4,137,58xm247,-56v0,-45,-54,-37,-101,-37r33,72v37,2,68,-6,68,-35","w":285},"\u045a":{"d":"293,-57v2,59,-66,61,-130,57r0,-92r-111,0r0,92r-25,0r0,-191r25,0r0,76r111,0r0,-76r25,0r0,76v60,-4,103,7,105,58xm266,-55v0,-38,-36,-38,-78,-37r0,71v38,2,78,-1,78,-34","w":304},"\u045b":{"d":"125,-173v-78,1,-67,90,-67,173r-24,0r0,-220r-28,0r0,-21r28,0r0,-24r24,0r0,24r84,0r0,21r-84,0r0,63v47,-69,159,-42,142,59r0,98r-24,0v-6,-69,24,-175,-51,-173","w":225},"\u045c":{"d":"27,-191r25,0r0,80r89,-80r34,0r-97,87r105,104r-35,0r-88,-88r-8,6r0,82r-25,0r0,-191xm114,-281r38,0r-52,54r-24,0","w":180},"\u045e":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm58,-268v12,24,66,25,78,0r23,0v-9,49,-116,49,-125,0r24,0","w":193},"\u045f":{"d":"95,0r-67,0r0,-191r24,0r0,168r111,0r0,-168r25,0r0,191r-70,0r0,30r-23,0r0,-30","w":215},"\u0490":{"d":"57,0r-26,0r0,-259r84,0r0,-37r25,0r0,63r-83,0r0,233","w":145},"\u0491":{"d":"52,-170r0,170r-25,0r0,-191r68,0r0,-24r24,0r0,45r-67,0","w":128},"\u1e80":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0xm162,-333r39,54r-25,0r-51,-54r37,0","w":345},"\u1e81":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0xm139,-281r39,54r-25,0r-51,-54r37,0","w":299},"\u1e82":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0xm184,-333r38,0r-52,54r-24,0","w":345},"\u1e83":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0xm161,-281r38,0r-52,54r-24,0","w":299},"\u1e84":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0xm117,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm189,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":345},"\u1e85":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0xm93,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm165,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":299},"\u1ef2":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm96,-333r39,54r-25,0r-51,-54r37,0","w":213},"\u1ef3":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm85,-281r39,54r-25,0r-51,-54r37,0","w":193},"\u2015":{"d":"-2,-112r274,0r0,23r-274,0r0,-23","w":270},"\u201b":{"d":"65,-169v-16,-27,-15,-54,-15,-96r32,0r0,48r-16,0v1,13,6,27,13,41","w":126},"\u203e":{"d":"-7,-329r214,0r0,13r-214,0r0,-13","w":199},"\u20a4":{"d":"114,-242v-40,0,-48,36,-32,72r63,0r0,23r-56,0r5,20r51,0r0,22r-46,0v3,18,3,46,-2,59v22,18,38,26,48,26v11,0,18,-13,19,-40r25,0v0,32,-11,66,-40,67v-18,0,-39,-10,-61,-29v-10,19,-24,29,-42,29v-20,0,-36,-12,-36,-34v0,-31,35,-52,64,-33v3,-17,3,-30,-1,-45r-56,0r0,-22r51,0r-6,-20r-45,0r0,-23r39,0v-33,-70,51,-125,100,-77v12,11,17,28,18,49r-24,0v-1,-29,-13,-44,-36,-44xm34,-30v4,21,29,14,34,-6v-13,-11,-32,-12,-34,6","w":199},"\u2116":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0xm325,-172v33,0,61,28,61,61v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61v0,-33,28,-61,61,-61xm325,-73v21,0,39,-18,39,-38v1,-20,-18,-39,-39,-39v-21,0,-39,19,-39,39v0,20,18,38,39,38xm264,-18r122,0r0,18r-122,0r0,-18","w":395},"\u212e":{"d":"16,-93v0,-86,99,-132,157,-75v18,17,28,42,29,75r-146,0r0,65v37,35,99,25,122,-22r13,7v-23,32,-40,48,-82,49v-55,2,-93,-44,-93,-99xm161,-106r0,-53v-28,-28,-79,-28,-105,1r0,52r105,0","w":216},"\u215b":{"d":"50,7r162,-272r20,0r-163,272r-19,0xm40,-262r32,0r0,133r-19,0r0,-116r-26,0xm240,-136v38,0,62,46,25,63v47,18,23,76,-26,76v-49,0,-72,-58,-25,-76v-38,-18,-13,-63,26,-63xm214,-101v0,26,50,28,50,0v0,-13,-12,-18,-25,-18v-12,0,-25,7,-25,18xm207,-37v1,32,65,30,64,-1v0,-15,-14,-26,-31,-26v-17,0,-34,11,-33,27","w":299},"\u215c":{"d":"84,-230v-5,-25,-47,-24,-54,3r-19,0v4,-51,91,-49,93,-2v0,10,-5,18,-16,25v47,19,19,78,-29,78v-30,0,-48,-14,-53,-42r19,0v3,35,68,32,68,-1v0,-18,-18,-25,-44,-25r0,-17v16,0,35,-5,35,-19xm59,7r162,-272r19,0r-162,272r-19,0xm240,-136v38,0,62,46,25,63v47,18,23,81,-26,76v-49,5,-72,-58,-25,-76v-39,-18,-12,-63,26,-63xm214,-101v0,26,51,28,50,0v0,-13,-11,-18,-25,-18v-12,0,-25,7,-25,18xm207,-37v1,32,65,30,64,-1v0,-15,-14,-26,-31,-26v-17,0,-34,11,-33,27","w":299},"\u215d":{"d":"59,7r162,-272r19,0r-162,272r-19,0xm92,-173v-2,-30,-38,-30,-69,-21r15,-68r70,0r0,17r-55,0r-7,31v34,-8,64,11,66,41v3,54,-98,65,-105,10r20,0v5,32,68,23,65,-10xm240,-136v38,-4,62,46,25,63v47,18,23,76,-26,76v-49,0,-72,-58,-25,-76v-39,-18,-12,-67,26,-63xm214,-101v0,26,51,28,50,0v0,-13,-11,-18,-25,-18v-12,0,-25,7,-25,18xm207,-37v1,32,65,30,64,-1v0,-15,-14,-26,-31,-26v-17,0,-34,11,-33,27","w":299},"\u215e":{"d":"46,7r162,-272r19,0r-162,272r-19,0xm14,-262r102,0r-83,136r-16,-7r68,-112r-71,0r0,-17xm240,-136v38,-4,62,46,25,63v47,18,23,76,-26,76v-49,0,-72,-58,-25,-76v-38,-18,-12,-67,26,-63xm214,-101v0,26,50,28,50,0v0,-13,-12,-18,-25,-18v-12,0,-25,7,-25,18xm207,-37v1,32,65,30,64,-1v0,-15,-14,-26,-31,-26v-17,0,-34,11,-33,27","w":299},"\u2302":{"d":"27,0r0,-111r81,-92r81,92r0,111r-162,0xm41,-14r134,0r0,-91r-67,-76r-67,76r0,91","w":216},"\u2310":{"d":"20,-180r178,0r0,24r-154,0r0,77r-24,0r0,-101","w":218},"\u2320":{"d":"130,-287v-12,2,-9,10,-9,31r0,347r-26,0r0,-319v-1,-40,18,-74,52,-77v26,-2,32,33,8,35v-14,1,-15,-15,-25,-17","w":216},"\u2321":{"d":"86,72v12,-2,9,-10,9,-31r0,-346r26,0r0,318v1,41,-18,75,-52,78v-25,2,-33,-33,-9,-36v13,-1,17,15,26,17","w":216},"\u2500":{"d":"260,-94r-263,0r0,-31r263,0r0,31"},"\u2502":{"d":"113,109r0,-437r31,0r0,437r-31,0"},"\u250c":{"d":"260,-125r0,31r-116,0r0,203r-31,0r0,-234r147,0"},"\u2510":{"d":"113,-94r-116,0r0,-31r147,0r0,234r-31,0r0,-203"},"\u2514":{"d":"113,-94r0,-234r31,0r0,203r116,0r0,31r-147,0"},"\u2518":{"d":"144,-94r-147,0r0,-31r116,0r0,-203r31,0r0,234"},"\u251c":{"d":"113,109r0,-437r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0"},"\u2524":{"d":"113,109r0,-203r-116,0r0,-31r116,0r0,-203r31,0r0,437r-31,0"},"\u252c":{"d":"113,-94r-116,0r0,-31r263,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2534":{"d":"260,-94r-263,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31"},"\u253c":{"d":"113,-94r-116,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2550":{"d":"260,-127r-263,0r0,-31r263,0r0,31xm260,-60r-263,0r0,-31r263,0r0,31"},"\u2551":{"d":"146,109r0,-437r31,0r0,437r-31,0xm80,109r0,-437r30,0r0,437r-30,0"},"\u2552":{"d":"113,109r0,-267r147,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u2553":{"d":"80,109r0,-234r180,0r0,31r-83,0r0,203r-31,0r0,-200r-36,0r0,200r-30,0"},"\u2554":{"d":"110,109r-30,0r0,-267r180,0r0,31r-150,0r0,236xm177,-60r0,169r-31,0r0,-200r114,0r0,31r-83,0"},"\u2555":{"d":"113,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r147,0r0,267r-31,0r0,-169"},"\u2556":{"d":"79,109r0,-203r-82,0r0,-31r180,0r0,234r-31,0r0,-203r-36,0r0,203r-31,0"},"\u2557":{"d":"146,109r0,-236r-149,0r0,-31r180,0r0,267r-31,0xm79,-60r-82,0r0,-31r113,0r0,200r-31,0r0,-169"},"\u2558":{"d":"113,-60r0,-268r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-147,0"},"\u2559":{"d":"260,-94r-180,0r0,-234r30,0r0,203r36,0r0,-203r31,0r0,203r83,0r0,31"},"\u255a":{"d":"110,-328r0,237r150,0r0,31r-180,0r0,-268r30,0xm177,-158r83,0r0,31r-114,0r0,-201r31,0r0,170"},"\u255b":{"d":"144,-60r-147,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,268"},"\u255c":{"d":"177,-94r-180,0r0,-31r82,0r0,-203r31,0r0,203r36,0r0,-203r31,0r0,234"},"\u255d":{"d":"146,-328r31,0r0,268r-180,0r0,-31r149,0r0,-237xm79,-158r0,-170r31,0r0,201r-113,0r0,-31r82,0"},"\u255e":{"d":"113,109r0,-437r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u255f":{"d":"146,109r0,-437r31,0r0,203r83,0r0,31r-83,0r0,203r-31,0xm80,109r0,-437r30,0r0,437r-30,0"},"\u2560":{"d":"80,109r0,-437r30,0r0,437r-30,0xm146,-127r0,-201r31,0r0,170r83,0r0,31r-114,0xm146,109r0,-200r114,0r0,31r-83,0r0,169r-31,0"},"\u2561":{"d":"113,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,437r-31,0r0,-169"},"\u2562":{"d":"79,109r0,-203r-82,0r0,-31r82,0r0,-203r31,0r0,437r-31,0xm146,109r0,-437r31,0r0,437r-31,0"},"\u2563":{"d":"146,109r0,-437r31,0r0,437r-31,0xm110,-328r0,201r-113,0r0,-31r82,0r0,-170r31,0xm79,-60r-82,0r0,-31r113,0r0,200r-31,0r0,-169"},"\u2564":{"d":"260,-127r-263,0r0,-31r263,0r0,31xm113,-60r-116,0r0,-31r263,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u2565":{"d":"79,109r0,-203r-82,0r0,-31r263,0r0,31r-83,0r0,203r-31,0r0,-200r-36,0r0,200r-31,0"},"\u2566":{"d":"260,-127r-263,0r0,-31r263,0r0,31xm79,-60r-82,0r0,-31r113,0r0,200r-31,0r0,-169xm146,109r0,-200r114,0r0,31r-83,0r0,169r-31,0"},"\u2567":{"d":"260,-127r-263,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31xm260,-60r-263,0r0,-31r263,0r0,31"},"\u2568":{"d":"260,-94r-263,0r0,-31r82,0r0,-203r31,0r0,203r36,0r0,-203r31,0r0,203r83,0r0,31"},"\u2569":{"d":"110,-127r-113,0r0,-31r82,0r0,-170r31,0r0,201xm260,-127r-114,0r0,-201r31,0r0,170r83,0r0,31xm260,-60r-263,0r0,-31r263,0r0,31"},"\u256a":{"d":"113,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u256b":{"d":"79,109r0,-203r-82,0r0,-31r82,0r0,-203r31,0r0,203r36,0r0,-203r31,0r0,203r83,0r0,31r-83,0r0,203r-31,0r0,-203r-36,0r0,203r-31,0"},"\u256c":{"d":"177,-158r83,0r0,31r-114,0r0,-201r31,0r0,170xm79,-158r0,-170r31,0r0,201r-113,0r0,-31r82,0xm79,-60r-82,0r0,-31r113,0r0,200r-31,0r0,-169xm177,-60r0,169r-31,0r0,-200r114,0r0,31r-83,0"},"\u2580":{"d":"260,-109r-263,0r0,-219r263,0r0,219"},"\u2584":{"d":"260,109r-263,0r0,-218r263,0r0,218"},"\u2588":{"d":"-3,109r0,-437r263,0r0,437r-263,0"},"\u258c":{"d":"-3,109r0,-437r131,0r0,437r-131,0"},"\u2590":{"d":"128,109r0,-437r132,0r0,437r-132,0"},"\u2591":{"d":"19,-328r22,0r0,22r-22,0r0,-22xm106,-328r22,0r0,22r-22,0r0,-22xm194,-328r22,0r0,22r-22,0r0,-22xm63,-284r22,0r0,22r-22,0r0,-22xm150,-284r22,0r0,22r-22,0r0,-22xm238,-284r22,0r0,22r-22,0r0,-22xm194,-240r22,0r0,22r-22,0r0,-22xm106,-240r22,0r0,22r-22,0r0,-22xm19,-240r22,0r0,22r-22,0r0,-22xm238,-196r22,0r0,22r-22,0r0,-22xm150,-196r22,0r0,22r-22,0r0,-22xm63,-196r22,0r0,22r-22,0r0,-22xm19,-152r22,0r0,22r-22,0r0,-22xm106,-152r22,0r0,22r-22,0r0,-22xm194,-152r22,0r0,22r-22,0r0,-22xm238,-109r22,0r0,22r-22,0r0,-22xm150,-109r22,0r0,22r-22,0r0,-22xm63,-109r22,0r0,22r-22,0r0,-22xm19,-65r22,0r0,22r-22,0r0,-22xm106,-65r22,0r0,22r-22,0r0,-22xm194,-65r22,0r0,22r-22,0r0,-22xm63,-21r22,0r0,22r-22,0r0,-22xm150,-21r22,0r0,22r-22,0r0,-22xm238,-21r22,0r0,22r-22,0r0,-22xm194,23r22,0r0,22r-22,0r0,-22xm106,23r22,0r0,22r-22,0r0,-22xm19,23r22,0r0,22r-22,0r0,-22xm63,67r22,0r0,22r-22,0r0,-22xm150,67r22,0r0,22r-22,0r0,-22xm238,67r22,0r0,22r-22,0r0,-22"},"\u2592":{"d":"19,-328r22,0r0,22r-22,0r0,-22xm63,-328r21,0r0,22r-21,0r0,-22xm106,-328r22,0r0,22r-22,0r0,-22xm150,-328r22,0r0,22r-22,0r0,-22xm194,-328r22,0r0,22r-22,0r0,-22xm238,-328r22,0r0,22r-22,0r0,-22xm-3,-284r22,0r0,22r-22,0r0,-22xm41,-284r22,0r0,22r-22,0r0,-22xm84,-284r22,0r0,22r-22,0r0,-22xm128,-284r22,0r0,22r-22,0r0,-22xm172,-284r22,0r0,22r-22,0r0,-22xm216,-284r22,0r0,22r-22,0r0,-22xm19,-240r22,0r0,22r-22,0r0,-22xm63,-240r21,0r0,22r-21,0r0,-22xm106,-240r22,0r0,22r-22,0r0,-22xm150,-240r22,0r0,22r-22,0r0,-22xm194,-240r22,0r0,22r-22,0r0,-22xm238,-240r22,0r0,22r-22,0r0,-22xm-3,-196r22,0r0,22r-22,0r0,-22xm41,-196r22,0r0,22r-22,0r0,-22xm84,-196r22,0r0,22r-22,0r0,-22xm128,-196r22,0r0,22r-22,0r0,-22xm172,-196r22,0r0,22r-22,0r0,-22xm216,-196r22,0r0,22r-22,0r0,-22xm19,-152r22,0r0,22r-22,0r0,-22xm63,-152r21,0r0,22r-21,0r0,-22xm106,-152r22,0r0,22r-22,0r0,-22xm150,-152r22,0r0,22r-22,0r0,-22xm194,-152r22,0r0,22r-22,0r0,-22xm238,-152r22,0r0,22r-22,0r0,-22xm-3,-109r22,0r0,22r-22,0r0,-22xm84,-109r22,0r0,22r-22,0r0,-22xm128,-109r22,0r0,22r-22,0r0,-22xm172,-109r22,0r0,22r-22,0r0,-22xm216,-109r22,0r0,22r-22,0r0,-22xm41,-109r22,0r0,22r-22,0r0,-22xm238,-65r22,0r0,22r-22,0r0,-22xm194,-65r22,0r0,22r-22,0r0,-22xm150,-65r22,0r0,22r-22,0r0,-22xm106,-65r22,0r0,22r-22,0r0,-22xm63,-65r21,0r0,22r-21,0r0,-22xm19,-65r22,0r0,22r-22,0r0,-22xm-3,-21r22,0r0,22r-22,0r0,-22xm41,-21r22,0r0,22r-22,0r0,-22xm84,-21r22,0r0,22r-22,0r0,-22xm128,-21r22,0r0,22r-22,0r0,-22xm172,-21r22,0r0,22r-22,0r0,-22xm216,-21r22,0r0,22r-22,0r0,-22xm238,23r22,0r0,22r-22,0r0,-22xm194,23r22,0r0,22r-22,0r0,-22xm150,23r22,0r0,22r-22,0r0,-22xm106,23r22,0r0,22r-22,0r0,-22xm63,23r21,0r0,22r-21,0r0,-22xm19,23r22,0r0,22r-22,0r0,-22xm-3,67r22,0r0,22r-22,0r0,-22xm41,67r22,0r0,22r-22,0r0,-22xm84,67r22,0r0,22r-22,0r0,-22xm128,67r22,0r0,22r-22,0r0,-22xm172,67r22,0r0,22r-22,0r0,-22xm216,67r22,0r0,22r-22,0r0,-22"},"\u2593":{"d":"263,-262r0,66r-22,0r0,22r22,0r0,65r-22,0r0,22r22,0r0,66r-22,0r0,22r22,0r0,66r-22,0r0,22r22,0r0,21r-263,0r0,-65r22,0r0,-22r-22,0r0,-66r22,0r0,-22r-22,0r0,-65r22,0r0,-22r-22,0r0,-66r22,0r0,-22r-22,0r0,-66r22,0r0,-22r22,0r0,22r22,0r0,-22r22,0r0,22r22,0r0,-22r21,0r0,22r22,0r0,-22r22,0r0,22r22,0r0,-22r22,0r0,22r22,0r0,-22r22,0r0,44r-22,0r0,22r22,0xm22,-284r0,22r22,0r0,-22r-22,0xm66,-284r0,22r22,0r0,-22r-22,0xm110,-284r0,22r21,0r0,-22r-21,0xm153,-284r0,22r22,0r0,-22r-22,0xm197,-284r0,22r22,0r0,-22r-22,0xm241,-240r-22,0r0,22r22,0r0,-22xm197,-240r-22,0r0,22r22,0r0,-22xm153,-240r-22,0r0,22r22,0r0,-22xm110,-240r-22,0r0,22r22,0r0,-22xm66,-240r-22,0r0,22r22,0r0,-22xm22,-196r0,22r22,0r0,-22r-22,0xm66,-196r0,22r22,0r0,-22r-22,0xm110,-196r0,22r21,0r0,-22r-21,0xm153,-196r0,22r22,0r0,-22r-22,0xm197,-196r0,22r22,0r0,-22r-22,0xm66,-152r-22,0r0,22r22,0r0,-22xm88,-152r0,22r22,0r0,-22r-22,0xm131,-152r0,22r22,0r0,-22r-22,0xm175,-152r0,22r22,0r0,-22r-22,0xm219,-152r0,22r22,0r0,-22r-22,0xm22,-109r0,22r22,0r0,-22r-22,0xm110,-109r0,22r21,0r0,-22r-21,0xm88,-87r0,-22r-22,0r0,22r22,0xm153,-109r0,22r22,0r0,-22r-22,0xm197,-109r0,22r22,0r0,-22r-22,0xm241,-43r0,-22r-22,0r0,22r22,0xm197,-43r0,-22r-22,0r0,22r22,0xm153,-43r0,-22r-22,0r0,22r22,0xm110,-43r0,-22r-22,0r0,22r22,0xm66,-43r0,-22r-22,0r0,22r22,0xm22,-21r0,22r22,0r0,-22r-22,0xm66,-21r0,22r22,0r0,-22r-22,0xm110,-21r0,22r21,0r0,-22r-21,0xm153,-21r0,22r22,0r0,-22r-22,0xm197,-21r0,22r22,0r0,-22r-22,0xm241,45r0,-22r-22,0r0,22r22,0xm197,45r0,-22r-22,0r0,22r22,0xm153,45r0,-22r-22,0r0,22r22,0xm110,45r0,-22r-22,0r0,22r22,0xm66,45r0,-22r-22,0r0,22r22,0xm22,67r0,22r22,0r0,-22r-22,0xm66,67r0,22r22,0r0,-22r-22,0xm110,67r0,22r21,0r0,-22r-21,0xm153,67r0,22r22,0r0,-22r-22,0xm197,67r0,22r22,0r0,-22r-22,0","w":262},"\u25a0":{"d":"26,-166r166,0r0,166r-166,0r0,-166","w":217},"\u25ac":{"d":"0,-124r360,0r0,68r-360,0r0,-68","w":360},"\u25b2":{"d":"53,0r125,-249r125,249r-250,0","w":356},"\u25ba":{"d":"51,-249r255,127r-255,127r0,-254","w":356},"\u25bc":{"d":"303,-244r-125,249r-125,-249r250,0","w":356},"\u25c4":{"d":"306,-249r0,254r-255,-127","w":356},"\u25cb":{"d":"108,-179v41,0,77,35,77,77v0,42,-36,78,-77,78v-41,0,-77,-36,-77,-78v0,-42,36,-77,77,-77xm108,-37v34,0,64,-31,64,-65v0,-34,-30,-64,-64,-64v-34,0,-64,31,-64,64v0,33,30,65,64,65","w":216},"\u25d8":{"d":"22,0r0,-172r172,0r0,172r-172,0xm108,-51v19,0,35,-16,35,-35v0,-19,-16,-36,-35,-36v-19,0,-36,17,-36,36v0,19,17,35,36,35","w":216},"\u25d9":{"d":"7,0r0,-203r203,0r0,203r-203,0xm108,-24v41,0,78,-36,78,-77v0,-41,-37,-78,-78,-78v-41,0,-77,36,-77,78v0,42,36,77,77,77xm108,-166v34,0,64,30,64,65v0,34,-30,64,-64,64v-34,0,-64,-30,-64,-64v0,-34,30,-65,64,-65","w":216},"\u263a":{"d":"184,-203v60,0,112,52,112,112v0,60,-52,112,-112,112v-60,0,-112,-52,-112,-112v0,-60,52,-112,112,-112xm184,5v50,0,96,-46,96,-96v0,-50,-45,-96,-96,-96v-51,0,-96,45,-96,96v0,51,46,96,96,96xm141,-128v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14v0,-7,7,-14,14,-14xm227,-128v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14v0,-7,7,-14,14,-14xm132,-55r11,-6v16,33,66,34,81,0r12,6v-22,46,-82,45,-104,0","w":367},"\u263b":{"d":"189,-203v60,0,112,51,112,112v0,61,-52,112,-112,112v-60,0,-112,-52,-112,-112v0,-60,52,-112,112,-112xm146,-100v8,0,15,-6,15,-14v0,-8,-7,-14,-15,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14xm232,-100v8,0,15,-7,15,-14v0,-7,-7,-14,-15,-14v-7,-1,-14,7,-14,14v0,7,7,15,14,14xm138,-55v21,46,81,45,103,0r-11,-6v-16,33,-66,34,-81,0","w":378},"\u263c":{"d":"159,-285r13,0r0,59v22,1,42,9,61,25r51,-50r9,9r-50,51v16,21,25,42,25,63r59,0r0,12r-59,0v-2,22,-10,42,-25,61r50,51r-10,9r-50,-49v-20,15,-40,22,-61,24r0,59r-13,0r0,-59v-24,-3,-44,-11,-61,-24r-52,49r-9,-9r50,-51v-15,-18,-23,-39,-25,-62r-59,0r0,-12r59,0v2,-23,10,-43,25,-61r-50,-51r9,-10r51,50v21,-15,42,-24,62,-25r0,-59xm165,-33v48,0,90,-42,90,-90v0,-48,-42,-90,-90,-90v-48,0,-90,42,-90,90v0,48,42,90,90,90","w":330},"\u2640":{"d":"183,-168v0,45,-36,81,-79,83r0,65r73,0r0,9r-73,0r0,70r-10,0r0,-70r-73,0r0,-9r73,0r0,-65v-42,-2,-78,-37,-78,-83v0,-45,38,-84,83,-84v45,0,84,39,84,84xm99,-93v40,0,75,-35,75,-75v0,-40,-35,-75,-75,-75v-40,0,-75,35,-75,75v0,40,35,75,75,75","w":198},"\u2642":{"d":"96,-191v49,-16,53,-20,99,-50r5,2v4,42,13,78,28,108r-4,3v-17,-22,-30,-46,-39,-73r-52,111v24,9,51,42,51,76v0,44,-38,74,-81,74v-46,0,-85,-37,-85,-81v0,-52,53,-94,107,-72r51,-112v-25,11,-52,16,-80,18r0,-4xm162,-21v0,-38,-33,-70,-69,-70v-36,-1,-68,32,-68,67v-1,38,32,70,69,70v37,0,68,-31,68,-67","w":240},"\u2660":{"d":"95,-82v-15,46,-81,43,-84,-5v0,-18,11,-36,33,-54v31,-25,48,-50,52,-75v5,54,79,73,85,128v2,21,-18,41,-38,40v-18,0,-33,-12,-45,-34v-1,51,22,72,67,75r1,7r-140,0r2,-7v44,0,69,-29,67,-75","w":191},"\u2663":{"d":"179,-48v-28,-2,-44,-17,-58,-42v2,55,22,76,71,84r2,6r-149,0r1,-6v50,-7,70,-31,71,-84v-10,24,-30,41,-58,42v-25,1,-48,-22,-48,-49v0,-37,36,-64,71,-40v-27,-33,-4,-79,36,-79v41,-1,66,48,37,79v36,-23,71,2,72,39v1,27,-21,51,-48,50","w":238},"\u2665":{"d":"107,-172v4,-56,97,-57,95,0v-1,36,-14,47,-37,78v-32,43,-53,75,-58,98v-12,-52,-61,-94,-90,-146v-18,-34,3,-74,39,-74v24,0,41,15,51,44","w":212},"\u2666":{"d":"91,-216v23,38,50,74,81,110v-16,15,-70,86,-81,110v-12,-22,-38,-59,-80,-110v38,-45,64,-81,80,-110","w":182},"\u266a":{"d":"5,25v0,-65,101,-89,163,-54r-5,-241r10,0v25,14,96,77,100,105v0,4,-6,12,-10,12v-23,-15,-61,-60,-88,-74r4,242v0,80,-174,94,-174,10","w":277},"\u266b":{"d":"53,33v0,-43,53,-65,93,-42r0,-201r164,-51r0,228v2,48,-21,67,-63,69v-31,1,-49,-18,-50,-46v0,-43,52,-65,93,-42r0,-149r-123,38r0,172v1,45,-22,69,-65,70v-28,0,-49,-18,-49,-46","w":360},"\uf005":{"d":"85,39v-3,27,-38,33,-66,24r4,-13v21,12,61,-9,29,-16v-3,0,-8,0,-13,2r2,-14v18,-5,46,-2,44,17","w":116},"\u00a4":{"d":"156,-38v-27,25,-86,27,-112,0r-21,20r-16,-16r21,-20v-25,-28,-25,-81,0,-109r-21,-20r16,-16r21,21v27,-24,84,-27,111,-1r21,-20r15,16r-20,20v27,25,26,83,1,109r20,20r-15,16xm100,-174v-35,0,-66,31,-66,66v0,35,31,66,66,66v35,0,66,-31,66,-66v0,-35,-31,-66,-66,-66","w":199}}});
