/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdictions. Portions copyright Microsoft
 * Corporation.  All rights reserved.
 * 
 * Trademark:
 * ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdicions.
 * 
 * Description:
 * Designed in 1902 by Morris Fuller Benton for the American Type Founders
 * company, Franklin Gothic still reigns as one of the most-widely used sans serif
 * typefaces. Originally issued in only one weight, the ATF version of Franklin
 * Gothic was eventually expanded to include five additional weights, but no light
 * or intermediate weights were ever developed. In 1979, under license from ATF,
 * ITC developed four new weights in roman and italic: book, medium, demi and
 * heavy. Designed by Victor Caruso, ITCs new weights matched the original faces
 * characteristics, but featured a slightly enlarged lowercase x-height. ITC
 * Franklin Gothic also features a slightly condensed lowercase a-z alphabet. In
 * 1991, ITC commissioned the Font Bureau in Boston to create condensed, compressed
 * and extra compressed versions of ITC Franklin Gothic, which increased the
 * flexibility and usefulness of the design.
 * 
 * Manufacturer:
 * International Typeface Corporation
 * 
 * Designer:
 * Victor Caruso -- Font Bureau
 * 
 * Vendor URL:
 * http://www.itcfonts.com
 * 
 * License information:
 * http://www.itcfonts.com/itc/licensing.html
 */
Cufon.registerFont({"w":165,"face":{"font-family":"Franklin Gothic Medium Cond","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 6 6 3 4 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-92 -356 360 110","underline-thickness":"17.9297","underline-position":"-18.1055","unicode-range":"U+0020-U+FB02"},"glyphs":{" ":{"w":67},"!":{"d":"37,-240r49,0r-13,175r-24,0xm41,-44r40,0r0,44r-40,0r0,-44","w":122},"\"":{"d":"46,-240r37,0r-6,98r-25,0xm101,-240r37,0r-6,98r-25,0","w":184},"#":{"d":"66,-240r26,0r-12,70r40,0r11,-70r26,0r-11,70r35,0r-5,24r-34,0r-8,47r35,0r-4,24r-35,0r-13,75r-26,0r13,-75r-40,0r-13,75r-26,0r13,-75r-35,0r4,-24r35,0r8,-47r-35,0r4,-24r35,0xm76,-146r-8,47r40,0r8,-47r-40,0","w":183},"$":{"d":"83,-108v-79,-12,-73,-120,-1,-128r0,-23r22,0r0,23v30,3,50,20,59,49r-29,12v-8,-19,-12,-26,-31,-32r0,66v40,11,65,26,65,67v0,37,-26,65,-64,67r0,31r-22,0r0,-31v-35,-4,-57,-23,-66,-58r32,-10v5,22,16,34,35,38r0,-71xm83,-207v-32,6,-32,53,0,60r0,-60xm103,-36v40,-3,40,-61,0,-66r0,66","w":183},"%":{"d":"63,-242v31,0,47,27,47,62v0,35,-16,62,-47,62v-31,0,-48,-26,-48,-62v0,-36,16,-62,48,-62xm82,-180v0,-27,-6,-40,-19,-40v-13,0,-20,13,-20,40v0,27,6,40,19,40v13,0,20,-13,20,-40xm170,-240r23,0r-117,240r-23,0xm183,-122v31,0,47,27,47,62v0,35,-16,62,-47,62v-31,0,-47,-26,-47,-62v0,-35,16,-62,47,-62xm202,-60v0,-27,-6,-40,-19,-40v-13,0,-20,14,-20,41v0,26,7,39,20,39v13,0,19,-13,19,-40","w":245},"&":{"d":"109,-244v32,-1,55,21,54,52v0,25,-15,46,-44,62r41,59v9,-15,16,-35,21,-63r30,6v-6,32,-16,60,-32,82v13,14,17,18,36,15r0,31v-27,7,-43,1,-60,-20v-45,47,-134,23,-134,-46v0,-31,17,-55,52,-71v-36,-46,-23,-105,36,-107xm110,-217v-32,4,-25,40,-6,65v19,-11,27,-24,27,-41v0,-13,-9,-26,-21,-24xm89,-115v-42,18,-40,88,9,90v15,0,29,-7,40,-19","w":226},"'":{"d":"43,-240r37,0r-6,98r-25,0","w":122},"(":{"d":"65,-240r29,0v-54,87,-55,213,0,300r-29,0v-65,-90,-65,-211,0,-300","w":91},")":{"d":"27,60r-29,0v54,-87,55,-213,0,-300r29,0v65,88,65,212,0,300","w":91},"*":{"d":"79,-240r26,0r-4,48r40,-27r12,24r-41,19r41,18r-12,24r-40,-26r4,48r-26,0r4,-48r-40,26r-12,-24r41,-18r-41,-19r12,-24r40,27","w":183},"+":{"d":"107,-135r58,0r0,30r-58,0r0,59r-30,0r0,-59r-59,0r0,-30r59,0r0,-59r30,0r0,59","w":183},",":{"d":"25,-45r40,0r0,43r-27,53r-17,0r22,-51r-18,0r0,-45","w":85,"k":{"1":17}},"-":{"d":"14,-105r76,0r0,30r-76,0r0,-30","w":104,"k":{"\u0443":-1,"\u0442":4,"\u0423":12,"\u0422":7,"\u0410":-4,"Y":9,"V":2,"T":7,"A":-4}},".":{"d":"23,-45r40,0r0,45r-40,0r0,-45","w":85,"k":{"1":17}},"\/":{"d":"127,-240r28,0r-133,300r-27,0","w":171},"0":{"d":"14,-117v0,-76,16,-127,78,-127v52,0,78,40,78,121v-1,76,-15,127,-78,127v-52,0,-78,-40,-78,-121xm92,-25v37,-6,37,-42,37,-95v0,-53,-1,-88,-37,-95v-36,7,-37,41,-37,95v0,56,2,87,37,95","w":183,"k":{"7":11,"4":-2,"1":13}},"1":{"d":"93,-243r29,0r0,213r39,0r0,30r-119,0r0,-30r41,0r0,-164v-11,13,-24,24,-42,34r0,-37v21,-11,38,-27,52,-46","w":183,"k":{"9":8,"8":6,"7":26,"6":15,"5":8,"4":14,"3":5,"2":2,"1":17,"0":12,".":7,",":9}},"2":{"d":"120,-171v4,-22,-13,-41,-34,-40v-22,0,-35,16,-39,48r-35,-8v7,-43,30,-73,77,-73v42,0,75,28,72,70v-5,69,-54,97,-107,139r108,0r-1,35r-149,0r0,-34v64,-61,97,-70,108,-137","w":183,"k":{"7":12,"4":10,"1":17}},"3":{"d":"118,-176v0,-21,-12,-39,-33,-38v-19,0,-32,12,-38,36r-33,-8v11,-39,36,-58,74,-58v73,0,97,96,32,118v79,20,45,137,-33,130v-45,-4,-73,-21,-80,-64r34,-8v5,55,84,54,82,-2v-1,-33,-25,-42,-64,-40r0,-29v36,2,59,-4,59,-37","w":183,"k":{"7":13,"1":18}},"4":{"d":"97,-244r46,0r0,156r30,0r0,31r-30,0r0,57r-39,0r0,-57r-93,0r0,-29xm106,-86r0,-123r-64,123r64,0","w":183,"k":{"7":18,"4":-4,"1":24}},"5":{"d":"130,-79v0,-51,-61,-67,-76,-23r-30,-6r8,-132r125,0r-4,35r-91,0r-4,66v40,-49,120,-10,111,58v13,96,-141,117,-154,24r35,-9v6,25,19,38,41,38v26,0,39,-17,39,-51","w":183,"k":{"7":13,"4":-2,"1":20}},"6":{"d":"19,-114v0,-90,53,-161,126,-116v13,8,21,24,26,44r-33,10v-6,-44,-54,-51,-70,-14v-7,16,-11,39,-12,71v26,-68,117,-30,117,43v0,45,-30,81,-74,80v-58,-2,-80,-49,-80,-118xm60,-75v0,26,14,49,39,49v24,0,35,-17,35,-50v0,-29,-10,-47,-35,-48v-26,0,-39,22,-39,49","w":183,"k":{"4":-4,"1":12}},"7":{"d":"167,-212v-38,48,-66,129,-66,212r-42,0v0,-73,24,-141,72,-205r-106,0r3,-35r139,0r0,28","w":183,"k":{":":17,"7":6,"6":14,"4":26,"1":18,".":28}},"8":{"d":"94,-244v72,0,98,89,33,114v76,29,48,134,-37,134v-83,0,-107,-100,-33,-126v-64,-30,-38,-122,37,-122xm94,-217v-19,0,-36,13,-35,33v0,18,12,32,38,42v22,-11,33,-25,33,-41v0,-19,-16,-35,-36,-34xm92,-24v34,0,56,-36,32,-61v-7,-7,-20,-14,-39,-22v-52,14,-48,83,7,83","w":183,"k":{"7":9,"4":-4,"1":15}},"9":{"d":"12,-164v0,-46,29,-81,74,-80v52,0,78,37,78,113v0,110,-48,158,-123,124v-11,-8,-19,-22,-25,-41r34,-10v7,39,53,43,66,8v6,-16,10,-38,11,-67v-30,63,-115,23,-115,-47xm86,-118v25,0,37,-23,37,-48v0,-25,-13,-48,-36,-48v-24,0,-38,20,-37,49v0,26,12,46,36,47","w":183,"k":{"7":14,"4":1,"1":16}},":":{"d":"23,-178r40,0r0,46r-40,0r0,-46xm23,-45r40,0r0,45r-40,0r0,-45","w":85},";":{"d":"25,-178r40,0r0,46r-40,0r0,-46xm25,-45r40,0r0,43r-27,53r-17,0r22,-51r-18,0r0,-45","w":85},"\u037e":{"d":"25,-178r40,0r0,46r-40,0r0,-46xm25,-45r40,0r0,43r-27,53r-17,0r22,-51r-18,0r0,-45","w":85},"<":{"d":"166,-215r0,41r-112,54r112,55r0,40r-156,-78r0,-34","w":183},"=":{"d":"165,-130r-147,0r0,-29r147,0r0,29xm165,-81r-147,0r0,-29r147,0r0,29","w":183},">":{"d":"18,-25r0,-40r112,-55r-112,-55r0,-40r155,78r0,35","w":183},"?":{"d":"115,-179v1,-21,-11,-34,-31,-34v-22,0,-34,17,-36,50r-34,-7v4,-50,28,-74,72,-74v41,-1,69,25,69,66v0,55,-66,58,-58,114r-34,0v-10,-67,50,-62,52,-115xm60,-43r39,0r0,43r-39,0r0,-43","w":177},"@":{"d":"97,-48v-64,0,-47,-139,12,-137v13,0,22,7,28,22r3,-19r21,0r-13,98v0,8,3,12,9,12v22,-2,31,-34,31,-63v0,-53,-26,-90,-74,-90v-53,-1,-85,50,-85,107v0,86,85,131,153,84r8,19v-84,53,-187,2,-187,-102v0,-72,43,-129,111,-129v62,0,98,44,98,108v0,44,-21,88,-58,89v-14,0,-23,-7,-26,-21v-7,14,-17,22,-31,22xm102,-75v27,0,36,-81,8,-84v-26,1,-38,76,-8,84","w":214},"A":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0","w":177,"k":{"\u2019":12,"\u201d":12,"\u00ab":4,"y":3,"v":1,"t":1,"g":-5,"b":-2,"Y":9,"W":5,"V":7,"U":3,"T":9,"Q":4,"O":4,"G":4,"C":4,".":-7,"-":-4,",":-6}},"B":{"d":"179,-66v0,44,-27,66,-82,66r-74,0r0,-240v72,0,148,-12,148,61v0,27,-11,45,-35,53v29,9,43,29,43,60xm130,-175v0,-37,-33,-35,-68,-34r0,69v37,2,68,0,68,-35xm138,-71v0,-36,-34,-42,-76,-39r0,78v40,2,76,0,76,-39","w":196,"k":{"Y":1,"W":3,"V":3,"O":3}},"C":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89","w":190,"k":{"A":-1}},"D":{"d":"187,-124v0,75,-30,124,-107,124r-57,0r0,-240r54,0v76,-2,110,45,110,116xm63,-32v61,6,82,-31,82,-88v-1,-66,-25,-92,-82,-88r0,176","w":202,"k":{"Y":5,"V":4,"T":2,"J":3,"A":5}},"E":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240"},"F":{"d":"23,-240r133,0r0,32r-93,0r0,72r75,0r0,31r-75,0r0,105r-40,0r0,-240","w":153,"k":{"u":4,"r":5,"a":4,"J":8,"A":7,".":24,"-":-1,",":25}},"G":{"d":"148,-162v-7,-33,-13,-49,-43,-49v-32,0,-48,30,-48,91v0,61,17,92,50,92v27,0,41,-21,41,-63r-43,0r0,-32r80,0r0,125r-21,0r-6,-31v-12,22,-31,33,-57,33v-60,0,-86,-56,-86,-121v0,-71,24,-127,91,-127v43,0,70,24,78,73","w":202,"k":{"Y":1,"V":2,"T":-3,"A":-7}},"H":{"d":"23,-240r40,0r0,100r70,0r0,-100r40,0r0,240r-40,0r0,-107r-70,0r0,107r-40,0r0,-240","w":196},"I":{"d":"23,-240r40,0r0,240r-40,0r0,-240","w":85},"J":{"d":"-6,-33v45,11,55,-7,55,-58r0,-149r39,0r0,149v7,75,-26,106,-94,91r0,-33","w":110,"k":{"A":2}},"K":{"d":"23,-240r40,0r0,114r72,-114r42,0r-62,88r73,152r-43,0r-54,-119r-28,40r0,79r-40,0r0,-240","w":184,"k":{"y":8,"o":2,"e":2,"a":-2,"T":-14,"O":7,"G":7,"C":7,"-":2}},"L":{"d":"23,-240r40,0r0,206r85,0r0,34r-125,0r0,-240","w":147,"k":{"\u2019":29,"\u201d":30,"y":7,"u":-3,"Y":11,"W":8,"V":11,"T":8,"O":1,"G":2,"C":2,"-":21}},"M":{"d":"22,-240r59,0r48,173r49,-173r56,0r0,240r-37,0r0,-205r-57,205r-29,0r-56,-205r0,205r-33,0r0,-240","w":257},"N":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240","w":202,"k":{"u":-1,"o":-1,"e":-1,"A":-4,".":-1}},"O":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92","w":202,"k":{"Y":2,"X":4,"W":1,"V":2,"T":-1,"A":4}},"P":{"d":"171,-167v-1,60,-39,78,-108,73r0,94r-40,0r0,-240v79,-4,151,-3,148,73xm129,-167v-2,-37,-23,-46,-66,-42r0,83v40,2,68,-1,66,-41","w":177,"k":{"o":1,"e":2,"a":2,"J":13,"A":9,".":33,"-":4,",":34}},"Q":{"d":"133,-2v-4,27,20,29,41,23r0,30v-38,12,-76,-4,-73,-47v-63,-3,-86,-50,-86,-124v-1,-72,22,-119,86,-124v112,-8,109,218,32,242xm101,-28v40,0,44,-44,44,-92v0,-46,-3,-92,-44,-92v-39,0,-44,45,-44,92v0,47,5,92,44,92","w":202},"R":{"d":"23,-240v74,-2,149,-6,149,69v0,30,-13,51,-37,63r46,108r-44,0r-37,-100r-37,0r0,100r-40,0r0,-240xm63,-131v41,4,70,-4,70,-41v0,-37,-32,-39,-70,-37r0,78","w":190,"k":{"y":-4,"u":2,"o":4,"e":4,"U":2,"T":-5,"O":3,"G":3,"C":3,"-":5}},"S":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,108,30,105,92v-2,43,-33,72,-81,72v-44,0,-72,-22,-83,-67r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38","w":184,"k":{"t":1,"T":-5,"A":-1}},"T":{"d":"-6,-240r147,0r0,34r-54,0r0,206r-40,0r0,-206r-53,0r0,-34","w":135,"k":{"\u00ab":16,"y":10,"w":10,"v":9,"u":12,"s":12,"r":12,"o":13,"j":-6,"i":-7,"g":14,"e":13,"c":13,"a":15,"Y":-23,"W":-17,"V":-18,"S":-5,"O":-1,"J":6,"A":8,";":16,":":15,".":12,"-":8,",":13}},"U":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244","w":196,"k":{"A":2,".":2,",":4}},"V":{"d":"-1,-240r41,0r46,191r46,-191r35,0r-63,241r-44,-1","k":{"\u00ab":11,"y":-6,"u":4,"r":4,"o":8,"g":9,"e":8,"a":9,"T":-18,"O":3,"G":4,"C":3,"A":8,";":5,":":5,".":14,"-":2,",":15}},"W":{"d":"1,-240r40,0r33,180r37,-180r35,0r37,180r34,-180r34,0r-51,241r-36,0r-38,-177r-37,177r-36,0","w":251,"k":{"\u00ab":8,"y":-7,"u":4,"r":4,"o":5,"g":7,"e":5,"a":7,"T":-17,"O":2,"G":2,"C":2,"A":6,":":4,".":10,",":10}},"X":{"d":"3,-240r44,0r34,77r39,-77r37,0r-56,109r63,131r-44,0r-41,-92r-46,92r-38,0r64,-124","w":159,"k":{"y":3,"o":2,"e":2,"Q":4,"O":4,"C":4,"-":2}},"Y":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101","w":147,"k":{"\u00ab":18,"v":-4,"u":7,"p":6,"o":13,"g":14,"e":13,"a":14,"T":-23,"O":3,"G":4,"C":4,"A":10,";":8,":":7,".":16,"-":10,",":17}},"Z":{"d":"7,-240r144,0r0,28r-107,179r109,0r0,33r-153,0r0,-31r105,-176r-98,0r0,-33","w":153},"[":{"d":"26,-240r62,0r0,20r-28,0r0,260r28,0r0,20r-62,0r0,-300","w":91},"\\":{"d":"45,-240r132,300r-27,0r-133,-300r28,0","w":171},"]":{"d":"66,60r-62,0r0,-20r28,0r0,-260r-28,0r0,-20r62,0r0,300","w":91},"^":{"d":"47,-124r-43,0r59,-117r54,0r59,117r-43,0r-43,-85","w":180},"_":{"d":"0,19r180,0r0,36r-180,0r0,-36","w":180},"`":{"d":"117,-212r-13,13r-62,-39r19,-24","w":180},"a":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28","k":{"y":3}},"b":{"d":"58,-157v38,-56,101,-5,101,64v0,65,-22,97,-66,97v-21,0,-35,-9,-43,-28v-3,7,-5,15,-8,24r-21,0r0,-240r37,0r0,83xm90,-154v-33,0,-32,42,-32,79v0,34,10,51,31,51v29,0,30,-29,31,-67v0,-37,-2,-63,-30,-63","w":171,"k":{"y":3}},"c":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92","w":147,"k":{"k":-3,"h":-3}},"d":{"d":"13,-88v0,-72,63,-126,101,-69r0,-83r36,0r0,240r-33,0r0,-27v-9,20,-23,30,-44,30v-44,0,-60,-43,-60,-91xm83,-24v30,0,31,-41,31,-80v0,-30,-11,-50,-32,-50v-20,0,-30,21,-30,63v0,45,10,67,31,67","w":171},"e":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0","w":159,"k":{"v":-1,"t":-2}},"f":{"d":"27,-178v-4,-58,21,-74,73,-67r0,29v-29,-4,-41,3,-37,38r31,0r0,30r-31,0r0,148r-36,0r0,-148r-23,0r0,-30r23,0","w":91,"k":{"t":-13,"s":-6,"o":-2,"l":-6,"j":-6,"i":-7,"f":-12,"e":-1,"a":-2}},"g":{"d":"115,-174v3,-26,17,-37,45,-32r0,27v-16,-4,-26,3,-28,19v36,45,-7,113,-71,92v-15,3,-18,21,-6,27v37,9,112,-6,107,52v-3,41,-36,51,-81,55v-62,6,-97,-57,-45,-79v-30,-15,-24,-52,6,-65v-44,-30,-17,-104,40,-104v12,0,23,3,33,8xm108,-123v0,-23,-9,-35,-25,-35v-17,0,-26,12,-26,35v0,23,9,35,26,35v17,0,25,-12,25,-35xm128,15v0,-29,-46,-18,-70,-22v-30,18,-12,47,27,47v28,0,43,-9,43,-25","w":159},"h":{"d":"108,-112v0,-30,-2,-40,-22,-40v-45,0,-23,103,-28,152r-37,0r0,-240r37,0r0,86v8,-19,23,-28,43,-28v71,1,36,114,44,182r-37,0r0,-112","k":{"y":2}},"i":{"d":"59,-201r-38,0r0,-39r38,0r0,39xm22,-178r36,0r0,178r-36,0r0,-178","w":79},"j":{"d":"60,-201r-39,0r0,-39r39,0r0,39xm-9,31v29,7,31,-5,31,-38r0,-171r37,0r0,172v5,54,-19,78,-68,67r0,-30","w":79},"k":{"d":"21,-240r37,0r0,142r57,-80r37,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-37,0r0,-240","w":153,"k":{"u":-2,"o":2,"g":-6,"e":2,"a":-1,".":-6,"-":2,",":-5}},"l":{"d":"22,-240r36,0r0,240r-36,0r0,-240","w":79},"m":{"d":"86,-152v-25,0,-28,21,-28,49r0,103r-37,0r0,-178r34,0r0,28v12,-42,77,-44,85,1v8,-22,23,-33,45,-33v74,-1,38,114,46,182r-37,0r0,-109v-1,-28,1,-43,-21,-43v-46,0,-23,103,-28,152r-37,0r0,-108v-1,-29,1,-44,-22,-44","w":251,"k":{"y":2}},"n":{"d":"87,-152v-26,0,-28,20,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182r-36,0r0,-112v-1,-25,1,-40,-22,-40","k":{"y":2}},"o":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66","k":{"y":3,"v":1}},"p":{"d":"159,-90v0,47,-17,93,-62,93v-17,0,-30,-7,-39,-21r0,78r-37,0r0,-238r34,0r0,30v9,-21,24,-33,44,-33v42,1,60,41,60,91xm120,-90v0,-82,-62,-80,-62,-14v0,39,-3,78,31,80v21,0,31,-22,31,-66","w":171,"k":{"y":2}},"q":{"d":"13,-86v-12,-78,70,-130,106,-65v4,-7,7,-17,11,-28r20,0r0,239r-37,0r0,-83v-37,58,-110,8,-100,-63xm82,-24v42,0,46,-130,0,-130v-27,0,-30,28,-30,64v0,43,10,66,30,66","w":171},"r":{"d":"22,-178r32,0r0,40v12,-32,23,-45,51,-43r0,38v-64,-9,-44,85,-47,143r-36,0r0,-178","w":98,"k":{"z":-10,"y":-16,"x":-15,"w":-16,"v":-17,"t":-15,"s":-9,"q":-5,"p":-5,"o":-5,"k":-5,"h":-5,"g":-5,"f":-14,"d":-6,"c":-5,"a":-5,";":-5,":":-5,".":9,"-":5,",":10}},"s":{"d":"36,-86v-46,-25,-18,-96,35,-96v30,0,48,16,57,46r-28,8v-4,-32,-53,-37,-53,-5v0,42,92,23,88,81v-2,33,-29,56,-65,56v-38,0,-59,-17,-64,-51r31,-6v1,37,59,42,62,7v2,-27,-48,-28,-63,-40","w":141,"k":{"t":-3}},"t":{"d":"101,1v-53,11,-76,-8,-76,-68r0,-81r-23,0r0,-30r24,0r2,-46r33,-3r0,49r34,0r0,30r-34,0r0,78v-4,37,7,46,40,42r0,29","w":98,"k":{"o":-2,"e":-2,"a":-7,";":-3,":":-4}},"u":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31"},"v":{"d":"-2,-178r36,0r33,128r33,-128r32,0r-51,178r-32,0","w":128,"k":{"s":-2,"g":1,"a":1,";":-2,":":-4,".":9,"-":-4,",":9}},"w":{"d":"0,-178r36,0r26,122r26,-122r32,0r25,123r28,-123r30,0r-44,178r-31,0r-27,-123r-26,123r-31,0","w":202,"k":{"s":-2,"g":2,"a":1,";":-1,":":-2,".":7,"-":-4,",":8}},"x":{"d":"-1,-178r41,0r26,52r27,-52r34,0r-45,81r53,97r-41,0r-32,-63r-34,63r-34,0r51,-92","w":128,"k":{"o":1,"e":1,"c":1,"a":-1}},"y":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38","w":128,"k":{"s":-2,"o":1,"g":2,"e":2,"c":1,"a":1,";":-2,":":-3,".":10,"-":-2,",":12}},"z":{"d":"12,-178r108,0r0,23r-75,127r75,0r0,28r-115,0r0,-28r72,-122r-65,0r0,-28","w":122},"{":{"d":"32,-145v0,-54,-5,-105,56,-95r0,21v-53,-5,8,117,-44,127v33,5,20,56,22,96v2,27,0,34,22,35r0,21v-61,9,-56,-42,-56,-99v0,-28,5,-39,-19,-40r0,-26v23,-1,19,-11,19,-40","w":91},"|":{"d":"70,-240r40,0r0,300r-40,0r0,-300","w":180},"}":{"d":"60,-39v1,55,7,109,-56,99r0,-21v53,4,-9,-120,44,-131v-32,-5,-20,-53,-22,-92v-1,-27,0,-34,-22,-35r0,-21v59,-8,56,39,56,95v0,27,-3,38,19,40r0,26v-22,2,-18,13,-19,40","w":91},"~":{"d":"152,-89v-7,2,-57,-21,-70,-21v-11,0,-21,8,-29,24r-20,-13v14,-29,22,-43,52,-46v13,-2,60,21,72,21v12,0,21,-8,29,-22r21,13v-13,30,-31,44,-55,44","w":239},"\u00c4":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm64,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm120,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":177},"\u00c5":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm88,-256v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm88,-305v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16","w":177},"\u00c7":{"d":"15,-119v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89v29,0,36,-24,41,-53r36,5v-7,52,-32,79,-76,80r-4,14v22,-1,36,8,36,26v-1,33,-48,40,-72,19r5,-13v14,6,38,12,41,-4v-3,-15,-11,-13,-33,-14r10,-29v-53,-8,-72,-61,-72,-122","w":190},"\u00c9":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm63,-275r56,-50r19,24r-62,39"},"\u00d1":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240xm51,-275v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":202},"\u00d6":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm73,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm129,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":202},"\u00dc":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm72,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm128,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":196},"\u00e1":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm63,-212r56,-50r19,24r-62,39"},"\u00e0":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm110,-212r-13,13r-62,-39r19,-24"},"\u00e2":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm18,-202r63,-49r63,49r-31,2r-32,-21r-31,21"},"\u00e4":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm58,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm114,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18"},"\u00e3":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm32,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2"},"\u00e5":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm85,-196v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm85,-245v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16"},"\u00e7":{"d":"13,-88v0,-55,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-6,42,-20,63,-62,65r-5,13v22,-2,36,7,36,25v-2,32,-46,38,-71,19r5,-14v14,7,39,13,41,-4v2,-12,-17,-14,-32,-13r9,-27v-36,-7,-53,-37,-53,-91","w":147},"\u00e9":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm56,-212r56,-50r19,24r-62,39","w":159},"\u00e8":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm112,-212r-13,13r-62,-39r19,-24","w":159},"\u00ea":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm21,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":159},"\u00eb":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm56,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm112,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":159},"\u00ed":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm12,-212r56,-50r19,24r-62,39","w":79},"\u00ec":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm68,-212r-13,13r-62,-39r19,-24","w":79},"\u00ee":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm-23,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":79},"\u00ef":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm12,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm68,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":79},"\u00f1":{"d":"87,-152v-26,0,-28,20,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182r-36,0r0,-112v-1,-25,1,-40,-22,-40xm28,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2"},"\u00f3":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm55,-212r56,-50r19,24r-62,39"},"\u00f2":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm111,-212r-13,13r-62,-39r19,-24"},"\u00f4":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm20,-202r63,-49r63,49r-31,2r-32,-21r-31,21"},"\u00f6":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm55,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm111,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18"},"\u00f5":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm32,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2"},"\u00fa":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm54,-212r56,-50r19,24r-62,39"},"\u00f9":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm110,-212r-13,13r-62,-39r19,-24"},"\u00fb":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm20,-202r63,-49r63,49r-31,2r-32,-21r-31,21"},"\u00fc":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm55,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm111,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18"},"\u2020":{"d":"75,-240r34,0r0,68r53,0r0,31r-53,0r0,201r-34,0r0,-201r-53,0r0,-31r53,0r0,-68","w":183},"\u00b0":{"d":"92,-244v30,0,56,26,56,56v0,30,-27,56,-56,56v-29,0,-56,-26,-56,-56v0,-30,26,-56,56,-56xm92,-156v16,0,28,-15,28,-32v0,-17,-12,-32,-28,-32v-16,0,-28,15,-28,32v0,17,12,32,28,32","w":183},"\u00a2":{"d":"85,-37v-75,-6,-74,-165,0,-170r0,-33r21,0r0,33v29,4,45,24,50,59r-31,4v-2,-19,-8,-31,-20,-36r0,114v11,-4,18,-16,20,-35r31,4v-4,35,-21,55,-50,60r0,39r-21,0r0,-39xm86,-179v-28,8,-28,105,0,113r0,-113","w":183},"\u00a3":{"d":"57,-140v-14,-57,5,-104,60,-104v28,0,48,12,58,38r-29,17v-10,-36,-58,-34,-55,11r5,38r46,0r0,28r-43,0v6,36,-4,64,-28,81v45,1,78,1,89,-32r28,14v-13,67,-105,45,-181,49r0,-32v51,6,65,-33,55,-80r-35,0r0,-28r30,0","w":183},"\u00a7":{"d":"56,-144v-41,-30,-18,-100,40,-100v35,0,56,15,64,46r-30,7v-4,-37,-63,-37,-61,-1v3,49,91,30,91,93v0,19,-8,34,-25,48v53,32,22,113,-43,113v-39,0,-63,-18,-71,-54r32,-6v1,42,78,43,75,2v-4,-53,-101,-34,-101,-97v0,-21,10,-38,29,-51xm77,-132v-30,24,-18,56,21,64v20,15,30,-9,31,-23v-5,-27,-16,-23,-52,-41","w":183},"\u2022":{"d":"120,-173v27,0,49,24,49,51v0,27,-23,50,-49,50v-26,0,-50,-24,-50,-50v0,-27,23,-51,50,-51","w":239},"\u00b6":{"d":"6,-171v1,-46,21,-69,75,-69r78,0r0,300r-24,0r0,-276r-18,0r0,276r-24,0r0,-161v-59,5,-89,-16,-87,-70","w":183},"\u00df":{"d":"93,-225v-31,2,-33,26,-33,63r0,179r-36,0r0,-149r-21,0r0,-29r21,0v-4,-59,23,-88,74,-91v32,-2,59,20,59,51v0,27,-20,46,-58,55v23,23,86,35,79,84v3,53,-49,79,-100,60r10,-27v26,13,57,4,56,-27v-1,-51,-94,-43,-66,-106v29,-6,44,-17,44,-35v0,-18,-11,-29,-29,-28","w":184},"\u00ae":{"d":"141,4v-68,0,-126,-57,-126,-124v0,-67,60,-124,126,-124v66,0,125,57,125,124v0,67,-58,124,-125,124xm141,-220v-54,0,-100,46,-100,100v0,54,46,100,100,100v54,0,99,-47,99,-100v0,-53,-45,-100,-99,-100xm92,-192v47,-1,100,-4,100,42v0,17,-8,30,-23,38r30,64r-33,0r-24,-59r-20,0r0,59r-30,0r0,-144xm122,-170r0,42v22,1,40,0,40,-22v0,-20,-19,-21,-40,-20","w":281},"\u00a9":{"d":"141,4v-68,0,-126,-57,-126,-124v0,-67,60,-124,126,-124v66,0,125,57,125,124v0,67,-58,124,-125,124xm141,-220v-54,0,-100,46,-100,100v0,54,46,100,100,100v54,0,99,-47,99,-100v0,-53,-45,-100,-99,-100xm144,-69v19,0,19,-13,24,-30r28,3v-5,34,-23,50,-53,50v-40,-1,-58,-30,-58,-73v0,-45,18,-75,59,-76v31,0,48,18,52,52r-28,4v-2,-21,-11,-33,-24,-33v-18,0,-27,18,-27,54v0,33,9,49,27,49","w":281},"\u2122":{"d":"5,-233r88,0r0,22r-30,0r0,115r-27,0r0,-115r-31,0r0,-22xm104,-233r39,0r26,99r26,-99r38,0r0,137r-25,0r0,-115r-31,115r-21,0r-30,-115r0,115r-22,0r0,-137","w":257},"\u00b4":{"d":"73,-212r56,-50r19,24r-62,39","w":180},"\u00a8":{"d":"62,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm118,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":180},"\u2260":{"d":"126,-159r39,0r0,29r-52,0r-10,20r62,0r0,29r-75,0r-20,41r-26,-12r13,-29r-39,0r0,-29r53,0r10,-20r-63,0r0,-29r76,0r19,-42r27,13","w":183},"\u00c6":{"d":"95,-240r153,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r97,0r0,33r-136,0r0,-66r-62,0r-28,66r-37,0xm113,-97r0,-117r-51,117r51,0","w":251},"\u00d8":{"d":"16,-120v0,-91,53,-150,130,-112r10,-21r26,0r-19,37v16,20,23,53,23,96v0,72,-21,122,-84,124v-25,0,-18,-2,-44,-11r-11,22r-25,0r19,-38v-17,-20,-25,-52,-25,-97xm102,-213v-61,-4,-51,110,-41,155r68,-146v-7,-6,-16,-9,-27,-9xm75,-34v51,26,73,-25,73,-86v0,-28,-2,-47,-6,-59","w":202},"\u221e":{"d":"27,-129v0,-52,67,-63,94,-17v23,-26,26,-41,58,-41v29,0,51,22,51,56v0,38,-21,59,-51,59v-31,0,-37,-15,-58,-40v-28,46,-94,36,-94,-17xm210,-129v0,-30,-28,-49,-51,-31v-6,5,-15,14,-26,30v10,15,25,39,46,39v18,0,31,-15,31,-38xm46,-130v0,39,43,34,63,1v-14,-19,-28,-28,-39,-28v-14,0,-24,12,-24,27","w":256},"\u00b1":{"d":"107,-135r58,0r0,30r-58,0r0,57r-30,0r0,-57r-59,0r0,-30r59,0r0,-59r30,0r0,59xm165,-2r-147,0r0,-29r147,0r0,29","w":183},"\u2264":{"d":"166,-234r0,38r-112,53r112,52r0,38r-156,-73r0,-35xm166,-42r0,36r-156,0r0,-36r156,0","w":183},"\u2265":{"d":"18,-53r0,-38r112,-53r-112,-52r0,-38r155,73r0,35xm18,-6r0,-36r155,0r0,36r-155,0","w":183},"\u00a5":{"d":"10,-240r40,0r44,108r46,-108r34,0r-44,96r40,0r0,22r-50,0r-11,24r61,0r0,22r-61,0r0,76r-36,0r0,-76r-56,0r0,-22r56,0r-11,-24r-45,0r0,-22r36,0","w":183},"\u00b5":{"d":"92,-23v46,-8,21,-103,27,-155r36,0r0,178r-31,0r0,-19v-8,28,-47,31,-59,6r0,73r-37,0r0,-238r37,0v5,53,-17,146,27,155","w":183},"\u2202":{"d":"151,-162v-1,-45,-4,-78,-36,-78v-17,0,-30,14,-40,40r-24,-11v11,-29,32,-51,63,-51v44,0,57,43,57,99v0,85,-38,165,-107,168v-34,2,-55,-26,-54,-61v2,-71,58,-107,141,-106xm41,-53v5,45,55,39,79,4v15,-21,26,-51,30,-91v-71,-1,-101,30,-109,87","w":177},"\u2211":{"d":"24,-270r218,0r0,29r-174,0r107,140r-114,148r183,0r0,28r-223,0r0,-33r109,-142r-106,-139r0,-31","w":256},"\u220f":{"d":"28,-270r240,0r0,345r-34,0r0,-314r-172,0r0,314r-34,0r0,-345","w":296},"\uf006":{"d":"23,0r0,-150r-18,0r0,-28r155,0r0,28r-18,0r0,150r-36,0r0,-150r-46,0r0,150r-37,0"},"\u222b":{"d":"0,17v1,-25,28,-14,37,-6v5,0,6,-3,6,-10v-4,-82,-14,-243,2,-300v9,-31,45,-38,53,-10v0,24,-24,20,-36,9v-5,0,-7,3,-7,11v4,88,11,121,6,225v-4,67,-2,93,-40,103v-12,0,-21,-9,-21,-22","w":98},"\u00aa":{"d":"69,-164v5,-26,-27,-29,-30,-8r-27,-3v5,-21,20,-31,45,-31v57,0,34,68,43,110r-23,0v-1,-5,-2,-11,-2,-17v-15,29,-67,24,-67,-13v0,-27,25,-42,61,-38xm69,-146v-17,-4,-33,4,-32,19v0,9,4,13,12,13v13,0,20,-10,20,-32","w":110},"\u00ba":{"d":"55,-206v32,-1,47,22,47,55v0,38,-16,57,-47,57v-32,1,-46,-22,-46,-56v0,-38,15,-56,46,-56xm72,-150v0,-24,-6,-35,-17,-35v-11,0,-17,11,-17,35v0,24,6,36,17,36v11,0,17,-12,17,-36","w":110},"\u2126":{"d":"61,-138v0,52,24,92,60,107r0,31r-101,0r0,-29r65,1v-99,-48,-73,-236,54,-236v125,0,152,184,54,236r64,-1r0,29r-101,0r0,-31v78,-25,87,-203,-17,-205v-51,-1,-78,46,-78,98","w":276},"\u00e6":{"d":"19,-131v1,-50,86,-69,112,-29v22,-28,71,-28,93,2v11,15,19,41,19,75r-100,0v-9,61,54,83,65,27r32,4v-6,64,-92,75,-117,23v-21,48,-113,44,-110,-18v3,-51,39,-63,95,-63v10,-50,-49,-62,-56,-17xm205,-108v-1,-31,-11,-47,-30,-47v-19,0,-29,16,-31,47r61,0xm73,-22v26,-2,38,-32,35,-65v-35,-2,-59,9,-58,37v0,18,8,28,23,28","w":251},"\u00f8":{"d":"35,-14v-38,-43,-32,-168,47,-168v14,0,25,3,35,8r10,-19r21,0r-16,32v14,16,21,39,21,71v2,77,-41,108,-102,88r-11,21r-21,0xm103,-151v-38,-18,-56,17,-56,62v0,19,2,34,6,46xm65,-25v56,20,59,-54,49,-105"},"\u00bf":{"d":"117,-134r-39,0r0,-44r39,1r0,43xm84,-41v-28,21,-32,76,10,77v23,0,34,-17,36,-50r34,6v-4,50,-29,75,-73,75v-53,0,-81,-47,-62,-97v9,-25,62,-37,52,-84r33,0v0,48,-2,52,-30,73","w":177},"\u00a1":{"d":"81,-133r-40,0r0,-45r40,1r0,44xm86,63r-49,0r12,-176r24,0","w":122},"\u00ac":{"d":"129,0r0,-59r-115,0r0,-37r156,0r0,96r-41,0","w":183},"\u221a":{"d":"184,-329r13,0r-55,343r-87,-180r-35,16r-6,-11r53,-27r71,145","w":197},"\u0192":{"d":"86,-166v7,-60,29,-86,86,-76r-4,29v-33,-8,-43,13,-47,47r37,0r-5,30r-36,0v-21,75,4,203,-102,188r5,-31v35,4,38,-11,44,-46r18,-111r-29,0r5,-30r28,0","w":183},"\u2248":{"d":"124,-127v-7,3,-57,-20,-70,-20v-11,0,-21,8,-29,24r-20,-14v12,-27,21,-43,52,-46v12,-1,60,21,72,21v12,0,21,-7,29,-21r21,12v-13,30,-31,44,-55,44xm124,-60v-7,2,-57,-21,-70,-21v-11,0,-21,8,-29,24r-20,-13v12,-27,21,-43,52,-46v12,-1,60,22,71,21v12,0,22,-8,30,-22r21,13v-13,30,-31,44,-55,44","w":183},"\u2206":{"d":"216,0r-211,0r110,-244xm174,-14r-70,-170r-77,170r147,0","w":220},"\u00ab":{"d":"125,-35r-20,0r-34,-57r34,-58r20,0r-19,58xm70,-36r-20,0r-34,-56r34,-57r20,0r-19,57","w":140,"k":{"\u0447":2,"\u0442":9,"\u043b":-3,"\u042f":5,"\u0427":1,"\u0423":4,"\u0422":12,"\u041b":-5,"\u0410":-2}},"\u00bb":{"d":"16,-150r20,0r34,58r-34,57r-20,0r19,-57xm71,-150r21,0r33,58r-33,57r-21,0r19,-57","w":140,"k":{"Y":16,"W":8,"V":10,"T":15,"A":3}},"\u2026":{"d":"23,-45r40,0r0,45r-40,0r0,-45xm109,-45r40,0r0,45r-40,0r0,-45xm195,-45r40,0r0,45r-40,0r0,-45","w":257},"\u00a0":{"w":67},"\u00c0":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm122,-275r-13,13r-62,-39r19,-24","w":177},"\u00c3":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm36,-275v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":177},"\u00d5":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm50,-275v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":202},"\u0152":{"d":"15,-119v0,-72,25,-122,86,-125v19,0,35,8,47,24r0,-20r136,0r0,32r-100,0r0,68r78,0r0,32r-78,0r0,75r101,0r0,33r-138,0r0,-22v-11,18,-27,27,-47,27v-58,-2,-85,-55,-85,-124xm105,-211v-44,1,-48,48,-48,96v0,58,16,87,48,87v20,0,33,-11,41,-33r0,-122v-9,-19,-22,-28,-41,-28","w":288},"\u0153":{"d":"13,-89v5,-54,17,-92,68,-93v23,0,41,9,52,27v21,-35,73,-35,97,-4v12,15,19,40,19,76r-100,0v-10,62,54,83,65,27r33,4v-8,61,-85,74,-117,30v-42,56,-125,14,-117,-67xm211,-108v1,-27,-8,-47,-30,-47v-19,0,-29,16,-31,47r61,0xm82,-23v27,-4,30,-29,30,-66v0,-37,-3,-62,-30,-65v-26,2,-30,30,-30,65v1,35,2,63,30,66","w":257},"\u2013":{"d":"30,-104r124,0r0,28r-124,0r0,-28","w":183},"\u2014":{"d":"11,-104r205,0r0,28r-205,0r0,-28","w":226},"\u201c":{"d":"112,-156r-39,0r0,-43r25,-45r17,0r-20,44r17,0r0,44xm58,-156r-38,0r0,-43r24,-45r17,0r-20,44r17,0r0,44","w":135,"k":{"Y":-9,"W":-6,"V":-6,"T":-7,"A":14}},"\u201d":{"d":"23,-240r38,0r0,43r-24,45r-17,0r20,-43r-17,0r0,-45xm77,-240r38,0r0,43r-24,45r-18,0r21,-43r-17,0r0,-45","w":135,"k":{"Y":-9,"W":-7,"V":-7,"T":-8,"A":13}},"\u2018":{"d":"57,-156r-38,0r0,-43r24,-45r18,0r-21,44r17,0r0,44","w":79},"\u2019":{"d":"22,-240r39,0r0,43r-25,45r-17,0r21,-43r-18,0r0,-45","w":79},"\u00f7":{"d":"110,-153r-36,0r0,-39r36,0r0,39xm165,-105r-147,0r0,-30r147,0r0,30xm110,-47r-36,0r0,-40r36,0r0,40","w":183},"\u25ca":{"d":"97,-250r73,125r-73,125r-20,0r-69,-125r69,-125r20,0xm87,-233r-60,108r60,108r63,-108","w":177},"\u00ff":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38xm39,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm95,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":128},"\u0178":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm48,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm104,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":147},"\u2215":{"d":"61,-240r26,0r-117,240r-26,0","w":30},"\u20ac":{"d":"63,-86v-1,74,70,78,73,15r40,5v-6,47,-31,70,-73,70v-47,0,-74,-30,-82,-90r-17,0r0,-21r16,0r0,-22r-16,0r0,-21r17,0v5,-85,75,-120,132,-77v14,11,20,29,23,51r-39,5v-3,-29,-14,-44,-33,-44v-23,0,-37,22,-41,65r47,0r0,21r-48,0r0,22r48,0r0,21r-47,0","w":183},"\u2039":{"d":"70,-35r-20,0r-34,-57r34,-58r20,0r-19,58","w":85},"\u203a":{"d":"16,-150r20,0r34,58r-34,57r-20,0r19,-57","w":85},"\ufb01":{"d":"27,-178v-3,-56,18,-73,69,-68r0,30v-27,-3,-36,5,-33,38r31,0r0,30r-31,0r0,148r-36,0r0,-148r-23,0r0,-30r23,0xm151,-201r-38,0r0,-39r38,0r0,39xm114,-178r36,0r0,178r-36,0r0,-178","w":171},"\ufb02":{"d":"27,-178v-3,-56,18,-73,69,-68r0,30v-27,-3,-36,5,-33,38r31,0r0,30r-31,0r0,148r-36,0r0,-148r-23,0r0,-30r23,0xm113,-240r37,0r0,240r-37,0r0,-240","w":171},"\u2021":{"d":"75,-240r34,0r0,68r53,0r0,31r-53,0r0,102r53,0r0,31r-53,0r0,68r-34,0r0,-68r-53,0r0,-31r53,0r0,-102r-53,0r0,-31r53,0r0,-68","w":183},"\u2219":{"d":"23,-115r40,0r0,45r-40,0r0,-45","w":85},"\u201a":{"d":"22,-45r39,0r0,44r-25,45r-17,0r21,-44r-18,0r0,-45","w":79},"\u201e":{"d":"23,-45r38,0r0,44r-24,45r-17,0r20,-44r-17,0r0,-45xm77,-45r38,0r0,44r-24,45r-18,0r21,-44r-17,0r0,-45","w":135,"k":{"Y":13,"W":9,"V":12,"T":10,"A":-9}},"\u2030":{"d":"63,-242v31,0,47,27,47,62v0,35,-16,62,-47,62v-31,0,-48,-26,-48,-62v0,-36,16,-62,48,-62xm82,-180v0,-27,-6,-40,-19,-40v-13,0,-20,13,-20,40v0,27,7,40,20,40v13,0,19,-13,19,-40xm170,-240r24,0r-118,240r-23,0xm183,-122v31,0,47,27,47,62v0,35,-16,62,-47,62v-31,0,-47,-27,-47,-62v0,-35,16,-62,47,-62xm202,-60v0,-27,-6,-40,-19,-40v-13,0,-19,14,-19,41v0,26,6,39,19,39v13,0,19,-13,19,-40xm293,-122v31,0,47,27,47,62v0,36,-16,62,-47,62v-31,0,-47,-27,-47,-62v0,-35,16,-62,47,-62xm313,-60v0,-27,-7,-40,-20,-40v-13,0,-19,14,-19,41v0,26,6,39,19,39v13,0,20,-13,20,-40","w":355},"\u00c2":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm26,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":177},"\u00ca":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm29,-263r63,-49r63,49r-31,2r-32,-21r-31,21"},"\u00c1":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm62,-273r56,-50r19,24r-62,39","w":177},"\u00cb":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm64,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm120,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18"},"\u00c8":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm116,-273r-13,13r-62,-39r19,-24"},"\u00cd":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm23,-273r56,-50r19,24r-62,39","w":85},"\u00ce":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm-20,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":85},"\u00cf":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm15,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm71,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":85},"\u00cc":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm69,-273r-13,13r-62,-39r19,-24","w":85},"\u00d3":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm80,-273r56,-50r19,24r-62,39","w":202},"\u00d4":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm39,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":202},"\u00d2":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm125,-273r-13,13r-62,-39r19,-24","w":202},"\u00da":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm77,-273r56,-50r19,24r-62,39","w":196},"\u00db":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm35,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":196},"\u00d9":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm121,-273r-13,13r-62,-39r19,-24","w":196},"\u0131":{"d":"22,-178r36,0r0,178r-36,0r0,-178","w":79},"\u02c6":{"d":"27,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":180},"\u02dc":{"d":"36,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":180},"\u02c9":{"d":"41,-234r98,0r0,23r-98,0r0,-23","w":180},"\u02d8":{"d":"36,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":180},"\u02d9":{"d":"90,-202v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":180},"\u02da":{"d":"90,-196v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm90,-245v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16","w":180},"\u00b8":{"d":"131,43v-1,32,-46,37,-70,18r5,-13v15,6,38,12,40,-5v2,-12,-17,-14,-32,-13r10,-30r18,0r-6,17v21,-1,35,8,35,26","w":180},"\u02dd":{"d":"98,-256r19,20r-48,37r-12,-12xm148,-256r19,20r-49,37r-11,-12","w":180},"\u02db":{"d":"141,58v-25,10,-64,2,-63,-26v0,-15,13,-35,40,-32v-26,18,-16,53,19,44","w":180},"\u02c7":{"d":"27,-245r32,-3r31,22r32,-22r31,3r-63,48","w":180},"\u0141":{"d":"23,-240r40,0r0,94r42,-42r0,36r-42,43r0,75r85,0r0,34r-125,0r0,-83r-20,20r0,-36r20,-21r0,-120","w":147},"\u0142":{"d":"25,-240r36,0r0,88r23,-23r0,30r-23,22r0,123r-36,0r0,-100r-23,23r0,-29r23,-23r0,-111","w":85},"\u0160":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,108,30,105,92v-2,43,-33,72,-81,72v-44,0,-72,-22,-83,-67r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38xm31,-306r32,-3r31,22r32,-22r31,3r-63,48","w":184},"\u0161":{"d":"36,-86v-46,-25,-18,-96,35,-96v30,0,48,16,57,46r-28,8v-4,-32,-53,-37,-53,-5v0,42,92,23,88,81v-2,33,-29,56,-65,56v-38,0,-59,-17,-64,-51r31,-6v1,37,59,42,62,7v2,-27,-48,-28,-63,-40xm10,-245r32,-3r31,22r32,-22r31,3r-63,48","w":141},"\u017d":{"d":"7,-240r144,0r0,28r-107,179r109,0r0,33r-153,0r0,-31r105,-176r-98,0r0,-33xm16,-306r32,-3r31,22r32,-22r31,3r-63,48","w":153},"\u017e":{"d":"12,-178r108,0r0,23r-75,127r75,0r0,28r-115,0r0,-28r72,-122r-65,0r0,-28xm4,-245r32,-3r31,22r32,-22r31,3r-63,48","w":122},"\u00a6":{"d":"70,-240r40,0r0,123r-40,0r0,-123xm70,-55r40,0r0,115r-40,0r0,-115","w":180},"\u00d0":{"d":"187,-124v0,75,-30,124,-107,124r-57,0r0,-109r-20,0r0,-30r20,0r0,-101r54,0v76,-2,110,46,110,116xm63,-32v61,6,82,-31,82,-88v-1,-66,-25,-92,-82,-88r0,69r44,0r0,30r-44,0r0,77","w":202},"\u00f0":{"d":"10,-89v-3,-61,37,-113,86,-84v-6,-14,-11,-24,-16,-33r-24,14r-10,-16r24,-15r-11,-19r24,-15r12,20r23,-14r10,16r-23,14v26,44,44,77,45,135v1,52,-21,90,-69,90v-55,1,-68,-40,-71,-93xm80,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66","w":159},"\u00dd":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm53,-273r56,-50r19,24r-62,39","w":147},"\u00fd":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38xm38,-212r56,-50r19,24r-62,39","w":128},"\u00de":{"d":"171,-130v0,60,-40,78,-108,74r0,56r-40,0r0,-240r40,0r0,37v66,-5,108,14,108,73xm129,-130v-1,-37,-23,-46,-66,-42r0,84v40,2,68,-3,66,-42","w":177},"\u00fe":{"d":"159,-90v0,47,-17,93,-62,93v-17,0,-30,-7,-39,-21r0,78r-37,0r0,-300r37,0r0,90v9,-20,23,-31,42,-31v40,0,60,42,59,91xm91,-154v-31,0,-33,43,-33,80v0,30,7,50,31,50v21,0,31,-22,31,-66v0,-42,-9,-64,-29,-64","w":171},"\u2212":{"d":"165,-105r-147,0r0,-30r147,0r0,30","w":183},"\u00d7":{"d":"92,-142r44,-43r21,21r-43,44r43,44r-21,21r-44,-43r-44,43r-22,-21r44,-44r-44,-44r22,-21","w":183},"\u00b9":{"d":"61,-241r22,0r0,123r25,0r0,22r-81,0r0,-22r27,0r0,-87v-8,7,-17,13,-27,18r0,-27v14,-7,25,-15,34,-27","w":122},"\u00b2":{"d":"8,-120v38,-32,58,-40,68,-78v0,-14,-7,-21,-19,-21v-13,0,-20,10,-22,29r-27,-5v2,-63,98,-62,99,-4v0,25,-22,51,-64,78r65,0r-1,25r-99,0r0,-24","w":122},"\u00b3":{"d":"38,-181v20,0,38,1,37,-19v-2,-28,-37,-25,-40,1r-26,-6v6,-50,97,-52,96,2v0,14,-7,25,-22,31v51,18,23,78,-25,78v-31,0,-48,-13,-53,-41r27,-6v0,30,46,33,46,2v0,-18,-18,-22,-40,-21r0,-21","w":122},"\u00bd":{"d":"58,-241r22,0r0,123r25,0r0,22r-81,0r0,-22r27,0r0,-87v-8,7,-17,13,-27,18r0,-27v14,-7,25,-15,34,-27xm179,-240r26,0r-117,240r-26,0xm155,-24v38,-32,58,-40,68,-78v0,-14,-7,-21,-19,-21v-13,0,-20,10,-22,29r-27,-5v2,-63,98,-62,99,-4v0,25,-22,51,-64,78r65,0r-1,25r-99,0r0,-24","w":275},"\u00bc":{"d":"54,-241r22,0r0,123r25,0r0,22r-81,0r0,-22r27,0r0,-87v-8,7,-17,13,-27,18r0,-27v14,-7,25,-15,34,-27xm184,-240r26,0r-117,240r-26,0xm213,-147r32,0r0,91r19,0r0,23r-19,0r0,33r-29,0r0,-33r-59,0r0,-20xm217,-54r0,-66r-36,66r36,0","w":275},"\u00be":{"d":"44,-181v20,0,38,1,37,-19v-2,-28,-37,-25,-40,1r-26,-6v6,-50,97,-52,96,2v0,14,-7,25,-22,31v51,18,23,78,-25,78v-31,0,-48,-13,-53,-41r27,-6v0,30,46,33,46,2v0,-18,-18,-22,-40,-21r0,-21xm184,-240r26,0r-117,240r-26,0xm211,-147r32,0r0,91r19,0r0,23r-19,0r0,33r-29,0r0,-33r-59,0r0,-20xm215,-54r0,-66r-36,66r36,0","w":275},"\u20a3":{"d":"63,-70r35,0r0,30r-35,0r0,40r-40,0r0,-40r-18,0r0,-30r18,0r0,-170r133,0r0,32r-93,0r0,72r75,0r0,31r-75,0r0,35","w":153},"\u011e":{"d":"148,-162v-7,-33,-13,-49,-43,-49v-32,0,-48,30,-48,91v0,61,17,92,50,92v27,0,41,-21,41,-63r-43,0r0,-32r80,0r0,125r-21,0r-6,-31v-12,22,-31,33,-57,33v-60,0,-86,-56,-86,-121v0,-71,24,-127,91,-127v43,0,70,24,78,73xm56,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":202},"\u011f":{"d":"115,-174v3,-26,17,-37,45,-32r0,27v-16,-4,-26,3,-28,19v36,45,-7,113,-71,92v-15,3,-18,21,-6,27v37,9,112,-6,107,52v-3,41,-36,51,-81,55v-62,6,-97,-57,-45,-79v-30,-15,-24,-52,6,-65v-44,-30,-17,-104,40,-104v12,0,23,3,33,8xm108,-123v0,-23,-9,-35,-25,-35v-17,0,-26,12,-26,35v0,23,9,35,26,35v17,0,25,-12,25,-35xm128,15v0,-29,-46,-18,-70,-22v-30,18,-12,47,27,47v28,0,43,-9,43,-25xm30,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":159},"\u0130":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm43,-262v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":85},"\u015e":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,105,30,105,92v0,42,-33,74,-78,72r-5,14v21,-1,37,7,37,26v0,33,-48,40,-73,19r5,-13v14,6,38,12,41,-4v-3,-16,-11,-13,-32,-14r9,-29v-37,-6,-60,-28,-68,-66r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38","w":184},"\u015f":{"d":"100,-128v-4,-32,-53,-37,-53,-5v0,42,93,23,88,81v-3,32,-28,56,-63,56r-4,13v22,-2,36,8,36,26v0,31,-46,37,-71,18r5,-13v15,6,38,11,41,-5v1,-12,-17,-14,-33,-13r10,-26v-29,-6,-46,-23,-50,-51r31,-6v1,37,59,42,62,7v-8,-42,-87,-22,-87,-81v0,-31,27,-55,59,-55v30,0,48,16,57,46","w":141},"\u0106":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89xm80,-273r56,-50r19,24r-62,39","w":190},"\u0107":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92xm61,-212r56,-50r19,24r-62,39","w":147},"\u010c":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89xm42,-306r32,-3r31,22r32,-22r31,3r-63,48","w":190},"\u010d":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92xm21,-245r32,-3r31,22r32,-22r31,3r-63,48","w":147},"\u0111":{"d":"13,-88v0,-73,66,-127,102,-66r0,-45r-39,0r0,-20r39,0r0,-21r35,0r0,21r20,0r0,20r-20,0r0,199r-33,0r0,-27v-9,20,-23,30,-44,30v-43,-2,-60,-39,-60,-91xm83,-24v30,0,31,-41,31,-80v0,-30,-11,-50,-32,-50v-20,0,-30,21,-30,63v0,45,10,67,31,67","w":171},"\u00ad":{"d":"14,-105r76,0r0,30r-76,0r0,-30","w":104},"\u00af":{"d":"0,-318r180,0r0,36r-180,0r0,-36","w":180},"\u00b7":{"d":"23,-115r40,0r0,45r-40,0r0,-45","w":85},"\u0100":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm41,-294r98,0r0,23r-98,0r0,-23","w":177},"\u0101":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm36,-234r98,0r0,23r-98,0r0,-23"},"\u0102":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm37,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":177},"\u0103":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm31,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43"},"\u0104":{"d":"200,59v-26,12,-65,2,-65,-26v0,-13,8,-24,25,-33r-23,0r-16,-60r-70,0r-14,60r-38,0r69,-240r44,0r65,240v-27,19,-18,54,20,45xm114,-91r-28,-110r-27,110r55,0","w":177},"\u0105":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182v-26,18,-16,53,19,44r4,14v-25,10,-64,2,-63,-26v0,-13,8,-23,24,-32r-18,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28"},"\u0108":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89xm42,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":190},"\u0109":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92xm20,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":147},"\u010a":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89xm105,-262v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":190},"\u010b":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92xm84,-202v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":147},"\u010e":{"d":"187,-124v0,75,-30,124,-107,124r-57,0r0,-240r54,0v76,-2,110,45,110,116xm63,-32v61,6,82,-31,82,-88v-1,-66,-25,-92,-82,-88r0,176xm29,-306r32,-3r31,22r32,-22r31,3r-63,48","w":202},"\u010f":{"d":"13,-88v0,-72,63,-126,101,-69r0,-83r36,0r0,240r-33,0r0,-27v-9,20,-23,30,-44,30v-44,0,-60,-43,-60,-91xm83,-24v30,0,31,-41,31,-80v0,-30,-11,-50,-32,-50v-20,0,-30,21,-30,63v0,45,10,67,31,67xm172,-240r34,0r-26,67r-17,0","w":200},"\u0110":{"d":"187,-124v0,75,-30,124,-107,124r-57,0r0,-109r-20,0r0,-30r20,0r0,-101r54,0v76,-2,110,46,110,116xm63,-32v61,6,82,-31,82,-88v-1,-66,-25,-92,-82,-88r0,69r44,0r0,30r-44,0r0,77","w":202},"\u0112":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm43,-294r98,0r0,23r-98,0r0,-23"},"\u0113":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm41,-234r98,0r0,23r-98,0r0,-23","w":159},"\u0114":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm39,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43"},"\u0115":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm32,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":159},"\u0116":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm93,-262v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20"},"\u0117":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm86,-202v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":159},"\u0118":{"d":"185,59v-26,12,-65,3,-64,-26v0,-13,7,-24,24,-33r-122,0r0,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33v-28,19,-16,53,20,45"},"\u0119":{"d":"149,-52v-3,38,-39,45,-44,76v-1,16,18,20,35,17r3,14v-25,10,-65,2,-63,-25v0,-10,7,-19,18,-27v-56,10,-85,-31,-85,-89v0,-91,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0","w":159},"\u011a":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm29,-306r32,-3r31,22r32,-22r31,3r-63,48"},"\u011b":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm23,-245r32,-3r31,22r32,-22r31,3r-63,48","w":159},"\u011c":{"d":"148,-162v-7,-33,-13,-49,-43,-49v-32,0,-48,30,-48,91v0,61,17,92,50,92v27,0,41,-21,41,-63r-43,0r0,-32r80,0r0,125r-21,0r-6,-31v-12,22,-31,33,-57,33v-60,0,-86,-56,-86,-121v0,-71,24,-127,91,-127v43,0,70,24,78,73xm45,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":202},"\u011d":{"d":"115,-174v3,-26,17,-37,45,-32r0,27v-16,-4,-26,3,-28,19v36,45,-7,113,-71,92v-15,3,-18,21,-6,27v37,9,112,-6,107,52v-3,41,-36,51,-81,55v-62,6,-97,-57,-45,-79v-30,-15,-24,-52,6,-65v-44,-30,-17,-104,40,-104v12,0,23,3,33,8xm108,-123v0,-23,-9,-35,-25,-35v-17,0,-26,12,-26,35v0,23,9,35,26,35v17,0,25,-12,25,-35xm128,15v0,-29,-46,-18,-70,-22v-30,18,-12,47,27,47v28,0,43,-9,43,-25xm20,-213r63,-49r63,49r-31,2r-32,-21r-31,21","w":159},"\u0120":{"d":"148,-162v-7,-33,-13,-49,-43,-49v-32,0,-48,30,-48,91v0,61,17,92,50,92v27,0,41,-21,41,-63r-43,0r0,-32r80,0r0,125r-21,0r-6,-31v-12,22,-31,33,-57,33v-60,0,-86,-56,-86,-121v0,-71,24,-127,91,-127v43,0,70,24,78,73xm107,-262v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":202},"\u0121":{"d":"115,-174v3,-26,17,-37,45,-32r0,27v-16,-4,-26,3,-28,19v36,45,-7,113,-71,92v-15,3,-18,21,-6,27v37,9,112,-6,107,52v-3,41,-36,51,-81,55v-62,6,-97,-57,-45,-79v-30,-15,-24,-52,6,-65v-44,-30,-17,-104,40,-104v12,0,23,3,33,8xm108,-123v0,-23,-9,-35,-25,-35v-17,0,-26,12,-26,35v0,23,9,35,26,35v17,0,25,-12,25,-35xm128,15v0,-29,-46,-18,-70,-22v-30,18,-12,47,27,47v28,0,43,-9,43,-25xm84,-202v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":159},"\u0122":{"d":"148,-162v-7,-33,-13,-49,-43,-49v-32,0,-48,30,-48,91v0,61,17,92,50,92v27,0,41,-21,41,-63r-43,0r0,-32r80,0r0,125r-21,0r-6,-31v-12,22,-31,33,-57,33v-60,0,-86,-56,-86,-121v0,-71,24,-127,91,-127v43,0,70,24,78,73xm102,19r33,0r-26,65r-16,0","w":202},"\u0123":{"d":"99,-200r-33,0r25,-65r17,0xm115,-174v3,-26,17,-37,45,-32r0,27v-16,-4,-26,3,-28,19v36,45,-7,113,-71,92v-15,3,-18,21,-6,27v37,9,112,-6,107,52v-3,41,-36,51,-81,55v-62,6,-97,-57,-45,-79v-30,-15,-24,-52,6,-65v-44,-30,-17,-104,40,-104v12,0,23,3,33,8xm108,-123v0,-23,-9,-35,-25,-35v-17,0,-26,12,-26,35v0,23,9,35,26,35v17,0,25,-12,25,-35xm128,15v0,-29,-46,-18,-70,-22v-30,18,-12,47,27,47v28,0,43,-9,43,-25","w":159},"\u0124":{"d":"23,-240r40,0r0,100r70,0r0,-100r40,0r0,240r-40,0r0,-107r-70,0r0,107r-40,0r0,-240xm35,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":196},"\u0125":{"d":"108,-112v0,-30,-2,-40,-22,-40v-45,0,-23,103,-28,152r-37,0r0,-240r37,0r0,86v8,-19,23,-28,43,-28v71,1,36,114,44,182r-37,0r0,-112xm-21,-258r63,-49r63,49r-31,2r-32,-21r-31,21"},"\u0126":{"d":"23,-240r40,0r0,32r71,0r0,-32r39,0r0,32r24,0r0,34r-24,0r0,174r-39,0r0,-107r-71,0r0,107r-40,0r0,-174r-24,0r0,-34r24,0r0,-32xm63,-140r71,0r0,-34r-71,0r0,34","w":196},"\u0127":{"d":"108,-112v-1,-29,-1,-40,-21,-40v-46,0,-24,103,-29,152r-36,0r0,-196r-31,0r0,-28r31,0r0,-16r36,0r0,16r69,0r0,28r-69,0r0,42v8,-19,23,-28,43,-28v71,1,36,114,44,182r-37,0r0,-112"},"\u0128":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm-11,-275v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":85},"\u0129":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm-14,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":79},"\u012a":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm-6,-294r98,0r0,23r-98,0r0,-23","w":85},"\u012b":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm-9,-234r98,0r0,23r-98,0r0,-23","w":79},"\u012c":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm-10,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":85},"\u012d":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm-14,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":79},"\u012e":{"d":"79,59v-45,24,-84,-39,-33,-59r-23,0r0,-240r40,0r0,240v-25,17,-19,52,12,45","w":85},"\u012f":{"d":"59,-201r-38,0r0,-39r38,0r0,39xm74,58v-45,21,-78,-37,-32,-58r-20,0r0,-178r36,0r0,178v-21,16,-18,50,12,44","w":79},"\u0132":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm80,-33v45,10,54,-6,54,-58r0,-149r40,0r0,149v7,75,-26,106,-94,91r0,-33","w":196},"\u0133":{"d":"59,-201r-38,0r0,-39r38,0r0,39xm140,-201r-39,0r0,-39r39,0r0,39xm22,-178r36,0r0,178r-36,0r0,-178xm71,31v29,7,31,-5,31,-38r0,-171r37,0r0,172v5,54,-19,78,-68,67r0,-30","w":159},"\u0134":{"d":"-6,-33v45,11,55,-7,55,-58r0,-149r39,0r0,149v7,75,-26,106,-94,91r0,-33xm4,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":110},"\u0135":{"d":"-22,-202r62,-49r63,49r-31,2r-32,-21r-31,21xm-9,31v29,7,31,-5,31,-38r0,-171r37,0r0,172v5,54,-19,78,-68,67r0,-30","w":79},"\u0136":{"d":"23,-240r40,0r0,114r72,-114r42,0r-62,88r73,152r-43,0r-54,-119r-28,40r0,79r-40,0r0,-240xm85,19r33,0r-26,65r-16,0","w":184},"\u0137":{"d":"21,-240r37,0r0,142r57,-80r37,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-37,0r0,-240xm70,19r33,0r-26,65r-16,0","w":153},"\u0138":{"d":"22,-178r36,0r0,80r58,-80r36,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-36,0r0,-178","w":153},"\u0139":{"d":"23,-240r40,0r0,206r85,0r0,34r-125,0r0,-240xm23,-273r56,-50r19,24r-62,39","w":147},"\u013a":{"d":"22,-240r36,0r0,240r-36,0r0,-240xm22,-273r56,-50r19,24r-62,39","w":79},"\u013b":{"d":"23,-240r40,0r0,206r85,0r0,34r-125,0r0,-240xm69,19r33,0r-26,65r-16,0","w":147},"\u013c":{"d":"22,-240r36,0r0,240r-36,0r0,-240xm24,19r33,0r-26,65r-16,0","w":79},"\u013d":{"d":"23,-240r40,0r0,206r85,0r0,34r-125,0r0,-240xm99,-240r35,0r-26,70r-18,0","w":147},"\u013e":{"d":"22,-240r36,0r0,240r-36,0r0,-240xm80,-240r34,0r-26,67r-17,0","w":108},"\u013f":{"d":"23,-240r40,0r0,206r85,0r0,34r-125,0r0,-240xm97,-145r40,0r0,45r-40,0r0,-45","w":147},"\u0140":{"d":"22,-240r36,0r0,240r-36,0r0,-240xm80,-143r39,0r0,44r-39,0r0,-44","w":119},"\u0143":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240xm80,-273r56,-50r19,24r-62,39","w":202},"\u0144":{"d":"87,-152v-26,0,-28,20,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182r-36,0r0,-112v-1,-25,1,-40,-22,-40xm62,-212r56,-50r19,24r-62,39"},"\u0145":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240xm86,19r33,0r-26,65r-16,0","w":202},"\u0146":{"d":"87,-152v-26,0,-28,20,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182r-36,0r0,-112v-1,-25,1,-40,-22,-40xm68,19r33,0r-26,65r-16,0"},"\u0147":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240xm38,-306r32,-3r31,22r32,-22r31,3r-63,48","w":202},"\u0148":{"d":"87,-152v-26,0,-28,20,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182r-36,0r0,-112v-1,-25,1,-40,-22,-40xm18,-245r32,-3r31,22r32,-22r31,3r-63,48"},"\u0149":{"d":"-4,-240r38,0r0,43r-24,45r-17,0r20,-43r-17,0r0,-45xm109,-152v-26,0,-28,20,-29,53r0,99r-37,0r0,-178r34,0r0,28v8,-21,23,-32,44,-32v74,1,38,113,46,182r-37,0r0,-112v-1,-25,1,-40,-21,-40","w":187},"\u014a":{"d":"115,-209v-76,0,-47,130,-52,209r-40,0r0,-240r38,0r0,41v15,-30,35,-45,62,-45v93,-2,58,137,65,226v4,66,-34,97,-97,85r0,-33v35,8,57,-1,57,-42r0,-153v0,-32,-11,-48,-33,-48","w":210},"\u014b":{"d":"87,-152v-26,0,-29,23,-29,53r0,99r-36,0r0,-178r34,0r0,28v8,-21,22,-32,43,-32v74,1,38,113,46,182v5,51,-22,72,-68,61r0,-30v29,7,31,-5,31,-38r1,-105v-1,-25,1,-40,-22,-40"},"\u014c":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm53,-294r98,0r0,23r-98,0r0,-23","w":202},"\u014d":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm35,-234r98,0r0,23r-98,0r0,-23"},"\u014e":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm48,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":202},"\u014f":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm29,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43"},"\u0150":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm109,-316r19,20r-48,37r-12,-12xm159,-316r19,20r-49,37r-11,-12","w":202},"\u0151":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm88,-256r19,20r-48,37r-12,-12xm138,-256r19,20r-49,37r-11,-12"},"\u0154":{"d":"23,-240v74,-2,149,-6,149,69v0,30,-13,51,-37,63r46,108r-44,0r-37,-100r-37,0r0,100r-40,0r0,-240xm63,-131v41,4,70,-4,70,-41v0,-37,-32,-39,-70,-37r0,78xm67,-273r56,-50r19,24r-62,39","w":190},"\u0155":{"d":"22,-178r32,0r0,40v12,-32,23,-45,51,-43r0,38v-64,-9,-44,85,-47,143r-36,0r0,-178xm39,-212r56,-50r19,24r-62,39","w":98},"\u0156":{"d":"23,-240v74,-2,149,-6,149,69v0,30,-13,51,-37,63r46,108r-44,0r-37,-100r-37,0r0,100r-40,0r0,-240xm63,-131v41,4,70,-4,70,-41v0,-37,-32,-39,-70,-37r0,78xm81,19r33,0r-26,65r-16,0","w":190},"\u0157":{"d":"22,-178r32,0r0,40v12,-32,23,-45,51,-43r0,38v-64,-9,-44,85,-47,143r-36,0r0,-178xm23,19r33,0r-26,65r-16,0","w":98},"\u0158":{"d":"23,-240v74,-2,149,-6,149,69v0,30,-13,51,-37,63r46,108r-44,0r-37,-100r-37,0r0,100r-40,0r0,-240xm63,-131v41,4,70,-4,70,-41v0,-37,-32,-39,-70,-37r0,78xm27,-306r32,-3r31,22r32,-22r31,3r-63,48","w":190},"\u0159":{"d":"22,-178r32,0r0,40v12,-32,23,-45,51,-43r0,38v-64,-9,-44,85,-47,143r-36,0r0,-178xm-2,-245r32,-3r31,22r32,-22r31,3r-63,48","w":98},"\u015a":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,108,30,105,92v-2,43,-33,72,-81,72v-44,0,-72,-22,-83,-67r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38xm71,-273r56,-50r19,24r-62,39","w":184},"\u015b":{"d":"36,-86v-46,-25,-18,-96,35,-96v30,0,48,16,57,46r-28,8v-4,-32,-53,-37,-53,-5v0,42,92,23,88,81v-2,33,-29,56,-65,56v-38,0,-59,-17,-64,-51r31,-6v1,37,59,42,62,7v2,-27,-48,-28,-63,-40xm50,-212r56,-50r19,24r-62,39","w":141},"\u015c":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,108,30,105,92v-2,43,-33,72,-81,72v-44,0,-72,-22,-83,-67r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38xm29,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":184},"\u015d":{"d":"36,-86v-46,-25,-18,-96,35,-96v30,0,48,16,57,46r-28,8v-4,-32,-53,-37,-53,-5v0,42,92,23,88,81v-2,33,-29,56,-65,56v-38,0,-59,-17,-64,-51r31,-6v1,37,59,42,62,7v2,-27,-48,-28,-63,-40xm10,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":141},"\u0162":{"d":"-6,-240r147,0r0,34r-54,0r0,206r-40,0r0,-206r-53,0r0,-34xm51,19r33,0r-26,65r-16,0","w":135},"\u0163":{"d":"101,1v-53,11,-76,-8,-76,-68r0,-81r-23,0r0,-30r24,0r2,-46r33,-3r0,49r34,0r0,30r-34,0r0,78v-4,37,7,46,40,42r0,29xm45,19r33,0r-26,65r-16,0","w":98},"\u0164":{"d":"-6,-240r147,0r0,34r-54,0r0,206r-40,0r0,-206r-53,0r0,-34xm5,-306r32,-3r31,22r32,-22r31,3r-63,48","w":134},"\u0165":{"d":"101,1v-53,11,-76,-8,-76,-68r0,-81r-23,0r0,-30r24,0r2,-46r33,-3r0,49r34,0r0,30r-34,0r0,78v-4,37,7,46,40,42r0,29xm88,-264r34,0r-26,67r-17,0","w":114},"\u0166":{"d":"87,-156r61,0r0,33r-61,0r0,123r-40,0r0,-123r-60,0r0,-33r60,0r0,-50r-53,0r0,-34r147,0r0,34r-54,0r0,50","w":134},"\u0167":{"d":"101,1v-67,17,-84,-26,-76,-99r-23,0r0,-26r23,0r0,-24r-23,0r0,-30r24,0r2,-46r33,-3r0,49r34,0r0,30r-34,0r0,24r27,0r0,26r-27,0v1,38,-11,83,40,70r0,29","w":98},"\u0168":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm45,-275v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2","w":196},"\u0169":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm30,-216v18,-41,50,-23,77,-11v6,0,11,-5,16,-14r15,10v-10,18,-23,27,-36,27v-19,0,-44,-32,-58,-2"},"\u016a":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm50,-294r98,0r0,23r-98,0r0,-23","w":196},"\u016b":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm34,-234r98,0r0,23r-98,0r0,-23"},"\u016c":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm45,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":196},"\u016d":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm29,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43"},"\u016e":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm99,-255v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm99,-304v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16","w":196},"\u016f":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm83,-196v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm83,-245v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16"},"\u0170":{"d":"98,4v-113,0,-68,-145,-77,-244r39,0r0,149v0,40,4,63,40,63v36,0,40,-19,39,-64r0,-148r36,0v-8,101,36,244,-77,244xm106,-317r19,20r-48,37r-12,-12xm156,-317r19,20r-49,37r-11,-12","w":196},"\u0171":{"d":"65,4v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40v50,0,22,-99,29,-153r37,0r0,178r-34,0r0,-27v-9,21,-24,31,-45,31xm88,-256r19,20r-48,37r-12,-12xm138,-256r19,20r-49,37r-11,-12"},"\u0172":{"d":"100,-28v36,0,40,-19,39,-64r0,-148r36,0r0,146v0,48,-3,70,-31,88v-28,18,-22,58,18,49r3,14v-26,10,-65,2,-64,-26v0,-11,5,-21,17,-29v-68,8,-97,-18,-97,-93r0,-149r39,0r0,149v0,40,4,63,40,63","w":196},"\u0173":{"d":"78,-25v50,0,22,-99,29,-153r37,0r0,178v-26,18,-16,53,19,44r4,14v-25,10,-64,2,-63,-26v0,-13,8,-23,24,-32r-18,0r0,-27v-9,21,-24,31,-45,31v-74,0,-36,-116,-45,-182r37,0r0,113v1,27,-1,40,21,40"},"\u0174":{"d":"1,-240r40,0r33,180r37,-180r35,0r37,180r34,-180r34,0r-51,241r-36,0r-38,-177r-37,177r-36,0xm65,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":251},"\u0175":{"d":"0,-178r36,0r26,122r26,-122r32,0r25,123r28,-123r30,0r-44,178r-31,0r-27,-123r-26,123r-31,0xm38,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":202},"\u0176":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm12,-263r63,-49r63,49r-31,2r-32,-21r-31,21","w":147},"\u0177":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38xm5,-202r63,-49r63,49r-31,2r-32,-21r-31,21","w":128},"\u0179":{"d":"7,-240r144,0r0,28r-107,179r109,0r0,33r-153,0r0,-31r105,-176r-98,0r0,-33xm57,-273r56,-50r19,24r-62,39","w":153},"\u017a":{"d":"12,-178r108,0r0,23r-75,127r75,0r0,28r-115,0r0,-28r72,-122r-65,0r0,-28xm43,-212r56,-50r19,24r-62,39","w":122},"\u017b":{"d":"7,-240r144,0r0,28r-107,179r109,0r0,33r-153,0r0,-31r105,-176r-98,0r0,-33xm80,-262v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":153},"\u017c":{"d":"12,-178r108,0r0,23r-75,127r75,0r0,28r-115,0r0,-28r72,-122r-65,0r0,-28xm67,-202v-10,0,-21,-8,-21,-20v0,-12,9,-21,21,-21v12,0,21,9,21,21v0,12,-9,20,-21,20","w":122},"\u017f":{"d":"100,-212v-29,-3,-40,1,-40,34r0,178r-38,0r0,-178v-3,-55,22,-69,78,-66r0,32","w":85},"\u01fa":{"d":"90,-299v28,0,47,40,23,59r64,240r-40,0r-16,-60r-70,0r-14,60r-38,0r69,-239v-25,-18,-8,-60,22,-60xm90,-281v-9,0,-15,6,-15,16v0,9,7,16,15,16v8,0,16,-7,16,-16v0,-8,-8,-16,-16,-16xm114,-91r-28,-110r-27,110r55,0xm49,-322r69,-34r13,29r-72,22","w":177},"\u01fb":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28xm85,-196v-17,0,-33,-14,-33,-33v0,-18,16,-33,33,-33v17,0,33,15,33,33v0,18,-16,34,-33,33xm85,-245v-8,0,-16,8,-15,16v0,7,7,15,15,15v8,0,15,-8,15,-15v1,-8,-7,-16,-15,-16xm49,-277r56,-50r19,24r-62,39"},"\u01fc":{"d":"95,-240r153,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r97,0r0,33r-136,0r0,-66r-62,0r-28,66r-37,0xm113,-97r0,-117r-51,117r51,0xm129,-273r56,-50r19,24r-62,39","w":251},"\u01fd":{"d":"19,-131v1,-50,86,-69,112,-29v22,-28,71,-28,93,2v11,15,19,41,19,75r-100,0v-9,61,54,83,65,27r32,4v-6,64,-92,75,-117,23v-21,48,-113,44,-110,-18v3,-51,39,-63,95,-63v10,-50,-49,-62,-56,-17xm205,-108v-1,-31,-11,-47,-30,-47v-19,0,-29,16,-31,47r61,0xm73,-22v26,-2,38,-32,35,-65v-35,-2,-59,9,-58,37v0,18,8,28,23,28xm103,-212r56,-50r19,24r-62,39","w":251},"\u01fe":{"d":"16,-120v0,-91,53,-150,130,-112r10,-21r26,0r-19,37v16,20,23,53,23,96v0,72,-21,122,-84,124v-25,0,-18,-2,-44,-11r-11,22r-25,0r19,-38v-17,-20,-25,-52,-25,-97xm102,-213v-61,-4,-51,110,-41,155r68,-146v-7,-6,-16,-9,-27,-9xm75,-34v51,26,73,-25,73,-86v0,-28,-2,-47,-6,-59xm66,-273r56,-50r19,24r-62,39","w":202},"\u01ff":{"d":"35,-14v-38,-43,-32,-168,47,-168v14,0,25,3,35,8r10,-19r21,0r-16,32v14,16,21,39,21,71v2,77,-41,108,-102,88r-11,21r-21,0xm103,-151v-38,-18,-56,17,-56,62v0,19,2,34,6,46xm65,-25v56,20,59,-54,49,-105xm51,-212r56,-50r19,24r-62,39"},"\u0384":{"d":"19,-259r27,19r-53,58r-16,-12","w":180},"\u0385":{"d":"118,-305r18,23r-53,34r-10,-16xm62,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm118,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":180},"\u0386":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0xm24,-259r27,19r-53,58r-16,-12","w":177},"\u0387":{"d":"23,-115r40,0r0,45r-40,0r0,-45","w":85},"\u0388":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm-18,-259r27,19r-53,58r-16,-12"},"\u0389":{"d":"23,-240r40,0r0,100r70,0r0,-100r40,0r0,240r-40,0r0,-107r-70,0r0,107r-40,0r0,-240xm-18,-259r27,19r-53,58r-16,-12","w":196},"\u038a":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm-18,-259r27,19r-53,58r-16,-12","w":85},"\u038c":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92xm4,-259r27,19r-53,58r-16,-12","w":202},"\u038e":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm-50,-259r27,19r-53,58r-16,-12","w":147},"\u038f":{"d":"104,-244v104,0,115,173,39,211r53,0r0,33r-81,0r0,-35v45,-21,55,-177,-11,-177v-65,0,-57,154,-11,177r0,35r-81,0r0,-33r53,0v-76,-38,-65,-211,39,-211xm2,-259r27,19r-53,58r-16,-12","w":207},"\u0390":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm68,-305r18,23r-53,34r-10,-16xm12,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm68,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":79},"\u0391":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0","w":177},"\u0392":{"d":"179,-66v0,44,-27,66,-82,66r-74,0r0,-240v72,0,148,-12,148,61v0,27,-11,45,-35,53v29,9,43,29,43,60xm130,-175v0,-37,-33,-35,-68,-34r0,69v37,2,68,0,68,-35xm138,-71v0,-36,-34,-42,-76,-39r0,78v40,2,76,0,76,-39","w":196},"\u0393":{"d":"23,0r0,-240r116,0r0,33r-76,0r0,207r-40,0","w":135},"\u0394":{"d":"-6,0r65,-240r52,0r64,240r-181,0xm40,-33r84,0r-41,-174","w":169},"\u0395":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240"},"\u0396":{"d":"7,-240r144,0r0,28r-107,179r109,0r0,33r-153,0r0,-31r105,-176r-98,0r0,-33","w":153},"\u0397":{"d":"23,-240r40,0r0,100r70,0r0,-100r40,0r0,240r-40,0r0,-107r-70,0r0,107r-40,0r0,-240","w":196},"\u0398":{"d":"105,-244v65,0,88,52,88,124v0,72,-23,124,-88,124v-66,0,-90,-51,-90,-124v0,-72,24,-124,90,-124xm105,-28v41,0,47,-44,47,-92v0,-49,-6,-92,-48,-92v-41,0,-47,43,-47,92v1,48,6,92,48,92xm133,-138r0,32r-57,0r0,-32r57,0","w":208},"\u0399":{"d":"23,-240r40,0r0,240r-40,0r0,-240","w":85},"\u039a":{"d":"23,-240r40,0r0,114r72,-114r42,0r-62,88r73,152r-43,0r-54,-119r-28,40r0,79r-40,0r0,-240","w":184},"\u039b":{"d":"31,0r-37,0r65,-240r49,0r62,240r-42,0r-48,-199","w":164},"\u039c":{"d":"22,-240r59,0r48,173r49,-173r56,0r0,240r-37,0r0,-205r-57,205r-29,0r-56,-205r0,205r-33,0r0,-240","w":257},"\u039d":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240","w":202},"\u039e":{"d":"10,-207r0,-33r139,0r0,33r-139,0xm32,-107r0,-32r95,0r0,32r-95,0xm10,0r0,-33r139,0r0,33r-139,0","w":159},"\u039f":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92","w":202},"\u03a0":{"d":"23,0r0,-240r143,0r0,240r-39,0r0,-207r-64,0r0,207r-40,0","w":189},"\u03a1":{"d":"171,-167v-1,60,-39,78,-108,73r0,94r-40,0r0,-240v79,-4,151,-3,148,73xm129,-167v-2,-37,-23,-46,-66,-42r0,83v40,2,68,-1,66,-41","w":177},"\u03a3":{"d":"9,0r0,-31r60,-96r-56,-81r0,-32r129,0r0,32r-85,0r53,73r-62,102r101,0r0,33r-140,0","w":152},"\u03a4":{"d":"-6,-240r147,0r0,34r-54,0r0,206r-40,0r0,-206r-53,0r0,-34","w":135},"\u03a5":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101","w":147},"\u03a6":{"d":"130,-218v52,5,82,41,82,98v0,57,-27,90,-82,98r0,29r-33,0r0,-29v-54,-4,-81,-43,-82,-97v-1,-58,31,-94,82,-99r0,-30r33,0r0,30xm97,-189v-29,7,-43,30,-43,70v0,38,14,61,43,68r0,-138xm130,-51v29,-7,43,-30,43,-70v0,-38,-14,-61,-43,-68r0,138","w":227},"\u03a7":{"d":"3,-240r44,0r34,77r39,-77r37,0r-56,109r63,131r-44,0r-41,-92r-46,92r-38,0r64,-124","w":159},"\u03a8":{"d":"224,-170v2,82,-11,118,-82,125r0,45r-40,0r0,-45v-94,0,-83,-97,-82,-195r39,0v10,59,-23,155,43,162r0,-162r40,0r0,162v63,-4,38,-97,43,-162r39,0r0,70","w":243},"\u03a9":{"d":"104,-244v104,0,115,173,39,211r53,0r0,33r-81,0r0,-35v45,-21,55,-177,-11,-177v-65,0,-57,154,-11,177r0,35r-81,0r0,-33r53,0v-76,-38,-65,-211,39,-211","w":207},"\u03aa":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm15,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm71,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":85},"\u03ab":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm48,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm104,-264v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":147},"\u03ac":{"d":"13,-87v0,-52,18,-94,65,-95v24,0,41,16,50,46r12,-42r34,0r-27,85r31,93r-37,0r-13,-48v-9,28,-20,52,-52,52v-46,0,-63,-41,-63,-91xm80,-154v-41,6,-38,126,2,131v22,-8,27,-36,35,-68v-7,-17,-14,-66,-37,-63xm64,-212r56,-50r19,24r-62,39","w":182},"\u03ad":{"d":"56,-130v1,22,10,28,35,28r0,23v-28,-3,-37,5,-39,27v-1,18,9,31,24,31v16,0,28,-14,30,-32r33,6v-9,34,-30,51,-65,51v-65,0,-84,-83,-27,-97v-52,-19,-30,-89,28,-89v36,0,56,16,61,48r-33,7v-1,-40,-48,-38,-47,-3xm52,-212r56,-50r19,24r-62,39","w":142},"\u03ae":{"d":"97,-182v42,2,48,26,48,75r0,167r-37,0r0,-171v-1,-28,-1,-40,-20,-43v-50,8,-28,98,-33,154r-37,0r0,-178r34,0r0,25v11,-19,26,-29,45,-29xm64,-212r56,-50r19,24r-62,39","w":162},"\u03af":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm12,-212r56,-50r19,24r-62,39","w":79},"\u03b0":{"d":"82,4v-88,0,-56,-105,-62,-182r36,0r0,105v1,31,-1,50,25,50v26,0,26,-19,26,-50r0,-105r36,0v-5,78,25,182,-61,182xm109,-305r18,23r-53,34r-10,-16xm53,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm109,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":162},"\u03b1":{"d":"13,-87v0,-52,18,-94,65,-95v24,0,41,16,50,46r12,-42r34,0r-27,85r31,93r-37,0r-13,-48v-9,28,-20,52,-52,52v-46,0,-63,-41,-63,-91xm80,-154v-41,6,-38,126,2,131v22,-8,27,-36,35,-68v-7,-17,-14,-66,-37,-63","w":182},"\u03b2":{"d":"110,-135v74,13,59,141,-13,139v-16,0,-29,-6,-39,-18r0,74r-36,0r0,-219v-3,-59,12,-81,63,-85v69,-5,84,90,25,109xm85,-219v-25,2,-26,16,-27,55r0,124v24,37,62,7,62,-35v0,-31,-13,-47,-39,-47r0,-22v24,0,30,-17,30,-37v0,-20,-6,-40,-26,-38","w":171},"\u03b3":{"d":"45,60r0,-60r-50,-178r38,0r33,131v11,-52,22,-84,34,-131r33,0r-51,178r0,60r-37,0","w":129},"\u03b4":{"d":"13,-83v0,-47,23,-82,69,-80r-53,-49r0,-28r106,0r0,28r-65,0v34,35,83,56,83,127v0,50,-22,89,-70,89v-48,1,-70,-37,-70,-87xm83,-23v43,-3,42,-120,0,-122v-44,1,-42,121,0,122"},"\u03b5":{"d":"56,-130v1,22,10,28,35,28r0,23v-28,-3,-37,5,-39,27v-1,18,9,31,24,31v16,0,28,-14,30,-32r33,6v-9,34,-30,51,-65,51v-65,0,-84,-83,-27,-97v-52,-19,-30,-89,28,-89v36,0,56,16,61,48r-33,7v-1,-40,-48,-38,-47,-3","w":142},"\u03b6":{"d":"72,57v9,-24,20,-56,-10,-58v-39,-3,-49,-25,-49,-66v0,-51,23,-99,68,-145r-62,0r0,-28r93,0r0,24v-47,51,-73,106,-55,174v15,19,58,1,58,49v0,17,-3,34,-11,53","w":118},"\u03b7":{"d":"97,-182v42,2,48,26,48,75r0,167r-37,0r0,-171v-1,-28,-1,-40,-20,-43v-50,8,-28,98,-33,154r-37,0r0,-178r34,0r0,25v11,-19,26,-29,45,-29","w":162},"\u03b8":{"d":"83,-244v47,0,70,41,70,124v0,83,-23,124,-70,124v-47,0,-70,-41,-70,-124v0,-83,23,-124,70,-124xm50,-136r66,0v0,-56,-11,-83,-33,-83v-22,0,-33,27,-33,83xm50,-113v4,52,0,83,33,92v33,-8,29,-41,33,-92r-66,0"},"\u03b9":{"d":"22,-178r36,0r0,178r-36,0r0,-178","w":79},"\u03ba":{"d":"22,-178r36,0r0,80r58,-80r36,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-36,0r0,-178","w":153},"\u03bb":{"d":"-4,0r51,-164r-22,-76r39,0r69,240r-39,0r-31,-118r-35,118r-32,0","w":128},"\u03bc":{"d":"85,-23v46,-8,21,-103,27,-155r37,0r0,178r-31,0r0,-19v-9,29,-47,31,-60,6r0,73r-36,0r0,-238r36,0v5,53,-17,146,27,155","w":170},"\u03bd":{"d":"-2,-178r36,0r33,128r33,-128r32,0r-51,178r-32,0","w":128},"\u03be":{"d":"48,-70v-5,62,81,16,81,78v0,13,-3,32,-9,55r-33,-6v9,-29,18,-55,-16,-56v-42,-2,-62,-21,-62,-63v0,-33,16,-55,48,-66v-55,-20,-47,-69,9,-84r-49,0r0,-28r108,0r0,28v-39,-2,-66,8,-66,39v0,27,20,37,51,35r0,27v-39,-2,-59,5,-62,41","w":128},"\u03bf":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66"},"\u03c0":{"d":"23,0r0,-150r-18,0r0,-28r155,0r0,28r-18,0r0,150r-36,0r0,-150r-46,0r0,150r-37,0"},"\u03c1":{"d":"159,-86v0,70,-63,121,-103,68r0,78r-36,0v7,-99,-30,-242,69,-242v49,0,70,40,70,96xm89,-23v25,-3,32,-30,31,-65v0,-44,-10,-66,-31,-66v-21,0,-32,22,-32,66v0,35,7,61,32,65","w":172},"\u03c2":{"d":"81,-154v-40,0,-36,102,-6,115v23,10,66,6,66,47v0,14,-3,32,-9,55r-32,-7v7,-20,16,-54,-11,-56v-53,-5,-72,-35,-76,-91v-5,-66,54,-117,106,-78v11,8,18,25,23,48r-34,7v-3,-27,-12,-40,-27,-40","w":150},"\u03c3":{"d":"13,-88v0,-61,32,-108,93,-90r56,0r0,28r-34,0v45,42,28,157,-45,154v-49,-2,-70,-38,-70,-92xm83,-23v26,-3,31,-31,31,-65v0,-43,-11,-64,-32,-64v-20,0,-30,21,-30,64v0,36,6,61,31,65","w":167},"\u03c4":{"d":"39,0r0,-150r-42,0r0,-28r120,0r0,28r-41,0r0,150r-37,0","w":114},"\u03c5":{"d":"82,4v-88,0,-56,-105,-62,-182r36,0r0,105v1,31,-1,50,25,50v26,0,26,-19,26,-50r0,-105r36,0v-5,78,25,182,-61,182","w":162},"\u03c6":{"d":"192,-89v0,53,-27,89,-76,93r0,56r-33,0r0,-56v-85,0,-96,-146,-29,-175r11,30v-31,26,-23,113,18,118r0,-157v68,-13,109,28,109,91xm116,-22v54,-5,54,-129,0,-133r0,133","w":201},"\u03c7":{"d":"50,-69r-46,-109r38,0r31,81r33,-81r33,0r-49,116r52,122r-38,0r-38,-95r-40,95r-33,0","w":140},"\u03c8":{"d":"200,-178v-2,85,18,186,-72,181r0,57r-36,0r0,-57v-54,-4,-73,-23,-72,-86r0,-95r36,0v2,44,-7,112,7,141v4,9,15,11,29,12r0,-153r36,0r0,153v58,2,27,-100,35,-153r37,0","w":219},"\u03c9":{"d":"75,-23v30,0,12,-74,17,-113r33,0v3,40,-11,113,18,113v15,0,22,-19,22,-56v0,-36,-7,-65,-22,-88r26,-15v23,29,35,63,35,103v0,46,-16,82,-58,83v-18,0,-30,-9,-37,-27v-7,18,-19,27,-37,27v-82,-3,-68,-141,-24,-186r27,15v-15,23,-23,52,-23,88v0,37,8,56,23,56","w":217},"\u03ca":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm12,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm68,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":79},"\u03cb":{"d":"82,4v-88,0,-56,-105,-62,-182r36,0r0,105v1,31,-1,50,25,50v26,0,26,-19,26,-50r0,-105r36,0v-5,78,25,182,-61,182xm53,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm109,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":162},"\u03cc":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66xm55,-212r56,-50r19,24r-62,39"},"\u03cd":{"d":"82,4v-88,0,-56,-105,-62,-182r36,0r0,105v1,31,-1,50,25,50v26,0,26,-19,26,-50r0,-105r36,0v-5,78,25,182,-61,182xm57,-212r56,-50r19,24r-62,39","w":162},"\u03ce":{"d":"75,-23v30,0,12,-74,17,-113r33,0v3,40,-11,113,18,113v15,0,22,-19,22,-56v0,-36,-7,-65,-22,-88r26,-15v23,29,35,63,35,103v0,46,-16,82,-58,83v-18,0,-30,-9,-37,-27v-7,18,-19,27,-37,27v-82,-3,-68,-141,-24,-186r27,15v-15,23,-23,52,-23,88v0,37,8,56,23,56xm92,-212r56,-50r19,24r-62,39","w":217},"\u0401":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240xm64,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm120,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18"},"\u0402":{"d":"106,-132v-50,2,-35,79,-37,132r-40,0r0,-208r-32,0r0,-32r144,0r0,32r-72,0r0,74v11,-17,27,-26,48,-26v56,0,56,38,56,107v-1,80,-2,113,-69,117r0,-30v36,-7,30,-31,30,-84v0,-54,3,-74,-28,-82","w":185},"\u0403":{"d":"23,0r0,-240r116,0r0,33r-76,0r0,207r-40,0xm49,-273r56,-50r19,24r-62,39","w":135,"k":{"\u045e":-7,"\u0459":22,"\u0454":25,"\u044f":24,"\u044e":25,"\u044a":18,"\u0447":30,"\u0446":24,"\u0445":19,"\u0444":27,"\u0443":21,"\u0442":21,"\u0441":25,"\u0440":24,"\u043f":24,"\u043e":25,"\u043d":24,"\u043c":24,"\u043b":20,"\u043a":24,"\u0438":24,"\u0437":26,"\u0436":20,"\u0435":25,"\u0434":27,"\u0432":24,"\u0430":27,"\u0427":-8,"\u0424":9,"\u0423":-18,"\u0422":-20,"\u041b":8,"\u0414":13,"\u040e":-18,"\u040b":-18,"\u0409":8}},"\u0404":{"d":"15,-119v0,-70,22,-124,88,-125v40,0,65,21,75,65r-36,11v-4,-29,-17,-43,-39,-43v-29,0,-45,24,-47,72r71,0r0,30r-71,0v1,54,17,81,47,81v28,0,34,-21,40,-49r36,8v-9,49,-34,73,-77,73v-64,-1,-87,-55,-87,-123","w":186},"\u0405":{"d":"49,-121v-54,-32,-30,-123,42,-123v39,0,64,19,75,58r-34,11v-7,-22,-17,-35,-42,-37v-28,-2,-45,36,-23,52v33,24,108,30,105,92v-2,43,-33,72,-81,72v-44,0,-72,-22,-83,-67r36,-10v6,30,22,45,48,45v32,0,50,-29,33,-55v-9,-13,-63,-31,-76,-38","w":184},"\u0406":{"d":"23,-240r40,0r0,240r-40,0r0,-240","w":85},"\u0407":{"d":"23,-240r40,0r0,240r-40,0r0,-240xm15,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm71,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":85},"\u0408":{"d":"-6,-33v45,11,55,-7,55,-58r0,-149r39,0r0,149v7,75,-26,106,-94,91r0,-33","w":110},"\u0409":{"d":"250,-74v0,46,-21,74,-68,74r-66,0r-36,-199r-49,199r-37,0r65,-240r49,0r19,93r48,0v56,-2,75,24,75,73xm211,-74v0,-46,-35,-42,-77,-41r17,82v37,2,60,-3,60,-41","w":258,"k":{"\u044a":1,"\u042a":9,"\u0427":4,"\u0423":3,"\u0422":13,"\u040e":3,"\u040b":4}},"\u040a":{"d":"279,-72v-1,43,-23,72,-66,72r-84,0r0,-111r-66,0r0,111r-40,0r0,-240r40,0r0,97r66,0r0,-97r39,0r0,97v68,-5,112,8,111,71xm240,-73v0,-39,-33,-41,-72,-38r0,78v40,2,72,1,72,-40","w":287,"k":{"\u044a":1,"\u042a":9,"\u0427":4,"\u0423":2,"\u0422":13,"\u040e":2,"\u040b":4}},"\u040b":{"d":"133,-85v6,-61,-64,-53,-64,-13r0,98r-40,0r0,-208r-32,0r0,-32r145,0r0,32r-73,0r0,72v35,-46,104,-25,104,53r0,83r-40,0r0,-85","w":192},"\u040c":{"d":"23,-240r40,0r0,114r72,-114r42,0r-62,88r73,152r-43,0r-54,-119r-28,40r0,79r-40,0r0,-240xm73,-273r56,-50r19,24r-62,39","w":184,"k":{"\u045e":-2,"\u0454":2,"\u0447":12,"\u0444":4,"\u0443":8,"\u0442":3,"\u0441":2,"\u043e":2,"\u0437":-4,"\u0435":2,"\u0431":2,"\u0430":-2,"\u0424":11,"\u0421":7,"\u041e":6,"\u0404":7}},"\u040e":{"d":"66,-69r-70,-171r41,0r46,122r40,-122r35,0v-28,72,-46,170,-85,228v-8,13,-30,13,-52,12r0,-34v29,4,38,-10,45,-35xm30,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":153,"k":{"\u0459":14,"\u0454":10,"\u044f":7,"\u044e":5,"\u0447":2,"\u0446":6,"\u0445":-5,"\u0444":11,"\u0442":-7,"\u0441":10,"\u0440":5,"\u043f":5,"\u043e":10,"\u043d":5,"\u043c":5,"\u043b":11,"\u043a":5,"\u0438":5,"\u0437":6,"\u0436":-4,"\u0435":11,"\u0434":20,"\u0431":5,"\u0430":10,"\u0427":-9,"\u0424":6,"\u0422":-20,"\u0421":3,"\u041e":3,"\u041b":7,"\u0417":-1,"\u0414":13,"\u0410":10,"\u040e":-19,"\u040b":-19,"\u0409":7,"\u0404":3}},"\u040f":{"d":"63,-33r69,0r0,-207r40,0r0,240r-58,0r-3,51r-27,0r-3,-51r-58,0r0,-240r40,0r0,207","w":194},"\u0410":{"d":"68,-240r44,0r65,240r-40,0r-16,-60r-70,0r-14,60r-38,0xm114,-91r-28,-110r-27,110r55,0","w":177,"k":{"\u045e":3,"\u0459":-13,"\u0447":6,"\u0444":2,"\u0443":3,"\u0442":4,"\u043b":-15,"\u0437":-4,"\u042a":6,"\u0427":11,"\u0424":6,"\u0423":-4,"\u0422":9,"\u0421":4,"\u041e":4,"\u041b":-17,"\u0417":-2,"\u040e":-4,"\u0409":-17,"\u0404":4,"\u00bb":-2,";":-2,":":-2,".":-7,"-":-4,",":-6}},"\u0411":{"d":"174,-71v-1,42,-24,72,-67,71r-84,0r0,-240r127,0r0,32r-87,0r0,61v70,-6,112,12,111,76xm63,-33v40,2,72,2,72,-40v0,-44,-31,-44,-72,-42r0,82","w":188,"k":{"\u045e":6,"\u044a":4,"\u0443":6,"\u0442":8,"\u0436":2,"\u0428":3,"\u0427":7,"\u0423":2,"\u0422":1,"\u0416":2,"\u040e":2,"\u040b":2}},"\u0412":{"d":"179,-66v0,44,-27,66,-82,66r-74,0r0,-240v72,0,148,-12,148,61v0,27,-11,45,-35,53v29,9,43,29,43,60xm130,-175v0,-37,-33,-35,-68,-34r0,69v37,2,68,0,68,-35xm138,-71v0,-36,-34,-42,-76,-39r0,78v40,2,76,0,76,-39","w":196,"k":{"\u045e":-1,"\u0459":2,"\u044a":-5,"\u0447":4,"\u0443":-1,"\u0442":-2,"\u0428":1,"\u0427":6,"\u0423":5,"\u0422":-2,"\u0416":4,"\u040e":5,"\u040b":-1}},"\u0413":{"d":"23,0r0,-240r116,0r0,33r-76,0r0,207r-40,0","w":135,"k":{"\u045e":-7,"\u0459":22,"\u0454":25,"\u044f":24,"\u044e":25,"\u044a":18,"\u0447":30,"\u0446":24,"\u0445":19,"\u0444":27,"\u0443":21,"\u0442":21,"\u0441":25,"\u0440":24,"\u043f":24,"\u043e":25,"\u043d":24,"\u043c":24,"\u043b":20,"\u043a":24,"\u0438":24,"\u0437":26,"\u0436":20,"\u0435":25,"\u0434":27,"\u0432":24,"\u0430":27,"\u0427":-8,"\u0424":9,"\u0423":-18,"\u0422":-20,"\u041b":8,"\u0414":13,"\u040e":-18,"\u040b":-18,"\u0409":8,";":28,":":27,".":24,"-":20,",":25}},"\u0414":{"d":"17,-33r53,-207r58,0r47,207r14,0r0,84r-28,0r-4,-51r-121,0r-5,51r-27,0r0,-84r13,0xm53,-33r81,0r-34,-166r-9,0","w":192},"\u0415":{"d":"23,-240r137,0r0,32r-97,0r0,68r76,0r0,32r-76,0r0,75r99,0r0,33r-139,0r0,-240","k":{"\u0424":6}},"\u0416":{"d":"177,-138r72,138r-42,0r-60,-114r-8,4r0,110r-37,0r0,-110r-8,-4r-61,114r-37,0r68,-125r-62,-115r41,0r55,102r4,2r0,-104r37,0r0,104r4,-2r55,-102r37,0","w":240,"k":{"\u045e":-2,"\u0447":11,"\u0444":2,"\u0443":5,"\u0437":-6,"\u0430":-5,"\u0424":9,"\u0421":4,"\u041e":4,"\u0417":-2,"\u0404":4}},"\u0417":{"d":"123,-127v76,21,46,131,-34,131v-47,0,-73,-24,-80,-72r35,-6v1,58,81,61,81,4v0,-31,-18,-44,-51,-40r0,-29v30,3,48,-7,48,-36v0,-21,-14,-38,-35,-37v-21,0,-35,14,-39,40r-34,-6v7,-45,32,-66,75,-66v73,0,100,95,34,117","w":181,"k":{"\u045e":-3,"\u0459":1,"\u0447":2,"\u0445":-3,"\u0443":-3,"\u0442":-5,"\u042f":4,"\u0427":4,"\u0425":2,"\u0423":2,"\u0422":-5,"\u041b":-3,"\u0417":-3,"\u0416":3,"\u0414":-1,"\u040e":2,"\u040b":-4,"\u0409":-3}},"\u0418":{"d":"63,-21r0,21r-40,0r0,-240r40,0r-2,168v20,-51,53,-98,78,-145r0,-23r39,0r0,240r-39,0r1,-166v-20,50,-52,98,-77,145","w":201},"\u0419":{"d":"63,-21r0,21r-40,0r0,-240r40,0r-2,168v20,-51,53,-98,78,-145r0,-23r39,0r0,240r-39,0r1,-166v-20,50,-52,98,-77,145xm48,-306r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":201},"\u041a":{"d":"23,-240r40,0r0,114r72,-114r42,0r-62,88r73,152r-43,0r-54,-119r-28,40r0,79r-40,0r0,-240","w":184,"k":{"\u045e":-2,"\u0454":2,"\u0447":12,"\u0444":4,"\u0443":8,"\u0442":3,"\u0441":2,"\u043e":2,"\u0437":-4,"\u0435":2,"\u0431":2,"\u0430":-2,"\u0424":11,"\u0421":7,"\u041e":6,"\u0404":7}},"\u041b":{"d":"31,0r-37,0r65,-240r49,0r62,240r-42,0r-48,-199","w":164},"\u041c":{"d":"22,-240r59,0r48,173r49,-173r56,0r0,240r-37,0r0,-205r-57,205r-29,0r-56,-205r0,205r-33,0r0,-240","w":257},"\u041d":{"d":"23,-240r40,0r0,100r70,0r0,-100r40,0r0,240r-40,0r0,-107r-70,0r0,107r-40,0r0,-240","w":196},"\u041e":{"d":"102,-244v63,0,86,53,86,124v1,72,-22,124,-86,124v-64,0,-87,-52,-87,-124v0,-73,23,-124,87,-124xm102,-28v39,0,44,-45,44,-92v0,-47,-5,-92,-45,-92v-39,0,-44,46,-44,92v0,47,4,92,45,92","w":202,"k":{"\u0459":2,"\u042f":3,"\u042a":-2,"\u0427":1,"\u0425":4,"\u0423":5,"\u0422":-1,"\u0416":5,"\u0414":3,"\u0410":4,"\u040e":5}},"\u041f":{"d":"23,0r0,-240r145,0r0,240r-40,0r0,-208r-65,0r0,208r-40,0","w":190},"\u0420":{"d":"171,-167v-1,60,-39,78,-108,73r0,94r-40,0r0,-240v79,-4,151,-3,148,73xm129,-167v-2,-37,-23,-46,-66,-42r0,83v40,2,68,-1,66,-41","w":177,"k":{"\u0459":12,"\u0454":1,"\u0444":2,"\u0441":1,"\u043e":1,"\u043b":8,"\u0437":-2,"\u0435":2,"\u0434":17,"\u0430":2,"\u042f":-2,"\u0427":-2,"\u0421":-2,"\u041b":6,"\u0414":12,"\u0410":9,"\u0409":6,";":1,".":33,"-":3,",":34}},"\u0421":{"d":"103,-28v29,0,36,-24,41,-53r36,5v-8,53,-33,80,-78,80v-64,0,-87,-54,-87,-123v0,-70,24,-124,88,-125v44,0,70,27,78,82r-37,5v-4,-36,-18,-54,-41,-54v-31,0,-46,31,-46,94v0,59,15,89,46,89","w":190,"k":{"\u045e":-8,"\u0459":1,"\u0447":-1,"\u0443":-8,"\u0442":-10,"\u042f":-1,"\u0425":1,"\u0422":-7,"\u0421":-1,"\u041e":-1,"\u041b":-4,"\u0417":-5,"\u0416":2,"\u0410":-1,"\u040b":-5,"\u0409":-4}},"\u0422":{"d":"-6,-240r147,0r0,34r-54,0r0,206r-40,0r0,-206r-53,0r0,-34","w":135,"k":{"\u045e":-8,"\u0459":10,"\u0454":13,"\u044f":12,"\u044a":6,"\u0447":18,"\u0446":12,"\u0445":7,"\u0444":15,"\u0443":10,"\u0442":9,"\u0441":13,"\u0440":12,"\u043f":12,"\u043e":13,"\u043d":12,"\u043c":12,"\u043b":8,"\u043a":12,"\u0438":12,"\u0437":14,"\u0436":8,"\u0435":13,"\u0434":15,"\u0433":12,"\u0432":12,"\u0430":15,"\u042f":-5,"\u0424":8,"\u0423":-19,"\u0422":-21,"\u041e":-1,"\u041b":6,"\u0417":-7,"\u0414":11,"\u0410":8,"\u040e":-19,"\u040b":-19,"\u0409":6,"\u00bb":13,";":16,":":15,".":12,"-":8,",":13}},"\u0423":{"d":"66,-69r-70,-171r41,0r46,122r40,-122r35,0v-28,72,-46,170,-85,228v-8,13,-30,13,-52,12r0,-34v29,4,38,-10,45,-35","w":153,"k":{"\u045e":-8,"\u0459":14,"\u0454":10,"\u044f":7,"\u044e":5,"\u0447":2,"\u0446":6,"\u0445":-5,"\u0444":11,"\u0443":-6,"\u0442":-7,"\u0441":10,"\u0440":5,"\u043f":5,"\u043e":10,"\u043d":5,"\u043c":5,"\u043b":11,"\u043a":5,"\u0438":5,"\u0437":6,"\u0436":-4,"\u0435":11,"\u0434":20,"\u0431":5,"\u0430":10,"\u0427":-9,"\u0424":6,"\u0423":-19,"\u0422":-20,"\u0421":3,"\u041e":3,"\u041b":7,"\u0417":-1,"\u0414":13,"\u0410":10,"\u040b":-19,"\u0409":7,"\u0404":3,"\u00bb":8,";":6,":":5,".":21,"-":6,",":22}},"\u0424":{"d":"130,-218v52,5,82,41,82,98v0,57,-27,90,-82,98r0,29r-33,0r0,-29v-54,-4,-81,-43,-82,-97v-1,-58,31,-94,82,-99r0,-30r33,0r0,30xm97,-189v-29,7,-43,30,-43,70v0,38,14,61,43,68r0,-138xm130,-51v29,-7,43,-30,43,-70v0,-38,-14,-61,-43,-68r0,138","w":227,"k":{"\u0459":6,"\u043b":3,"\u0434":12,"\u042f":4,"\u042a":7,"\u0427":2,"\u0425":9,"\u0423":9,"\u041b":2,"\u0416":10,"\u0414":9,"\u0410":6,"\u040e":9,"\u0409":2}},"\u0425":{"d":"3,-240r44,0r34,77r39,-77r37,0r-56,109r63,131r-44,0r-41,-92r-46,92r-38,0r64,-124","w":159,"k":{"\u0454":2,"\u0447":12,"\u0444":4,"\u0443":3,"\u0442":2,"\u0441":2,"\u043e":2,"\u0437":-4,"\u0435":2,"\u0430":-3,"\u0424":8,"\u0421":4,"\u041e":3,"\u0417":-1,"\u0404":4}},"\u0426":{"d":"23,0r0,-240r40,0r0,207r69,0r0,-207r40,0r0,207r25,0r0,84r-28,0r-4,-51r-142,0","w":197},"\u0427":{"d":"57,-240v6,45,-19,126,27,129v14,0,27,-7,39,-22r0,-107r39,0r0,240r-39,0r0,-101v-38,46,-106,18,-106,-55r0,-84r40,0","w":185},"\u0428":{"d":"23,0r0,-240r40,0r0,207r57,0r0,-207r40,0r0,207r57,0r0,-207r40,0r0,240r-234,0","w":280},"\u0429":{"d":"257,-33r25,0r0,84r-27,0r-5,-51r-227,0r0,-240r40,0r0,207r57,0r0,-207r40,0r0,207r57,0r0,-207r40,0r0,207","w":282},"\u042a":{"d":"189,-74v-1,43,-22,74,-68,74r-81,0r0,-207r-49,0r0,-33r89,0r0,93v68,-5,111,9,109,73xm150,-74v0,-42,-30,-43,-70,-41r0,82v40,2,70,2,70,-41","w":197,"k":{"\u044a":1,"\u042a":9,"\u0427":4,"\u0423":3,"\u0422":13,"\u040e":3,"\u040b":4}},"\u042b":{"d":"171,-74v0,44,-21,74,-67,74r-81,0r0,-240r40,0r0,93v68,-5,108,9,108,73xm132,-74v0,-43,-29,-43,-69,-41r0,82v40,2,69,1,69,-41xm191,-240r40,0r0,240r-40,0r0,-240","w":253},"\u042c":{"d":"171,-74v0,44,-21,74,-67,74r-81,0r0,-240r40,0r0,93v68,-5,108,9,108,73xm132,-74v0,-43,-29,-43,-69,-41r0,82v40,2,69,1,69,-41","w":180,"k":{"\u044a":1,"\u042a":9,"\u0427":4,"\u0423":3,"\u0422":13,"\u040e":3,"\u040b":4}},"\u042d":{"d":"43,-77v6,27,12,49,40,49v30,0,46,-27,48,-81r-72,0r0,-30r71,0v6,-79,-75,-100,-86,-29r-35,-11v10,-44,34,-65,74,-65v65,-1,88,56,88,124v0,69,-22,123,-86,124v-43,0,-69,-24,-78,-73","w":186,"k":{"\u0459":2,"\u042f":4,"\u042a":-2,"\u0427":2,"\u0423":6,"\u041b":1,"\u0414":4,"\u0410":4,"\u040e":6,"\u0409":1}},"\u042e":{"d":"268,-120v0,72,-22,124,-86,124v-54,0,-83,-38,-86,-114r-33,0r0,110r-40,0r0,-240r40,0r0,98r34,0v6,-68,33,-102,85,-102v64,0,86,52,86,124xm182,-28v39,0,44,-46,44,-92v0,-46,-3,-92,-44,-92v-40,0,-45,44,-45,92v0,47,5,92,45,92","w":283,"k":{"\u0459":2,"\u042f":3,"\u042a":-2,"\u0427":1,"\u0425":4,"\u0423":5,"\u0422":-1,"\u041b":1,"\u0416":5,"\u0414":3,"\u0410":4,"\u040e":5,"\u0409":1}},"\u042f":{"d":"167,-240v-74,-2,-149,-6,-149,69v0,30,13,51,37,63r-46,108r44,0r37,-100r37,0r0,100r40,0r0,-240xm127,-131v-41,4,-70,-4,-70,-41v0,-37,33,-39,70,-37r0,78","w":190},"\u0430":{"d":"110,-110v11,-49,-51,-62,-56,-17r-35,-5v4,-31,31,-50,67,-50v87,0,51,111,63,182r-34,0v-2,-6,-3,-17,-3,-30v-18,51,-102,43,-99,-17v3,-49,37,-65,97,-63xm75,-22v24,0,37,-32,35,-64v-34,-4,-59,8,-59,36v0,18,8,28,24,28","k":{"\u045e":3,"\u0459":-4,"\u0447":5,"\u0443":3,"\u0442":-3}},"\u0431":{"d":"83,4v-55,0,-70,-40,-70,-101v0,-96,23,-135,82,-146v3,-2,4,-7,5,-13r37,0v2,45,-66,29,-79,63v-3,8,-6,18,-8,30v46,-48,103,4,103,74v0,54,-21,93,-70,93xm82,-23v26,-2,33,-30,32,-64v0,-45,-11,-67,-32,-67v-22,0,-33,22,-33,67v0,36,7,60,33,64","k":{"\u045e":3,"\u0447":2,"\u0445":1,"\u0443":3,"\u0442":-2,"\u0436":1}},"\u0432":{"d":"116,-93v53,9,47,93,-7,93r-87,0r0,-178v55,1,126,-13,126,44v0,19,-11,33,-32,41xm114,-127v0,-31,-28,-26,-56,-26r0,51v27,0,56,6,56,-25xm58,-28v29,0,59,7,59,-27v0,-33,-30,-27,-59,-27r0,54","k":{"\u045e":1,"\u0447":4,"\u0445":-2,"\u0443":1,"\u0442":-4,"\u0437":-3,"\u0436":-1}},"\u0433":{"d":"115,-178r0,28r-57,0r0,150r-36,0r0,-178r93,0","w":115,"k":{"\u045e":-12,"\u0459":9,"\u0454":-1,"\u044f":-5,"\u0444":1,"\u0441":-1,"\u043e":-1,"\u043b":5,"\u0434":14,";":-1,":":-2,".":18,"-":14,",":19}},"\u0434":{"d":"24,-28r36,-150r55,0r32,150r13,0r0,69r-24,0r-5,-41r-91,0r-5,41r-24,0r0,-69r13,0xm56,-28r54,0r-24,-121r-5,0","w":162},"\u0435":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0","w":159,"k":{"\u045e":1,"\u044f":-1,"\u0443":1,"\u043b":-3,"\u0437":-4}},"\u0436":{"d":"153,-106r52,106r-38,0r-41,-82r-10,3r0,79r-34,0r0,-79r-10,-3r-42,82r-34,0r51,-94r-46,-84r36,0r37,70r8,2r0,-72r34,0r0,72r8,-2r37,-70r34,0","w":197,"k":{"\u045e":-10,"\u0444":2,"\u0437":-4,"\u0431":-1}},"\u0437":{"d":"93,-52v-1,-23,-13,-28,-39,-27r0,-23v23,-1,36,-4,35,-29v0,-17,-7,-26,-20,-26v-14,0,-23,10,-26,30r-32,-7v1,-60,119,-66,117,0v0,19,-10,32,-30,41v59,16,36,97,-26,97v-40,0,-58,-20,-65,-51r33,-6v3,43,55,41,53,1","w":143,"k":{"\u045e":1,"\u0459":-1,"\u0447":3,"\u0445":-1,"\u0442":-5,"\u043b":-4}},"\u0438":{"d":"92,-70v-12,23,-35,34,-34,70r-36,0r0,-178r36,0r-1,114v15,-31,37,-62,55,-91r0,-23r37,0r0,178r-37,0r1,-109v-5,13,-14,25,-21,39","w":170},"\u0439":{"d":"92,-70v-12,23,-35,34,-34,70r-36,0r0,-178r36,0r-1,114v15,-31,37,-62,55,-91r0,-23r37,0r0,178r-37,0r1,-109v-5,13,-14,25,-21,39xm31,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":170,"k":{"\u0459":-2}},"\u043a":{"d":"22,-178r36,0r0,80r58,-80r36,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-36,0r0,-178","w":153,"k":{"\u045e":-10,"\u0454":1,"\u0444":3,"\u0441":1,"\u043e":1,"\u0437":-3,"\u0435":1,"\u0431":-1,"\u0430":-2}},"\u043b":{"d":"-4,0r49,-178r42,0r46,178r-38,0r-32,-142r-35,142r-32,0","w":128},"\u043c":{"d":"21,0r0,-178r53,0r38,149r36,-149r50,0r0,178r-33,0r0,-145r-39,145r-38,0r-37,-145r0,145r-30,0","w":219},"\u043d":{"d":"22,0r0,-178r36,0r0,71r53,0r0,-71r37,0r0,178r-37,0r0,-79r-53,0r0,79r-36,0","w":169},"\u043e":{"d":"83,-182v48,0,70,36,70,91v0,63,-24,95,-71,95v-50,0,-69,-36,-69,-93v0,-62,23,-93,70,-93xm83,-23v44,0,43,-130,0,-131v-21,0,-31,21,-31,65v0,36,3,66,31,66","k":{"\u045e":3,"\u0459":2,"\u044a":-5,"\u0445":1,"\u0443":3,"\u0442":-2,"\u0436":1}},"\u043f":{"d":"22,0r0,-178r120,0r0,178r-37,0r0,-153r-47,0r0,153r-36,0","w":163},"\u0440":{"d":"159,-90v0,47,-17,93,-62,93v-17,0,-30,-7,-39,-21r0,78r-37,0r0,-238r34,0r0,30v9,-21,24,-33,44,-33v42,1,60,41,60,91xm120,-90v0,-82,-62,-80,-62,-14v0,39,-3,78,31,80v21,0,31,-22,31,-66","w":171,"k":{"\u045e":3,"\u0447":2,"\u0443":2,"\u0442":-2,"\u0436":1,";":5,":":4,".":2,"-":-8,",":4}},"\u0441":{"d":"13,-88v0,-54,19,-93,69,-94v36,0,58,21,63,64r-36,4v-4,-25,-5,-37,-27,-39v-29,4,-28,29,-31,68v-5,66,53,82,58,21r36,3v-5,44,-27,65,-65,65v-50,0,-67,-39,-67,-92","w":147,"k":{"\u0459":-1,"\u044f":-2,"\u0447":-1,"\u0445":-1,"\u0444":-2,"\u0443":-1,"\u0442":-7,"\u043e":-2,"\u043b":-4,"\u0437":-4,"\u0430":-2,"\u040e":2}},"\u0442":{"d":"38,0r0,-150r-41,0r0,-28r117,0r0,28r-39,0r0,150r-37,0","w":110,"k":{"\u045e":-13,"\u0459":5,"\u0454":-2,"\u044f":-6,"\u0447":-6,"\u0443":-13,"\u0442":-15,"\u0441":-2,"\u043e":-2,"\u043b":3,"\u0437":-7,"\u0435":-1,"\u0434":10,"\u0430":-2,"\u00bb":9,";":-3,":":-4,".":8,"-":4,",":9}},"\u0443":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38","w":128,"k":{"\u0459":3,"\u044f":-3,"\u0447":-7,"\u0444":1,"\u0442":-16,"\u0437":-4,"\u0435":1,"\u0434":9,"\u00bb":-2,";":-3,":":-4,".":9,"-":-4,",":10}},"\u0444":{"d":"191,-88v-1,49,-27,83,-73,88r0,60r-32,0r0,-60v-46,-4,-73,-39,-73,-87v0,-51,24,-82,73,-91r0,-59r32,0r0,59v49,10,73,40,73,90xm86,-23r0,-131v-49,8,-50,123,0,131xm118,-23v50,-8,49,-123,0,-131r0,131","w":203,"k":{"\u045e":4,"\u0459":3,"\u044f":1,"\u044a":-2,"\u0447":2,"\u0445":3,"\u0443":4,"\u0436":4,"\u0434":8,"\u0433":1}},"\u0445":{"d":"-1,-178r41,0r26,52r27,-52r34,0r-45,81r53,97r-41,0r-32,-63r-34,63r-34,0r51,-92","w":128,"k":{"\u045e":-10,"\u0454":1,"\u0444":4,"\u0441":1,"\u043e":1,"\u0437":-2,"\u0435":1,"\u0430":-1}},"\u0446":{"d":"22,0r0,-178r36,0r0,150r49,0r0,-150r37,0r0,150r22,0r0,69r-24,0r-5,-41r-115,0","w":166},"\u0447":{"d":"98,-68v-28,25,-81,14,-81,-36r0,-74r36,0v4,33,-13,94,21,95v9,0,18,-3,24,-9r0,-86r36,0r0,178r-36,0r0,-68","w":156},"\u0448":{"d":"22,0r0,-178r36,0r0,150r44,0r0,-150r37,0r0,150r44,0r0,-150r36,0r0,178r-197,0","w":240},"\u0449":{"d":"22,0r0,-178r36,0r0,150r44,0r0,-150r37,0r0,150r44,0r0,-150r36,0r0,150r23,0r0,69r-25,0r-4,-41r-191,0","w":242},"\u044a":{"d":"67,-110v51,-4,87,5,87,55v0,66,-64,55,-124,55r0,-150r-39,0r0,-28r76,0r0,68xm67,-28v28,0,51,5,51,-28v0,-33,-22,-30,-51,-29r0,57","w":161,"k":{"\u045e":7,"\u044a":6,"\u0447":2,"\u0443":7,"\u0442":9,"\u0441":-2,"\u0435":-2}},"\u044b":{"d":"58,-110v52,-6,88,7,88,55v0,66,-64,55,-124,55r0,-178r36,0r0,68xm58,-28v28,0,52,5,52,-28v0,-33,-23,-30,-52,-29r0,57xm160,0r0,-178r37,0r0,178r-37,0","w":218},"\u044c":{"d":"58,-110v52,-6,88,7,88,55v0,66,-64,55,-124,55r0,-178r36,0r0,68xm58,-28v28,0,52,5,52,-28v0,-33,-23,-30,-52,-29r0,57","w":152,"k":{"\u045e":7,"\u044a":6,"\u0447":2,"\u0443":7,"\u0442":9,"\u0441":-2,"\u0435":-2}},"\u044d":{"d":"66,-182v50,0,70,39,69,93v0,62,-22,93,-67,93v-35,0,-57,-17,-63,-53r35,-7v2,20,11,30,26,30v21,0,31,-17,32,-52r-56,0r0,-25r55,0v3,-55,-48,-69,-57,-21r-35,-7v8,-34,28,-51,61,-51","w":148,"k":{"\u045e":3,"\u0459":2,"\u044a":-5,"\u0447":2,"\u0443":3,"\u0442":-2}},"\u044e":{"d":"155,-182v49,1,70,38,70,91v0,63,-23,95,-69,95v-43,0,-66,-27,-69,-83r-29,0r0,79r-36,0r0,-176r36,0r0,70r30,0v4,-51,26,-76,67,-76xm155,-23v27,-3,31,-30,31,-66v0,-35,-3,-65,-31,-65v-28,0,-31,30,-31,65v0,36,3,63,31,66","w":237,"k":{"\u045e":3,"\u0459":2,"\u044a":-5,"\u0447":2,"\u0445":1,"\u0443":3,"\u0442":-2,"\u0436":1}},"\u044f":{"d":"39,-78v-44,-19,-36,-100,28,-100r71,0r0,178r-37,0r0,-71r-32,0r-27,71r-37,0xm48,-123v0,28,24,29,53,27r0,-57v-29,-1,-53,-3,-53,30","w":156},"\u0451":{"d":"13,-86v-16,-90,102,-133,131,-50v4,14,7,31,7,53r-101,0v-11,62,55,83,66,27r33,4v-9,38,-31,56,-66,56v-47,0,-71,-36,-70,-90xm113,-108v0,-31,-10,-47,-30,-47v-19,0,-30,16,-32,47r62,0xm56,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm112,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":159},"\u0452":{"d":"90,-144v-48,0,-28,91,-32,144r-36,0r0,-201r-26,0r0,-22r26,0r0,-21r36,0r0,21r58,0r0,22r-58,0r0,51v10,-16,25,-24,43,-24v54,0,47,51,47,122v0,76,2,108,-59,112r-3,-25v33,-7,28,-37,28,-83v0,-42,-2,-68,-5,-79v-3,-11,-9,-17,-19,-17","w":164},"\u0453":{"d":"115,-178r0,28r-57,0r0,150r-36,0r0,-178r93,0xm41,-212r56,-50r19,24r-62,39","w":115,"k":{"\u0459":9,"\u044f":-5,"\u0444":1,"\u043b":5,"\u0434":13}},"\u0454":{"d":"13,-88v0,-54,19,-93,69,-94v33,0,53,17,61,51r-35,7v-3,-19,-12,-29,-26,-29v-19,0,-29,17,-31,50r56,0r0,25r-57,0v-5,56,52,72,59,22r34,7v-7,36,-27,53,-62,53v-45,0,-68,-30,-68,-92","w":148},"\u0455":{"d":"36,-86v-46,-25,-18,-96,35,-96v30,0,48,16,57,46r-28,8v-4,-32,-53,-37,-53,-5v0,42,92,23,88,81v-2,33,-29,56,-65,56v-38,0,-59,-17,-64,-51r31,-6v1,37,59,42,62,7v2,-27,-48,-28,-63,-40","w":141},"\u0456":{"d":"59,-201r-38,0r0,-39r38,0r0,39xm22,-178r36,0r0,178r-36,0r0,-178","w":79},"\u0457":{"d":"22,-178r36,0r0,178r-36,0r0,-178xm12,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm68,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":79},"\u0458":{"d":"60,-201r-39,0r0,-39r39,0r0,39xm-9,31v29,7,31,-5,31,-38r0,-171r37,0r0,172v5,54,-19,78,-68,67r0,-30","w":79},"\u0459":{"d":"162,-110v34,-1,47,24,49,55v4,63,-58,56,-116,55r-23,-142r-39,142r-33,0r54,-178r43,0r13,68r52,0xm127,-28v27,1,48,3,48,-28v0,-36,-29,-29,-60,-29","w":213,"k":{"\u045e":4,"\u044a":3,"\u0443":4,"\u0442":7}},"\u045a":{"d":"146,-106v49,-4,87,3,87,51v0,66,-64,55,-124,55r0,-81r-51,0r0,81r-36,0r0,-178r36,0r0,72r51,0r0,-72r37,0r0,72xm146,-28v27,0,51,4,51,-27v0,-31,-24,-26,-51,-26r0,53","w":240,"k":{"\u045e":7,"\u0454":-2,"\u044a":6,"\u0447":2,"\u0443":7,"\u0442":9,"\u0441":-2,"\u0435":-2}},"\u045b":{"d":"90,-144v-47,8,-28,91,-32,144r-37,0r0,-201r-25,0r0,-22r25,0r0,-22r37,0r0,22r57,0r0,22r-57,0r0,53v10,-17,23,-26,42,-26v73,-1,41,106,48,174r-37,0r0,-100v0,-27,0,-42,-21,-44","w":164},"\u045c":{"d":"22,-178r36,0r0,80r58,-80r36,0r-46,62r51,116r-40,0r-35,-89r-24,33r0,56r-36,0r0,-178xm60,-212r56,-50r19,24r-62,39","w":153,"k":{"\u045e":-10,"\u0454":1,"\u0444":4,"\u0441":1,"\u043e":1,"\u0437":-3,"\u0435":2,"\u0430":-2}},"\u045e":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38xm15,-243r25,0v4,26,54,27,58,0r25,0v-6,29,-24,43,-54,43v-30,0,-48,-14,-54,-43","w":128,"k":{"\u0454":1,"\u044f":-1,"\u0447":-5,"\u0444":2,"\u0442":-15,"\u0441":1,"\u043e":1,"\u043b":1,"\u0437":-2,"\u0435":2,"\u0434":10,"\u0430":2}},"\u045f":{"d":"22,0r0,-178r36,0r0,150r49,0r0,-150r37,0r0,178r-46,0r-3,41r-25,0r-3,-41r-45,0"},"\u0490":{"d":"139,-285r0,78r-76,0r0,207r-40,0r0,-240r85,0r0,-45r31,0","w":135},"\u0491":{"d":"86,-178r0,-38r29,0r0,66r-57,0r0,150r-36,0r0,-178r64,0","w":115},"\u1e80":{"d":"1,-240r40,0r33,180r37,-180r35,0r37,180r34,-180r34,0r-51,241r-36,0r-38,-177r-37,177r-36,0xm164,-273r-13,13r-62,-39r19,-24","w":251},"\u1e81":{"d":"0,-178r36,0r26,122r26,-122r32,0r25,123r28,-123r30,0r-44,178r-31,0r-27,-123r-26,123r-31,0xm138,-212r-13,13r-62,-39r19,-24","w":202},"\u1e82":{"d":"1,-240r40,0r33,180r37,-180r35,0r37,180r34,-180r34,0r-51,241r-36,0r-38,-177r-37,177r-36,0xm94,-273r56,-50r19,24r-62,39","w":251},"\u1e83":{"d":"0,-178r36,0r26,122r26,-122r32,0r25,123r28,-123r30,0r-44,178r-31,0r-27,-123r-26,123r-31,0xm75,-212r56,-50r19,24r-62,39","w":202},"\u1e84":{"d":"1,-240r40,0r33,180r37,-180r35,0r37,180r34,-180r34,0r-51,241r-36,0r-38,-177r-37,177r-36,0xm100,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm156,-265v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":251},"\u1e85":{"d":"0,-178r36,0r26,122r26,-122r32,0r25,123r28,-123r30,0r-44,178r-31,0r-27,-123r-26,123r-31,0xm73,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v10,0,19,9,19,19v0,10,-9,18,-19,18xm129,-204v-10,0,-19,-8,-19,-18v0,-9,10,-19,19,-19v9,0,19,10,19,19v0,10,-9,18,-19,18","w":202},"\u1ef2":{"d":"-11,-240r43,0r44,100r45,-100r38,0r-67,139r0,101r-40,0r0,-101xm109,-273r-13,13r-62,-39r19,-24","w":147},"\u1ef3":{"d":"0,-178r37,0r31,122r31,-122r33,0r-57,189v-8,37,-27,61,-71,50r0,-29v33,4,38,-7,46,-38xm100,-212r-13,13r-62,-39r19,-24","w":128},"\u2015":{"d":"11,-104r205,0r0,28r-205,0r0,-28","w":226},"\u2017":{"d":"0,18r180,0r0,25r-180,0r0,-25xm0,60r180,0r0,25r-180,0r0,-25","w":180},"\u201b":{"d":"57,-240r0,45r-17,0r21,43r-18,0r-24,-45r0,-43r38,0","w":79},"\u2032":{"d":"37,-144r-27,0r27,-96r40,0","w":76},"\u2033":{"d":"35,-144r-28,0r28,-96r40,0xm106,-144r-27,0r27,-96r40,0","w":136},"\u203c":{"d":"20,-240r49,0r-12,175r-24,0xm106,-240r49,0r-12,175r-24,0xm24,-44r41,0r0,44r-41,0r0,-44xm111,-44r40,0r0,44r-40,0r0,-44","w":180},"\u203e":{"d":"-7,-329r214,0r0,13r-214,0r0,-13","w":199},"\u2044":{"d":"61,-240r26,0r-117,240r-26,0","w":30},"\u207f":{"d":"69,-164v-1,-13,0,-20,-11,-20v-26,2,-13,60,-16,88r-28,0r0,-108r21,0r0,16v17,-30,63,-23,63,23r0,69r-29,0r0,-68","w":110},"\u20a4":{"d":"54,-161v-4,-49,17,-84,63,-83v28,0,48,12,58,38r-28,17v-6,-17,-17,-25,-30,-25v-23,0,-28,27,-24,53r49,0r0,26r-45,0v1,8,2,16,3,23r42,0r0,26r-41,0v-1,23,-11,42,-29,55v45,1,77,0,88,-32r28,14v-13,67,-105,45,-181,49r0,-32v39,3,58,-13,58,-54r-38,0r0,-26r35,0r-4,-23r-31,0r0,-26r27,0","w":183},"\u20a7":{"d":"152,-167v-2,53,-28,78,-90,73r0,94r-39,0r0,-240v73,-5,132,3,129,73xm111,-168v-1,-32,-12,-46,-49,-42r0,86v36,2,50,-9,49,-44xm222,1v-52,13,-70,-20,-63,-79r-19,0r0,-27r20,0r2,-40r30,-3r0,43r26,0r0,27r-26,0v-2,33,0,59,30,51r0,28xm323,-50v20,28,-9,54,-43,54v-28,0,-45,-11,-49,-33r28,-7v1,27,49,23,35,0v-22,-11,-60,-14,-59,-42v1,-42,82,-48,90,-6r-25,9v-4,-23,-41,-20,-29,2v11,5,51,14,52,23","w":341},"\u2105":{"d":"70,-223v-21,0,-19,18,-21,44v-4,45,36,53,38,13r27,2v-3,30,-18,46,-46,46v-32,0,-48,-21,-48,-63v0,-75,88,-86,94,-19r-27,3v-1,-16,-3,-26,-17,-26xm182,-240r25,0r-117,240r-25,0xm207,-122v34,1,48,26,49,62v0,43,-17,64,-50,64v-35,0,-51,-24,-50,-63v0,-42,17,-63,51,-63xm227,-60v0,-28,-7,-43,-21,-43v-14,0,-21,15,-21,43v0,28,7,43,21,43v14,0,21,-15,21,-43","w":275},"\u2113":{"d":"132,-244v17,0,28,14,27,33v0,35,-21,73,-63,115v-7,37,-11,59,-11,67v0,7,2,11,6,11v8,4,14,-22,23,-25v4,0,6,2,6,7v1,18,-21,41,-39,41v-27,0,-30,-40,-25,-72v-11,11,-16,16,-20,3v2,-13,15,-18,22,-29v8,-42,18,-78,30,-107v12,-29,26,-44,44,-44xm101,-126v19,-21,37,-51,39,-82v0,-10,-2,-15,-7,-15v-10,0,-21,32,-32,97","w":183},"\u2116":{"d":"22,-240r47,0r78,173r0,-173r34,0r0,240r-37,0r-89,-192r0,192r-33,0r0,-240xm258,-183v36,-1,53,25,52,62v0,43,-17,64,-52,64v-35,0,-52,-24,-52,-63v0,-42,17,-63,52,-63xm279,-120v0,-28,-7,-43,-21,-43v-14,0,-21,15,-21,43v0,28,7,42,21,42v14,0,21,-14,21,-42xm310,-30r0,30r-104,0r0,-30r104,0","w":318},"\u212e":{"d":"16,-93v0,-86,99,-132,157,-75v18,17,28,42,29,75r-146,0r0,65v37,35,99,25,122,-22r13,7v-23,32,-40,48,-82,49v-55,2,-93,-44,-93,-99xm161,-106r0,-53v-28,-28,-79,-28,-105,1r0,52r105,0","w":216},"\u215b":{"d":"208,-146v46,-5,66,51,24,68v49,20,26,86,-27,80v-52,6,-71,-59,-23,-75v-41,-19,-22,-78,26,-73xm208,-126v-27,3,-24,33,2,39v25,-7,23,-38,-2,-39xm207,-19v35,-5,25,-36,-5,-44v-29,9,-25,46,5,44xm51,-241r22,0r0,123r25,0r0,22r-81,0r0,-22r27,0r0,-87v-8,7,-17,13,-27,18r0,-27v14,-7,25,-15,34,-27xm176,-240r26,0r-117,240r-26,0","w":275},"\u215c":{"d":"214,-146v46,-5,66,51,23,68v49,19,27,86,-26,80v-52,6,-71,-59,-23,-75v-41,-19,-22,-78,26,-73xm214,-126v-27,2,-25,34,2,39v24,-7,22,-39,-2,-39xm212,-19v18,0,33,-18,18,-31v-4,-4,-11,-8,-22,-13v-29,8,-25,44,4,44xm34,-181v20,0,38,1,37,-19v-2,-28,-37,-25,-40,1r-26,-6v6,-50,97,-52,96,2v0,14,-7,25,-22,31v51,18,23,78,-25,78v-31,0,-48,-13,-53,-41r27,-6v0,30,46,33,46,2v0,-18,-18,-22,-40,-21r0,-21xm184,-240r26,0r-117,240r-26,0","w":275},"\u215d":{"d":"215,-146v46,-5,66,51,24,68v49,19,27,85,-26,80v-52,6,-73,-59,-24,-75v-41,-19,-22,-78,26,-73xm215,-126v-27,3,-24,33,2,39v25,-7,23,-39,-2,-39xm214,-19v17,0,31,-17,18,-31v-4,-4,-11,-8,-22,-13v-30,8,-27,44,4,44xm110,-146v7,60,-95,72,-103,14r27,-6v5,31,46,27,46,-7v0,-30,-37,-33,-44,-10r-22,-4r4,-81r84,0r-3,25r-58,0r-2,32v28,-26,75,-3,71,37xm184,-240r26,0r-117,240r-26,0","w":275},"\u215e":{"d":"202,-146v46,-5,66,51,24,68v48,20,26,85,-26,80v-52,6,-73,-59,-24,-75v-41,-19,-22,-78,26,-73xm202,-126v-27,3,-24,33,2,39v25,-7,23,-38,-2,-39xm201,-19v17,0,31,-17,18,-31v-4,-4,-11,-8,-22,-13v-30,8,-27,44,4,44xm17,-240r92,0r0,19v-27,34,-41,76,-41,125r-32,0v0,-45,14,-85,43,-119r-64,0xm166,-240r26,0r-117,240r-26,0","w":275},"\u2190":{"d":"86,-154r14,0v-9,20,-21,38,-34,54r280,0r0,18r-280,0v12,12,23,30,34,54r-13,0v-26,-30,-51,-50,-73,-60r0,-7v21,-8,44,-28,72,-59","w":360},"\u2191":{"d":"27,-163v31,-28,50,-51,58,-72r9,0v10,22,29,46,59,72r0,14v-24,-11,-42,-23,-54,-35r0,259r-18,0r0,-259v-16,13,-34,26,-54,35r0,-14","w":180},"\u2192":{"d":"273,-154v28,31,52,51,73,59r0,7v-22,10,-47,30,-73,60r-13,0v11,-24,22,-42,34,-54r-280,0r0,-18r280,0v-13,-16,-25,-34,-34,-54r13,0","w":360},"\u2193":{"d":"27,3r0,-14v20,9,38,22,54,35r0,-259r18,0r0,259v12,-12,30,-24,54,-35r0,14v-30,26,-49,50,-59,72r-9,0v-8,-21,-27,-44,-58,-72","w":180},"\u2194":{"d":"346,-95r0,8v-21,9,-45,29,-71,59r-14,0v8,-20,19,-38,34,-54r-230,0v15,16,26,34,34,54r-14,0v-26,-30,-50,-50,-71,-59r0,-8v21,-9,45,-29,71,-59r14,0v-8,20,-19,38,-34,54r230,0v-15,-16,-26,-34,-34,-54r14,0v26,30,50,50,71,59","w":360},"\u2195":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71","w":180},"\u21a8":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71xm27,92r126,0r0,17r-126,0r0,-17","w":180},"\u221f":{"d":"64,-225r17,0r0,207r208,0r0,18r-225,0r0,-225","w":352},"\u2229":{"d":"129,-209v-94,-4,-75,111,-76,209r-19,0r0,-83v-7,-95,20,-137,95,-145v76,8,103,49,96,145r0,83r-19,0r0,-84v5,-79,-13,-122,-77,-125","w":258},"\u2261":{"d":"165,-155r-147,0r0,-29r147,0r0,29xm165,-105r-147,0r0,-30r147,0r0,30xm165,-56r-147,0r0,-29r147,0r0,29","w":183},"\u2302":{"d":"27,0r0,-111r81,-92r81,92r0,111r-162,0xm41,-14r134,0r0,-91r-67,-76r-67,76r0,91","w":216},"\u2310":{"d":"55,0r-41,0r0,-96r156,0r0,37r-115,0r0,59","w":183},"\u2320":{"d":"156,-270v-15,2,-23,-30,-33,-10r-2,371r-25,0r0,-319v-1,-42,18,-73,51,-77v26,-3,34,32,9,35","w":217},"\u2321":{"d":"61,55v16,-2,23,30,34,10r1,-370r25,0r0,318v2,43,-18,74,-51,78v-25,3,-33,-33,-9,-36","w":217},"\u2500":{"d":"259,-94r-263,0r0,-31r263,0r0,31","w":255},"\u2502":{"d":"112,109r0,-437r31,0r0,437r-31,0","w":255},"\u250c":{"d":"259,-125r0,31r-116,0r0,203r-31,0r0,-234r147,0","w":255},"\u2510":{"d":"112,-94r-116,0r0,-31r147,0r0,234r-31,0r0,-203","w":255},"\u2514":{"d":"112,-94r0,-234r31,0r0,203r116,0r0,31r-147,0","w":255},"\u2518":{"d":"143,-94r-147,0r0,-31r116,0r0,-203r31,0r0,234","w":255},"\u251c":{"d":"112,109r0,-437r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0","w":255},"\u2524":{"d":"112,109r0,-203r-116,0r0,-31r116,0r0,-203r31,0r0,437r-31,0","w":255},"\u252c":{"d":"112,-94r-116,0r0,-31r263,0r0,31r-116,0r0,203r-31,0r0,-203","w":255},"\u2534":{"d":"259,-94r-263,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31","w":255},"\u253c":{"d":"112,-94r-116,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0r0,-203","w":255},"\u2550":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u2551":{"d":"146,109r0,-437r30,0r0,437r-30,0xm79,109r0,-437r31,0r0,437r-31,0","w":255},"\u2552":{"d":"112,109r0,-267r147,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0","w":255},"\u2553":{"d":"79,109r0,-234r180,0r0,31r-83,0r0,203r-30,0r0,-203r-36,0r0,203r-31,0","w":255},"\u2554":{"d":"110,109r-31,0r0,-267r180,0r0,31r-149,0r0,236xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0","w":255},"\u2555":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r147,0r0,267r-31,0r0,-169","w":255},"\u2556":{"d":"79,109r0,-203r-83,0r0,-31r180,0r0,234r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u2557":{"d":"146,109r0,-236r-150,0r0,-31r180,0r0,267r-30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169","w":255},"\u2558":{"d":"112,-60r0,-268r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-147,0","w":255},"\u2559":{"d":"259,-94r-180,0r0,-234r31,0r0,203r36,0r0,-203r30,0r0,203r83,0r0,31","w":255},"\u255a":{"d":"110,-328r0,237r149,0r0,31r-180,0r0,-268r31,0xm176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170","w":255},"\u255b":{"d":"143,-60r-147,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,268","w":255},"\u255c":{"d":"176,-94r-180,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,234","w":255},"\u255d":{"d":"146,-328r30,0r0,268r-180,0r0,-31r150,0r0,-237xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0","w":255},"\u255e":{"d":"112,109r0,-437r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0","w":255},"\u255f":{"d":"146,109r0,-437r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0xm79,109r0,-437r31,0r0,437r-31,0","w":255},"\u2560":{"d":"79,109r0,-437r31,0r0,437r-31,0xm146,-127r0,-201r30,0r0,170r83,0r0,31r-113,0xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0","w":255},"\u2561":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,437r-31,0r0,-169","w":255},"\u2562":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,437r-30,0xm146,109r0,-437r30,0r0,437r-30,0","w":255},"\u2563":{"d":"146,109r0,-437r30,0r0,437r-30,0xm109,-328r0,201r-113,0r0,-31r83,0r0,-170r30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169","w":255},"\u2564":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm112,-60r-116,0r0,-31r263,0r0,31r-116,0r0,169r-31,0r0,-169","w":255},"\u2565":{"d":"79,109r0,-203r-83,0r0,-31r263,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u2566":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0","w":255},"\u2567":{"d":"259,-127r-263,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u2568":{"d":"259,-94r-263,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31","w":255},"\u2569":{"d":"109,-127r-113,0r0,-31r83,0r0,-170r30,0r0,201xm259,-127r-113,0r0,-201r30,0r0,170r83,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u256a":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0r0,-169","w":255},"\u256b":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u256c":{"d":"176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0","w":255},"\u2580":{"d":"259,-109r-263,0r0,-219r263,0r0,219","w":255},"\u2584":{"d":"259,109r-263,0r0,-218r263,0r0,218","w":255},"\u2588":{"d":"-4,109r0,-437r263,0r0,437r-263,0","w":255},"\u258c":{"d":"-4,109r0,-437r131,0r0,437r-131,0","w":255},"\u2590":{"d":"128,109r0,-437r131,0r0,437r-131,0","w":255},"\u2591":{"d":"0,-328r21,0r0,22r-21,0r0,-22xm85,-328r21,0r0,22r-21,0r0,-22xm170,-328r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm170,-240r21,0r0,22r-21,0r0,-22xm85,-240r21,0r0,22r-21,0r0,-22xm0,-240r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm0,-152r21,0r0,22r-21,0r0,-22xm85,-152r21,0r0,22r-21,0r0,-22xm170,-152r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm0,-65r21,0r0,22r-21,0r0,-22xm85,-65r21,0r0,22r-21,0r0,-22xm170,-65r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm170,23r21,0r0,22r-21,0r0,-22xm85,23r21,0r0,22r-21,0r0,-22xm0,23r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22","w":255},"\u2592":{"d":"21,-328r21,0r0,22r-21,0r0,-22xm64,-328r21,0r0,22r-21,0r0,-22xm106,-328r21,0r0,22r-21,0r0,-22xm148,-328r22,0r0,22r-22,0r0,-22xm191,-328r21,0r0,22r-21,0r0,-22xm233,-328r21,0r0,22r-21,0r0,-22xm0,-284r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm85,-284r21,0r0,22r-21,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm170,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm21,-240r21,0r0,22r-21,0r0,-22xm64,-240r21,0r0,22r-21,0r0,-22xm106,-240r21,0r0,22r-21,0r0,-22xm148,-240r22,0r0,22r-22,0r0,-22xm191,-240r21,0r0,22r-21,0r0,-22xm233,-240r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm85,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm170,-196r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm0,-196r21,0r0,22r-21,0r0,-22xm21,-152r21,0r0,22r-21,0r0,-22xm64,-152r21,0r0,22r-21,0r0,-22xm106,-152r21,0r0,22r-21,0r0,-22xm148,-152r22,0r0,22r-22,0r0,-22xm191,-152r21,0r0,22r-21,0r0,-22xm233,-152r21,0r0,22r-21,0r0,-22xm0,-109r21,0r0,22r-21,0r0,-22xm85,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm170,-109r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm233,-65r21,0r0,22r-21,0r0,-22xm191,-65r21,0r0,22r-21,0r0,-22xm148,-65r22,0r0,22r-22,0r0,-22xm106,-65r21,0r0,22r-21,0r0,-22xm64,-65r21,0r0,22r-21,0r0,-22xm21,-65r21,0r0,22r-21,0r0,-22xm0,-21r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm85,-21r21,0r0,22r-21,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm170,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm233,23r21,0r0,22r-21,0r0,-22xm191,23r21,0r0,22r-21,0r0,-22xm148,23r22,0r0,22r-22,0r0,-22xm106,23r21,0r0,22r-21,0r0,-22xm64,23r21,0r0,22r-21,0r0,-22xm21,23r21,0r0,22r-21,0r0,-22xm0,67r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm85,67r21,0r0,22r-21,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm170,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22","w":255},"\u2593":{"d":"254,-262r0,66r-21,0r0,22r21,0r0,65r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,21r-254,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-66r21,0r0,-22r21,0r0,22r22,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r22,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,44r-21,0r0,22r21,0xm21,-284r0,22r21,0r0,-22r-21,0xm64,-284r0,22r21,0r0,-22r-21,0xm106,-284r0,22r21,0r0,-22r-21,0xm148,-284r0,22r22,0r0,-22r-22,0xm191,-284r0,22r21,0r0,-22r-21,0xm233,-240r-21,0r0,22r21,0r0,-22xm191,-240r-21,0r0,22r21,0r0,-22xm148,-240r-21,0r0,22r21,0r0,-22xm106,-240r-21,0r0,22r21,0r0,-22xm64,-240r-22,0r0,22r22,0r0,-22xm21,-196r0,22r21,0r0,-22r-21,0xm64,-196r0,22r21,0r0,-22r-21,0xm106,-196r0,22r21,0r0,-22r-21,0xm148,-196r0,22r22,0r0,-22r-22,0xm191,-196r0,22r21,0r0,-22r-21,0xm64,-152r-22,0r0,22r22,0r0,-22xm85,-152r0,22r21,0r0,-22r-21,0xm127,-152r0,22r21,0r0,-22r-21,0xm170,-152r0,22r21,0r0,-22r-21,0xm212,-152r0,22r21,0r0,-22r-21,0xm21,-109r0,22r21,0r0,-22r-21,0xm106,-109r0,22r21,0r0,-22r-21,0xm85,-87r0,-22r-21,0r0,22r21,0xm148,-109r0,22r22,0r0,-22r-22,0xm191,-109r0,22r21,0r0,-22r-21,0xm233,-43r0,-22r-21,0r0,22r21,0xm191,-43r0,-22r-21,0r0,22r21,0xm148,-43r0,-22r-21,0r0,22r21,0xm106,-43r0,-22r-21,0r0,22r21,0xm64,-43r0,-22r-22,0r0,22r22,0xm21,-21r0,22r21,0r0,-22r-21,0xm64,-21r0,22r21,0r0,-22r-21,0xm106,-21r0,22r21,0r0,-22r-21,0xm148,-21r0,22r22,0r0,-22r-22,0xm191,-21r0,22r21,0r0,-22r-21,0xm233,45r0,-22r-21,0r0,22r21,0xm191,45r0,-22r-21,0r0,22r21,0xm148,45r0,-22r-21,0r0,22r21,0xm106,45r0,-22r-21,0r0,22r21,0xm64,45r0,-22r-22,0r0,22r22,0xm21,67r0,22r21,0r0,-22r-21,0xm64,67r0,22r21,0r0,-22r-21,0xm106,67r0,22r21,0r0,-22r-21,0xm148,67r0,22r22,0r0,-22r-22,0xm191,67r0,22r21,0r0,-22r-21,0","w":255},"\u25a0":{"d":"26,-166r166,0r0,166r-166,0r0,-166","w":217},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"112,-167r0,96r-96,0r0,-96r96,0","w":127},"\u25ab":{"d":"112,-167r0,96r-96,0r0,-96r96,0xm98,-153r-68,0r0,68r68,0r0,-68","w":127},"\u25ac":{"d":"0,-124r360,0r0,68r-360,0r0,-68","w":360},"\u25b2":{"d":"53,0r125,-249r125,249r-250,0","w":356},"\u25ba":{"d":"51,-249r255,127r-255,127r0,-254","w":356},"\u25bc":{"d":"303,-244r-125,249r-125,-249r250,0","w":356},"\u25c4":{"d":"306,-249r0,254r-255,-127","w":356},"\u25cb":{"d":"31,-102v2,-43,34,-77,78,-77v44,0,76,33,77,77v1,41,-36,78,-77,78v-41,0,-80,-37,-78,-78xm173,-102v-1,-36,-28,-64,-64,-64v-36,0,-64,26,-64,64v0,35,29,65,64,65v35,0,64,-31,64,-65","w":217},"\u25cf":{"d":"109,-179v41,0,77,36,77,77v0,41,-36,78,-77,78v-41,0,-78,-37,-78,-78v0,-41,37,-77,78,-77","w":217},"\u25d8":{"d":"22,0r0,-172r173,0r0,172r-173,0xm144,-86v0,-19,-16,-36,-35,-36v-19,0,-37,16,-36,36v0,19,17,35,36,35v19,0,35,-16,35,-35","w":217},"\u25d9":{"d":"7,0r0,-203r203,0r0,203r-203,0xm186,-101v-1,-44,-33,-78,-77,-78v-45,0,-76,34,-78,78v-1,41,37,77,78,77v41,0,79,-35,77,-77xm45,-101v0,-38,28,-65,64,-65v36,0,63,28,64,65v0,35,-29,64,-64,64v-35,0,-64,-29,-64,-64","w":217},"\u25e6":{"d":"64,-169v26,0,50,24,50,50v0,27,-23,50,-50,50v-27,0,-50,-22,-50,-50v0,-27,23,-50,50,-50xm64,-82v20,0,37,-17,37,-37v0,-20,-17,-37,-37,-37v-20,0,-37,17,-37,37v0,20,17,37,37,37","w":127},"\u263a":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm276,-91v0,-56,-42,-96,-96,-96v-54,0,-96,40,-96,96v0,55,40,96,96,96v56,0,96,-41,96,-96xm123,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm209,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm232,-55v-15,42,-88,44,-104,0r11,-6v16,34,66,33,82,0","w":360},"\u263b":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm151,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm237,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm128,-55v15,42,88,44,104,0r-11,-6v-16,34,-66,33,-82,0","w":360},"\u263c":{"d":"97,-201v21,-13,34,-22,62,-25r0,-59r13,0r0,59v28,2,42,11,61,25r51,-50r9,9r-50,51v15,18,23,36,25,62r59,0r0,12r-59,0v-2,23,-10,43,-25,62r50,51r-10,9r-49,-50v-21,15,-32,22,-62,25r0,59r-13,0r0,-59v-28,-4,-43,-10,-61,-24r-52,49r-9,-9r50,-51v-14,-18,-22,-35,-25,-62r-59,0r0,-12r59,0v2,-28,10,-43,25,-61r-50,-51r9,-10xm255,-123v0,-52,-39,-90,-90,-90v-51,0,-90,38,-90,90v0,52,38,90,90,90v52,0,90,-38,90,-90","w":329},"\u2640":{"d":"227,-173v2,48,-40,92,-87,92r0,71r81,0r0,10r-81,0r0,77r-10,0r0,-77r-81,0r0,-10r81,0r0,-71v-47,-3,-87,-42,-87,-92v0,-53,39,-92,92,-92v53,0,91,39,92,92xm217,-173v-1,-47,-35,-82,-82,-82v-47,0,-82,35,-83,82v-1,44,38,83,83,83v45,0,83,-38,82,-83","w":270},"\u2642":{"d":"20,-46v-1,-59,58,-109,121,-87r63,-136r-94,47r-4,-10r108,-53r6,3r29,117r-10,3r-25,-102r-63,135v30,15,53,44,53,83v0,52,-40,92,-93,92v-52,0,-90,-39,-91,-92xm194,-46v-2,-47,-35,-82,-83,-82v-48,1,-80,35,-82,82v-1,45,38,83,82,83v44,1,84,-38,83,-83","w":270},"\u2660":{"d":"117,-82v-10,43,-87,45,-84,-5v3,-61,81,-67,85,-129v6,56,81,73,86,128v2,20,-18,40,-39,40v-23,-1,-35,-15,-45,-34v0,50,20,72,67,75r1,7r-139,0r1,-7v46,1,68,-28,67,-75","w":236},"\u2663":{"d":"178,-48v-32,-3,-44,-17,-58,-42v2,56,20,74,72,84r1,6r-149,0r1,-6v52,-7,68,-32,71,-84v-13,52,-106,57,-106,-7v0,-38,36,-63,71,-40v-27,-30,-5,-79,37,-79v41,0,64,47,37,79v31,-22,71,0,71,39v0,27,-20,52,-48,50","w":236},"\u2665":{"d":"118,-172v6,-54,96,-58,96,0v0,72,-83,110,-96,176v-11,-65,-87,-105,-96,-174v-3,-25,21,-47,45,-46v27,1,44,19,51,44","w":236},"\u2666":{"d":"118,4v-26,-44,-41,-62,-81,-110v21,-23,63,-78,81,-111v17,33,60,87,81,111v-17,18,-66,81,-81,110","w":236},"\u266a":{"d":"7,-33v-1,-37,44,-54,78,-35r0,-172v69,-5,91,20,88,87r-17,0v3,-35,-20,-48,-53,-47r0,147v12,65,-94,84,-96,20","w":180},"\u266b":{"d":"15,-17v-1,-38,45,-54,79,-35r0,-171r140,-44r0,195v12,66,-94,79,-97,19v-1,-37,46,-54,79,-36r0,-127r-105,32r0,147v3,41,-20,57,-55,59v-26,1,-41,-15,-41,-39","w":270},"\uf001":{"d":"27,-178v-3,-56,18,-73,69,-68r0,30v-27,-3,-36,5,-33,38r31,0r0,30r-31,0r0,148r-36,0r0,-148r-23,0r0,-30r23,0xm151,-201r-38,0r0,-39r38,0r0,39xm114,-178r36,0r0,178r-36,0r0,-178","w":171},"\uf002":{"d":"27,-178v-3,-56,18,-73,69,-68r0,30v-27,-3,-36,5,-33,38r31,0r0,30r-31,0r0,148r-36,0r0,-148r-23,0r0,-30r23,0xm113,-240r37,0r0,240r-37,0r0,-240","w":171},"\uf003":{"d":"65,-243r32,0r0,91r19,0r0,23r-19,0r0,33r-29,0r0,-33r-59,0r0,-20xm69,-150r0,-66r-36,66r36,0","w":122},"\uf004":{"d":"88,-240r34,0r-26,67r-17,0","w":180},"\uf005":{"d":"75,19r33,0r-26,65r-16,0","w":180},"\u00a4":{"d":"123,-174r25,-25r20,20r-25,25v12,18,12,42,0,61r25,24r-21,21r-25,-24v-20,11,-41,11,-60,-1r-25,25r-20,-20r24,-25v-11,-19,-11,-43,0,-61r-25,-25r21,-21r25,25v18,-12,44,-10,61,1xm92,-154v-16,-1,-31,14,-31,30v0,16,15,31,31,31v17,0,31,-15,31,-31v0,-17,-14,-30,-31,-30","w":184}}});
