﻿volumeBtn._alpha = controlBtn._alpha = rew._alpha = frw._alpha = fullBtn._alpha = fullBtn.shrink._alpha= controlBtn.stopBtn._alpha = controlBtn.playBtn._alpha = controlBtn.volumeBtn._alpha = controlBtn.frw._alpha = controlBtn.rew._alpha = 0;

controlBtn.onRelease = function() {
	if (playing) {
		playing = false;
		
		controlBtn.playBtn.fade(100,10);
		controlBtn.stopBtn.fade(0,10);
		controlBtn.volumeBtn.fade(0,20);
		
		hideArrows();
		ns.pause(true);
		trace(ns.time);
	} else {
		playing = true;
		
		myThumb.fade(0,10);
		clearInterval(thumbListener);
		
		controlBtn.playBtn.fade(0,10);
		controlBtn.stopBtn.fade(100,10);
		controlBtn.volumeBtn.fade(0,20);
		hideArrows();
		ns.pause(false);
		trace(ns.time);
	}
};

function showControls() {
	controlBtn.fade(100,8);
	rew.fade(50,8);
	frw.fade(50,8);
	fullBtn.fade(100,8);
	volumeBtn.fade(100,8);
	hideAudio();
	hideArrows();
	clearInterval(forward);
	clearInterval(rewind);
}

function hideControls() {
	controlBtn.fade(0,8);
	volumeBtn.fade(0,8);
	rew.fade(0,8);
	frw.fade(0,8);
	fullBtn.fade(0,8);

	clearInterval(forward);
	clearInterval(rewind);
}

function fastForward() {
	ns.seek(ns.time+1);
	rew.fade(50,10);
	frw.fade(100,10);
}
function fastRewind() {
	ns.seek(ns.time-2);
	rew.fade(100,10);
	frw.fade(50,10);
}


controlBtn.onRollOver = function() {
	showControls();
};
controlBtn.onRollOut = function() {
	hideControls();
};

hitLeft.onRollOver = function() {
	showControls();
};
hitLeft.onRollOut = function() {
	hideControls();
};
hitRight.onRollOver = function() {
	showControls();
};
hitRight.onRollOut = function() {
	hideControls();
};

hitLeft.onPress = function() {
	rewind = setInterval(fastRewind, 50);
};
hitLeft.onRelease = function() {
	clearInterval(rewind);
	rew.fade(50,10);
	frw.fade(50,10);
};
hitLeft.onDragOut = function() {
	clearInterval(rewind);
	rew.fade(50,10);
	frw.fade(50,10);
};
hitRight.onPress = function() {
	forward = setInterval(fastForward, 50);
};
hitRight.onRelease = function() {
	clearInterval(forward);
	rew.fade(50,10);
	frw.fade(50,10);
};
hitRight.onDragOut = function() {
	clearInterval(forward);
	rew.fade(50,10);
	frw.fade(50,10);
};
fullBtn.onRollOver = function () {
	showControls();
	}
fullBtn.onRollOut = function () {
	hideControls();
	}
fullBtn.onRelease = function () {
	goFullscreen();
}


function hideArrows() {
	rew.fade(50,10);
	frw.fade(50,10);
}


watermark.bg._alpha = 40;
watermark.onRollOver = function () {
	this.bg.fade(100,6);
	}
watermark.onRollOut = function () {
	this.bg.fade(40,6);
	}
watermark.onRelease = function () {
	if (_root.watermarkURL == null) {
		getURL("http://www.flvplayerlite.com","_blank");
		} else {
		getURL(_root.watermarkURL,"_blank");
		}
	}
	
volumeBtn.volMinus._alpha = volumeBtn.volPlus._alpha = 50;

volumeBtn.volMinus.onRollOver = function () {
	showControls();
	showAudio();
	this.fade(100,10);
	}
volumeBtn.volMinus.onRollOut = function () {
	hideAudio();
	this.fade(50,10);
	}
volumeBtn.volMinus.onPress = function () {
	lessVolume = setInterval(decreaseVolume, 50);
	}
volumeBtn.volMinus.onRelease = function () {
	clearInterval(lessVolume);
	}
volumeBtn.volMinus.onDragOut = function() { 
	clearInterval(lessVolume);
	this.fade(50,10);
}
	
volumeBtn.volPlus.onRollOver = function () {
	showControls();
	showAudio();
	
	this.fade(100,10);
	}
volumeBtn.volPlus.onRollOut = function () {
	hideAudio();
	this.fade(50,10);
	}
volumeBtn.volPlus.onPress = function () {
	moreVolume = setInterval(increaseVolume, 50);
	}
volumeBtn.volPlus.onRelease = function () {
	clearInterval(moreVolume);
	}
volumeBtn.volPlus.onDragOut = function() { 
	clearInterval(moreVolume);
	this.fade(50,10);
}
if (_root.showControls == "true") {
	showControls();
}
if (_root.vidVolume != null) {
	audio.setVolume(_root.vidVolume);
	trace(_root.vidVolume);
}
