﻿var videoContainer:String;

if (_root.vidPath == undefined) {
	videoContainer = "video.flv"; 
} else {
	videoContainer = _root.vidPath;
}

var nc:NetConnection = new NetConnection();
nc.connect(null);
var ns:NetStream = new NetStream(nc);
myVideo.attachVideo(ns);
myVideo.smoothing = true;

audio = new Sound();
myVolume = 100;
audio.setVolume(myVolume); 

ns.setBufferTime(5);
ns.play(videoContainer);

ns.onStatus = function(infoObject) {
	if (infoObject.code == "NetStream.Play.Stop") {
		if (_root.playlistPath == null) {
			
			trace ("no playlist");
			
			if (_root.autoLoop == "true") {
				ns.seek(0);
				ns.play();
				
			} else {
				ns.seek(0);
				ns.pause(true);
				
				playing = false;
				controlBtn.playBtn.fade(100,10);
				controlBtn.stopBtn.fade(0,10);
				
				cover.fade(0,10);
				loading.fade(0,10);	
				
				if (_root.thumbPath != null) {
					myThumb.fade(100,10);
				}
			}
			
			
		} else {
			
						selVideo = _root.selectedVid + 1;
						totVideo = _parent.playlist.myXML.firstChild.childNodes.length;
						trace ("selected video:"+selVideo+" total videos:"+totVideo);
						
						if (selVideo == totVideo) {
							trace("EoF");
							_root.selectedVid = -1;
							}
						v = _root.selectedVid+1;

					
						nextvideoPath = _parent.playlist.myXML.firstChild.childNodes[v].attributes.url;
						ns.play(nextvideoPath);
						
						_root.selectedVid = _root.selectedVid + 1;
						
						trace("playlist active, playing this video: " + nextvideoPath);
			
		}
		}
	if (infoObject.code == "NetStream.Buffer.Empty") {
		cover.fade(50,10);
		loading.fade(100,10);
		}
	if (infoObject.code == "NetStream.Buffer.Full") {
		cover.fade(0,10);
		loading.fade(0,10);
		}
	trace(infoObject.code);
};

var videoInterval = setInterval(videoStatus,100);
var amountLoaded:Number;
var duration:Number;

ns["onMetaData"] = function(obj) {
	duration = obj.duration;
	
	if (_root.vidHeight == undefined & _root.vidWidth == undefined) {
		_root.vidHeight = obj.height;
		_root.vidWidth = obj.width;
	}
	
	trace("Total video duration: "+duration);
	
	for (var propName:String in obj) {
	trace(propName + " = " + obj[propName]);
	}
	
	_root.metaHeight = obj.height;
	_root.metaWidth = obj.width;
	
	arrangeStage();
}

function videoStatus() {
		
		amountLoaded = ns.bytesLoaded / ns.bytesTotal;

		bar.loadbar.easeTo(Math.floor(amountLoaded * bar.bg._width),3, 5);
		
		if (bar.loadbar._width > bar.bg._width) {
			bar.loadbar._width = bar.bg._width;
			}
		seekbarWidth = Math.floor( (ns.time/duration * bar.bg._width) );
		bar.seekbar.easeTo(seekbarWidth, 3, 5);
		
	
}


function seekbarInteraction() {
	mainbarWidth = bar.bg._width;
	if (_root.playerLite == null | _root.playerLite == undefined) {
		if (Stage.displayState == "fullScreen") {
				ns.seek((_xmouse/Stage.width)*duration);
				} else {
				ns.seek((_xmouse/mainbarWidth)*duration);
				}
	}
	else {
		
		if (Stage.displayState == "fullScreen") {
			ns.seek((_xmouse/Stage.width)*duration);
			} else {
			ns.seek((_parent._xmouse/mainbarWidth)*duration);
			}
	myThumb.fade(0,10);
	}
}
bar.onPress = function () {
	seekbarInteraction();
	}
bar.onMouseDown = function () {
	if (_root.playerLite == null | _root.playerLite == undefined) {
		if (this.hitTest(_parent._xmouse, _parent._ymouse)) {
					seekin = setInterval(seekbarInteraction,50);
		}
	
	} else {
		
		if (this.hitTest(_parent._xmouse, _parent._ymouse)) {
			seekin = setInterval(seekbarInteraction,50);
		}else {
			clearInterval(seekin);
			}
		}
	}
bar.onMouseUp = function() {
	clearInterval(seekin);
	}
bar.onRelease = function() {
	seekbarInteraction();
	clearInterval(seekin);
	}
bar.onReleaseOutside = function() {
	seekbarInteraction();
	clearInterval(seekin);
	}
	
bar.onRollOver = function() {
	bar.easeTo(bar.bg._width, 24, 4);
	}
bar.onRollOut = function() {
	bar.easeTo(bar.bg._width, 9, 4);
	}



if (_root.autoPlay == "true") {
	ns.play();
	playing = true;
	myThumb._visible=false;
}
if (_root.autoPlay == "false") {
	ns.pause(true);
	playing = false;
}
if (_root.autoPlay == undefined) {
	ns.pause(true);
	playing = false;
}
if (_root.thumbPath == "") {
	ns.seek(0.01);
	trace("no thumbnail");
	}