﻿// the tweening classes for animating the buttons
import mx.transitions.Tween;
import mx.transitions.easing.*;

// main setup of the thumbnails, edit also the movieclip with this sizes to get a perfect alignment
var thumbWidth = 110; // the width of the thumbnail
var thumbHeight = 60; // and its height
var thumbPadding = 2; // space between one thumbnail and another

var videoNum = 0; // the index of playing video

var myXML:XML = new XML();
myXML.ignoreWhite = true;

myXML.onLoad = function() {
	trace(myXML.firstChild.childNodes.length+" videos in the playlist");
	var thumbNum = myXML.firstChild.childNodes.length;
	var playlist:Array = this.firstChild.childNodes;
	
	for (i=0; i<playlist.length; i++) {

		//check nodes in the trace
		trace(myXML.firstChild.childNodes[i].attributes.desc);
		trace(myXML.firstChild.childNodes[i].attributes.url);
		trace(myXML.firstChild.childNodes[i].attributes.thumb);
		
		// duplicate my buttons
		myBtn = btn.duplicateMovieClip("btn"+i, i);
		setProperty("btn"+i, _x, ((thumbWidth+thumbPadding)*i));
		myBtn.caption._x = int(thumbWidth*.5);
		myBtn.caption._y = int(thumbHeight*.5);
		myBtn.caption._alpha = 0;
		myBtn.caption.title.text = myXML.firstChild.childNodes[i].attributes.desc;
		myBtn.path = myXML.firstChild.childNodes[i].attributes.url;
		trace(myBtn);

		myBtn.videoNum = [i];
		//myBtn.videoNum = _root.playlist.myXML.firstChild.childNodes[i].attributes.id;

		// action for playing videos
		myBtn.onPress = function() {
			
			_parent.playerLite.ns.play(this.path);
			_parent.playerLite.myThumb.fade(0,10);
			_parent.playerLite.clearInterval(thumbListener);
			_parent.playerLite.controlBtn.playBtn.fade(0,10);
			_parent.playerLite.controlBtn.stopBtn.fade(100,10);
			_parent.playerLite.controlBtn.volumeBtn.fade(0,20);
			//_parent.playerLite.hideArrows();
			_parent.playerLite.playing = true;
			
			_root.selectedVid = -1; // BUG to fix! videoNum doesn't pass correctly
			_global.thumbClicked = 1;
			trace(_root.selectedVid);

		};
		myBtn.caption._xscale = myBtn.caption._yscale=50;
		
		// stuff for my buttons
		myBtn.onRollOver = function() {
			this.swapDepths( this._parent.getNextHighestDepth() );
			new Tween(this, "_y", Regular.easeOut, this._y, 14, 0.5, true);
			new Tween(this.thumb, "_yscale", Regular.easeOut, this.thumb._yscale, 125, 0.5, true);
			new Tween(this.thumb, "_xscale", Regular.easeOut, this.thumb._xscale, 125, 0.5, true);
			new Tween(this.ref, "_yscale", Regular.easeOut, this.ref._yscale, 125, 0.5, true);
			new Tween(this.ref, "_xscale", Regular.easeOut, this.ref._xscale, 125, 0.5, true);
			new Tween(this.alphaRef, "_yscale", Regular.easeOut, this.alphaRef._yscale, 125, 0.5, true);
			new Tween(this.alphaRef, "_xscale", Regular.easeOut, this.alphaRef._xscale, 125, 0.5, true);
			new Tween(this.caption, "_alpha", Linear.easeOut, this.caption._alpha, 100, 0.2, true);
			new Tween(this.caption, "_xscale", Linear.easeOut, this.caption._xscale, 100, 0.2, true);
			new Tween(this.caption, "_yscale", Linear.easeOut, this.caption._yscale, 100, 0.2, true);
		};
		myBtn.onRollOut = function() {
			new Tween(this, "_y", Regular.easeOut, this._y, 0, 0.5, true);
			new Tween(this.thumb, "_yscale", Regular.easeOut, this.thumb._yscale, 100, 0.5, true);
			new Tween(this.thumb, "_xscale", Regular.easeOut, this.thumb._xscale, 100, 0.5, true);
			new Tween(this.ref, "_yscale", Regular.easeOut, this.ref._yscale, 100, 0.5, true);
			new Tween(this.ref, "_xscale", Regular.easeOut, this.ref._xscale, 100, 0.5, true);
			new Tween(this.alphaRef, "_yscale", Regular.easeOut, this.alphaRef._yscale, 100, 0.5, true);
			new Tween(this.alphaRef, "_xscale", Regular.easeOut, this.alphaRef._xscale, 100, 0.5, true);
			new Tween(this.caption, "_alpha", Linear.easeOut, this.caption._alpha, 0, 0.2, true);
			new Tween(this.caption, "_xscale", Linear.easeOut, this.caption._xscale, 50, 0.2, true);
			new Tween(this.caption, "_yscale", Linear.easeOut, this.caption._yscale, 50, 0.2, true);
		};
		
		
		// thumbnail manager with alpha and smoothing
		thumbContainer = myXML.firstChild.childNodes[i].attributes.thumb;

		var myThumb = myBtn.thumb.createEmptyMovieClip("myThumb", 0);
		var inner_thumb = myThumb.createEmptyMovieClip("inner_thumb", 0);

		var thumbLoader:MovieClipLoader = new MovieClipLoader();

		var thumbFetcher:Object = new Object();

		thumbFetcher.onLoadInit = function(target:MovieClip) {
			target.forceSmoothing = true;
			new Tween(target, "_alpha", Linear.easeOut, 0, 100, 0.2, true);
			target._x = -thumbWidth*.5;
			target._y = -thumbHeight*.5;
			target._width = thumbWidth;
			target._height = thumbHeight;
			
			if (i == myXML.firstChild.childNodes.length) {
				trace("playlist ready");
				//_parent.playlist._x = Stage.width*.5-_parent.playlist._width*.5;
				_parent.playlist._x = 0;
				}
		};
		thumbFetcher.onLoadProgress = function(target:MovieClip) {
			target._alpha = 0;

		};
		thumbLoader.addListener(thumbFetcher);
		thumbLoader.loadClip(thumbContainer,inner_thumb);
		
		
		// reflection
		var myRef = myBtn.ref.createEmptyMovieClip("myRef", 0);
		var inner_ref = myRef.createEmptyMovieClip("inner_ref", 0);

		var refLoader:MovieClipLoader = new MovieClipLoader();

		var refFetcher:Object = new Object();

		refFetcher.onLoadInit = function(target:MovieClip) {
			target.forceSmoothing = true;
			new Tween(target, "_alpha", Linear.easeOut, 0, 100, 0.2, true);
			target._x = -thumbWidth*.5;
			target._y = -thumbHeight*.5;
			target._width = thumbWidth;
			target._height = thumbHeight;

		};
		refFetcher.onLoadProgress = function(target:MovieClip) {
			target._alpha = 0;

		};
		refLoader.addListener(refFetcher);
		refLoader.loadClip(thumbContainer,inner_ref);
		
		
		
	}
	track._width = ((thumbWidth+thumbPadding)*thumbNum);
	track._height = thumbHeight;

	btn._visible = false;
	
	
	// I'm telling the player to pickup the first xml video
	_root.vidPath = myXML.firstChild.childNodes[0].attributes.url;
	trace("primo video: "+_root.vidPath);
	_parent.playerLite.ns.play(_root.vidPath);
	if (_root.autoPlay == "true") {
	_parent.playerLite.ns.play();
	_parent.playerLite.ns.seek(0);
	}
	if (_root.autoPlay == "false") {
	_parent.playerLite.ns.pause();
	_parent.playerLite.ns.seek(0);
	}
};

myXML.load(_root.playlistPath);