<?php
class html {
	private static $doctype;
	private static $content = "";
	private static $client_root;
	private static $server_root;
	public static function set_root($client, $server) {
		self::$client_root = $client;
		self::$server_root = $server;
	}
	public static function declare_doctype($doctype) {
		switch (strtolower(trim($doctype))) {
			case "xhtml":
			case "xhtml transitional":
			case "xhtml 1.0":
			case "xhtml 1.0 transitional":
			case "xhtml 1":
			case "xhtml 1 transitional":
				self::$doctype = "xhtml";
				self::$content .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
				break;
			case "xhtml strict":
			case "xhtml 1 strict":
			case "xhtml 1.0 strict":
				self::$doctype = "xhtml";
				self::$content .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
				break;
			case "xhtml frameset":
			case "xhtml 1 frameset":
			case "xhtml 1.0 frameset":
				self::$doctype = "xhtml";
				self::$content .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">';
				break;
			case "html":
			case "html 5":
				self::$content .= "<!DOCTYPE HTML>";
				break;
			case "html 4":
			case "html 4 loose":
			case "html 4 transitional":
			case "html 4.01":
			case "html 4.01 loose":
			case "html 4.01 transitional":
				self::$content .= '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">';
				break;
			case "html 4 strict":
			case "html 4.01 strict":
				self::$content .= '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">';
				break;
			case "html 4 frameset":
			case "html 4.01 frameset":
				self::$content .= '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">';
				break;
		}
		self::$content .= "\r\n";
	}
	
	public static function set_title($title) {
		self::$content .= "<title>$title</title>";
		self::$content .= "\r\n";
	}
	
	public static function write_js($string) {
		self::$content .= "<script type='text/javascript'>$string</script>";
	}
	
	public static function write_css($string) {
		self::$content .= "<style type='text/css'>$string</style>";
	}
	
	public static function write_html($string) {
		self::$content .= "<style type='text/css'>$string</style>";
	}
	
	public static function include_js($path) {
		self::$content .=  "<script type='text/javascript' src='".self::$client_root."/js/$path'></script>";
		self::$content .= "\r\n";
	}
	
	public static function include_css($path) {
		self::$content .=  "<style type='text/css'>@import \"".self::$client_root."/css/$path\";</style>";
		self::$content .= "\r\n";
	}
	
	public static function include_php($path) {
		$client_root = self::$client_root;
		$server_root = self::$server_root;
		ob_start();
		include self::$server_root . "/php/includes/$path";
		self::$content .= ob_get_clean();
		self::$content .= "\r\n";
	}

	public static function include_js_module($module) {
		switch(strtolower(trim($module))) {
			case "jquery":
				self::include_js("jquery/jquery.js");
				break;
			case "ajaxtabs":
				self::include_js("ajaxtabs/ajaxtabs.js");
				self::include_css("ajaxtabs/ajaxtabs.css");
				break;
			case "swfobject":
				self::include_js("swfobject/swfobject.js");
				break;
			case "thickbox":
				self::include_js("thickbox/thickbox.js");
				self::include_css("thickbox/thickbox.css");
				break;
			case "codaslider":
				self::include_js("codaslider/jquery-easing.js");
				self::include_js("codaslider/jquery-easing-compatibility.js");
				self::include_js("codaslider/codaslider.js");
				break;
		}
	}
	
	public static function begin_section($section) {
		switch (strtolower(trim($section))) {
			case "head":
				if (self::$doctype == "xhtml")
					self::$content .= "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head>";
				else
					self::$content .= "<html><head>";
				break;
			case "body":
				self::$content .= "<body>";
				break;
		}
		self::$content .= "\r\n";
	}
	
	public static function end_section($section) {
		switch (strtolower(trim($section))) {
			case "head":
				self::$content .= "</head>";
				break;
			case "body":
				self::$content .= "</body></html>";
				break;
		}
		self::$content .= "\r\n";
	}
	
	public static function render() {
		echo self::$content;
	}
}
?>